/*
 * Decompiled with CFR 0.152.
 */
package cn.org.atool.fluent.mybatis.base.provider;

import cn.org.atool.fluent.mybatis.base.crud.BatchCrudImpl;
import cn.org.atool.fluent.mybatis.base.crud.IUpdate;
import cn.org.atool.fluent.mybatis.base.entity.IMapping;
import cn.org.atool.fluent.mybatis.base.entity.TableId;
import cn.org.atool.fluent.mybatis.base.model.FieldMapping;
import cn.org.atool.fluent.mybatis.base.provider.CommonSqlKit;
import cn.org.atool.fluent.mybatis.base.provider.StatementBuilder;
import org.apache.ibatis.executor.keygen.KeyGenerator;
import org.apache.ibatis.executor.keygen.NoKeyGenerator;

public class OracleSqlKit
extends CommonSqlKit {
    @Override
    public KeyGenerator insert(StatementBuilder builder, FieldMapping primary, TableId tableId) {
        if (this.isAutoKeyGenerator(tableId)) {
            return NoKeyGenerator.INSTANCE;
        }
        return builder.handleSelectKey(primary, tableId);
    }

    @Override
    protected boolean isSelectInsert(IMapping mapping, boolean withPk, TableId tableId) {
        return true;
    }

    @Override
    public String batchCrud(IMapping mapping, BatchCrudImpl crud) {
        String sql = crud.batchSql(mapping, this);
        return OracleSqlKit.wrapperBeginEnd(sql);
    }

    @Override
    public String updateBy(IMapping mapping, IUpdate[] updaters) {
        String sql = super.updateBy(mapping, updaters);
        return updaters.length == 1 ? sql : OracleSqlKit.wrapperBeginEnd(sql);
    }

    public static String wrapperBeginEnd(String sql) {
        return "BEGIN " + sql + "; END;";
    }
}

