/*
 * Decompiled with CFR 0.152.
 */
package cn.org.atool.fluent.mybatis.base.provider;

import cn.org.atool.fluent.mybatis.If;
import cn.org.atool.fluent.mybatis.base.IEntity;
import cn.org.atool.fluent.mybatis.base.crud.BaseQuery;
import cn.org.atool.fluent.mybatis.base.crud.IQuery;
import cn.org.atool.fluent.mybatis.base.crud.IUpdate;
import cn.org.atool.fluent.mybatis.base.crud.IWrapper;
import cn.org.atool.fluent.mybatis.base.entity.IMapping;
import cn.org.atool.fluent.mybatis.base.entity.IRichEntity;
import cn.org.atool.fluent.mybatis.base.entity.PkGeneratorKits;
import cn.org.atool.fluent.mybatis.base.entity.TableId;
import cn.org.atool.fluent.mybatis.base.model.FieldMapping;
import cn.org.atool.fluent.mybatis.base.model.ISqlOp;
import cn.org.atool.fluent.mybatis.base.model.InsertList;
import cn.org.atool.fluent.mybatis.base.model.SqlOp;
import cn.org.atool.fluent.mybatis.base.model.UpdateDefault;
import cn.org.atool.fluent.mybatis.base.provider.SqlKit;
import cn.org.atool.fluent.mybatis.base.provider.StatementBuilder;
import cn.org.atool.fluent.mybatis.exception.FluentMybatisException;
import cn.org.atool.fluent.mybatis.mapper.MapperSql;
import cn.org.atool.fluent.mybatis.metadata.DbType;
import cn.org.atool.fluent.mybatis.segment.fragment.Column;
import cn.org.atool.fluent.mybatis.segment.fragment.IFragment;
import cn.org.atool.fluent.mybatis.segment.fragment.JoiningFrag;
import cn.org.atool.fluent.mybatis.segment.fragment.KeyFrag;
import cn.org.atool.fluent.mybatis.segment.model.WrapperData;
import cn.org.atool.fluent.mybatis.utility.MybatisUtil;
import cn.org.atool.fluent.mybatis.utility.RefKit;
import cn.org.atool.fluent.mybatis.utility.SqlProviderKit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.ibatis.executor.keygen.Jdbc3KeyGenerator;
import org.apache.ibatis.executor.keygen.KeyGenerator;
import org.apache.ibatis.executor.keygen.NoKeyGenerator;

public class CommonSqlKit
implements SqlKit {
    static final Map<String, String> SEQs = new HashMap<String, String>();

    @Override
    public KeyGenerator insert(StatementBuilder builder, FieldMapping primary, TableId tableId) {
        if (tableId == null) {
            return NoKeyGenerator.INSTANCE;
        }
        if (this.isAutoKeyGenerator(tableId)) {
            return Jdbc3KeyGenerator.INSTANCE;
        }
        return builder.handleSelectKey(primary, tableId);
    }

    @Override
    public KeyGenerator insertBatch(IMapping mapping, StatementBuilder builder, FieldMapping primary, TableId tableId) {
        if (tableId == null) {
            return NoKeyGenerator.INSTANCE;
        }
        if (this.isAutoKeyGenerator(tableId)) {
            return Jdbc3KeyGenerator.INSTANCE;
        }
        if (tableId.isSeqBefore(mapping.db())) {
            return NoKeyGenerator.INSTANCE;
        }
        return builder.handleSelectKey(primary, tableId);
    }

    protected boolean isAutoKeyGenerator(TableId tableId) {
        return tableId.auto && If.isBlank(tableId.seqName);
    }

    @Override
    public <E extends IEntity> String insertEntity(IMapping mapping, String prefix, E entity, boolean withPk) {
        MybatisUtil.assertNotNull("entity", entity);
        withPk = this.validateInsertEntity(mapping, entity, withPk, mapping.defaultSetter()::setInsertDefault, mapping.tableId());
        MapperSql sql = new MapperSql();
        sql.INSERT_INTO(CommonSqlKit.dynamic(entity, mapping));
        InsertList inserts = this.insertColumns(mapping, prefix, entity, withPk);
        sql.INSERT_COLUMNS(mapping, inserts.columns);
        sql.VALUES();
        sql.APPEND(MapperSql.brackets(", ", inserts.values));
        return sql.toString();
    }

    private InsertList insertColumns(IMapping mapping, String prefix, IEntity entity, boolean withPk) {
        InsertList inserts = new InsertList();
        List<FieldMapping> fields = mapping.allFields();
        Map<String, Object> map = entity.toEntityMap();
        for (FieldMapping f : fields) {
            if (f.isPrimary() && !withPk) continue;
            inserts.add(prefix, f, map.get(f.name), f.insert);
        }
        return inserts;
    }

    @Override
    public String insertSelect(IMapping mapping, String tableName, String[] fields, IQuery query) {
        MybatisUtil.assertNotBlank("tableName", tableName);
        String columns = Stream.of(fields).map(arg_0 -> ((DbType)mapping.db()).wrap(arg_0)).collect(Collectors.joining(", "));
        if (If.isBlank(columns)) {
            ArrayList<String> list = new ArrayList<String>();
            List<String> items = MybatisUtil.splitByComma(query.data().getSelect().get(mapping));
            for (String item : items) {
                String[] arr = (String[])MybatisUtil.splitBySpace(item).stream().filter(If::notBlank).toArray(String[]::new);
                list.add(arr[arr.length - 1]);
            }
            columns = String.join((CharSequence)", ", list);
        }
        MybatisUtil.assertNotBlank("fields", columns);
        MybatisUtil.assertNotNull("ew", query);
        if (!query.data().hasSelect()) {
            ((BaseQuery)query).select(fields);
        }
        return MybatisUtil.joinWithSpace(KeyFrag.INSERT_INTO.key(), tableName, MapperSql.brackets(columns), query.data().sql(false).get(mapping));
    }

    @Override
    public <E extends IEntity> String insertBatch(IMapping mapping, Collection<E> entities, boolean withPk, TableId tableId) {
        MapperSql sql = new MapperSql();
        List<Map> maps = this.toMaps(mapping, entities, withPk);
        List<FieldMapping> nonFields = this.nonFields(mapping, maps, withPk);
        String tableName = CommonSqlKit.dynamic(entities, mapping);
        sql.INSERT_INTO(tableName);
        if (this.isSelectInsert(mapping, withPk, tableId)) {
            this.insertSelect(mapping, tableId, withPk, sql, maps, nonFields);
        } else {
            this.insertValues(mapping, sql, maps, nonFields);
        }
        return sql.toString();
    }

    protected boolean isSelectInsert(IMapping mapping, boolean withPk, TableId tableId) {
        return !withPk && tableId != null && tableId.isSeqBefore(mapping.db());
    }

    protected void insertSelect(IMapping mapping, TableId tableId, boolean withPk, MapperSql sql, List<Map> maps, List<FieldMapping> nonFields) {
        ArrayList<String> columns = new ArrayList<String>();
        if (!withPk && tableId != null) {
            columns.add(tableId.column);
        }
        nonFields.stream().map(f -> f.column).forEach(columns::add);
        sql.INSERT_COLUMNS(mapping, columns);
        sql.APPEND("SELECT");
        if (!withPk && tableId != null) {
            String seq = If.isBlank(tableId.seqName) ? mapping.db().feature.getSeq() : tableId.seqName;
            sql.APPEND(CommonSqlKit.getSeq(seq) + ",");
        }
        sql.APPEND("TMP.* FROM (");
        for (int index = 0; index < maps.size(); ++index) {
            if (index > 0) {
                sql.APPEND(" UNION ALL ");
            }
            sql.APPEND("(SELECT");
            boolean first = true;
            for (FieldMapping f2 : nonFields) {
                if (f2.isPrimary() && !withPk) continue;
                if (!first) {
                    sql.APPEND(", ");
                } else {
                    first = false;
                }
                Object value = maps.get(index).get(f2.column);
                if (value == null && If.notBlank(f2.insert)) {
                    sql.APPEND(f2.insert);
                    continue;
                }
                String el = InsertList.el("list[" + index + "].", f2, value, "");
                sql.APPEND(If.isBlank(el) ? f2.column : el);
            }
            sql.APPEND(" FROM DUAL)");
        }
        sql.APPEND(") TMP");
    }

    protected void insertValues(IMapping mapping, MapperSql sql, List<Map> maps, List<FieldMapping> nonFields) {
        ArrayList<String> columns = new ArrayList<String>();
        nonFields.stream().map(f -> f.column).forEach(columns::add);
        sql.INSERT_COLUMNS(mapping, columns);
        sql.VALUES();
        ArrayList<String> values = new ArrayList<String>();
        for (int index = 0; index < maps.size(); ++index) {
            ArrayList<String> lines = new ArrayList<String>();
            for (FieldMapping f2 : nonFields) {
                lines.add(InsertList.el("list[" + index + "].", f2, maps.get(index).get(f2.column), f2.insert));
            }
            values.add(MapperSql.brackets(", ", lines));
        }
        sql.APPEND(String.join((CharSequence)", ", values));
    }

    @Override
    public IUpdate logicDeleteByIds(IMapping mapping, Collection ids) {
        return this.logicDeleteByIds(mapping, ids.toArray());
    }

    @Override
    public IUpdate logicDeleteByIds(IMapping mapping, Object[] ids) {
        MybatisUtil.assertNotEmpty("ids", ids);
        Object updater = mapping.updater();
        updater.data().segments().where.clear();
        updater.data().setIgnoreLockVersion(true);
        String logicDeleteColumn = mapping.logicDeleteColumn();
        if (If.isBlank(logicDeleteColumn)) {
            throw new FluentMybatisException("logic delete column(@LogicDelete) not found.");
        }
        if (mapping.longTypeOfLogicDelete()) {
            updater.updateSet(logicDeleteColumn, CommonSqlKit.currentTimeMillis());
        } else {
            updater.updateSet(logicDeleteColumn, true);
        }
        String primary = mapping.primaryId(true);
        if (ids.length == 1) {
            updater.where().apply(primary, (ISqlOp)SqlOp.EQ, ids[0]);
        } else {
            updater.where().apply(primary, (ISqlOp)SqlOp.IN, ids);
        }
        return updater;
    }

    @Override
    public IQuery queryByIds(IMapping mapping, Collection ids) {
        return this.queryByIds(mapping, ids.toArray());
    }

    @Override
    public IQuery queryByIds(IMapping mapping, Object[] ids) {
        MybatisUtil.assertNotEmpty("ids", ids);
        Object query = mapping.emptyQuery();
        String primary = mapping.primaryId(true);
        if (ids.length == 1) {
            query.where().apply(primary, (ISqlOp)SqlOp.EQ, ids[0]);
        } else {
            query.where().apply(primary, (ISqlOp)SqlOp.IN, ids);
        }
        return query;
    }

    @Override
    public String deleteBy(IMapping mapping, WrapperData ew) {
        if (ew.getCustomizedSql().notEmpty()) {
            return ew.getCustomizedSql().get(mapping);
        }
        MapperSql mapperSql = new MapperSql();
        mapperSql.DELETE_FROM(mapping, ew.table(), ew);
        mapperSql.WHERE_GROUP_ORDER_BY(mapping, ew);
        return mapperSql.toString();
    }

    @Override
    public void setLogicDeleted(IMapping mapping, IUpdate update) {
        String logicDeleted = mapping.logicDeleteColumn();
        MybatisUtil.assertNotNull("logical delete field of table(" + mapping.getTableName() + ")", logicDeleted);
        if (mapping.longTypeOfLogicDelete()) {
            update.updateSet(logicDeleted, CommonSqlKit.currentTimeMillis());
        } else {
            update.updateSet(logicDeleted, true);
        }
    }

    @Override
    public void eqByMap(IMapping mapping, IWrapper wrapper, boolean isColumn, Map<String, Object> condition) {
        Map<String, FieldMapping> fields = isColumn ? mapping.getColumnMap() : mapping.getFieldsMap();
        for (Map.Entry<String, Object> entry : condition.entrySet()) {
            String key = entry.getKey();
            FieldMapping f = fields.get(key);
            if (f == null) {
                String err = isColumn ? "Column[" + key + "] of Table[" + mapping.getTableName() + "]" : "Field[" + key + "] of Entity[" + mapping.entityClass().getSimpleName() + "]";
                throw new FluentMybatisException(err + " is not found.");
            }
            Object value = entry.getValue();
            if (value == null) {
                wrapper.where().apply(f.column, (ISqlOp)SqlOp.IS_NULL, new Object[0]);
                continue;
            }
            wrapper.where().apply(f.column, (ISqlOp)SqlOp.EQ, value);
        }
    }

    @Override
    public IUpdate logicDeleteBy(IMapping mapping, IQuery query) {
        if (query.data().getCustomizedSql().notEmpty()) {
            throw new FluentMybatisException("Logical deletion does not support custom SQL.");
        }
        Object update = mapping.updater();
        this.setLogicDeleted(mapping, (IUpdate)update);
        update.data().replacedByQuery(query);
        return update;
    }

    private static long currentTimeMillis() {
        return System.currentTimeMillis();
    }

    @Override
    public String updateBy(IMapping mapping, IUpdate[] updaters) {
        ArrayList<String> list = new ArrayList<String>(updaters.length);
        int index = 0;
        for (IUpdate updater : updaters) {
            String sql = this.updateBy(mapping, updater.data());
            sql = SqlProviderKit.addEwParaIndex(sql, String.format("[%d]", index));
            ++index;
            list.add(sql.trim());
        }
        return String.join((CharSequence)";\n", list);
    }

    @Override
    public String updateBy(IMapping mapping, WrapperData ew) {
        MybatisUtil.assertNotNull("data of updater", ew);
        if (ew.getCustomizedSql().notEmpty()) {
            return ew.getCustomizedSql().get(mapping);
        }
        Map<IFragment, String> updates = ew.getUpdates();
        MybatisUtil.assertNotEmpty("updates", updates);
        MapperSql mapperSql = new MapperSql();
        mapperSql.UPDATE(mapping, ew.table(), ew);
        JoiningFrag needDefaults = CommonSqlKit.updateDefaults(mapping, ew.getWrapper(), updates, ew.ignoreVersion());
        String version = mapping.versionColumn();
        if (If.notBlank(version)) {
            if (ew.ignoreVersion()) {
                needDefaults.removeColumn(version);
            } else if (!ew.getEqWhere().containsKey(version)) {
                throw new RuntimeException("@Version field of where condition not set.");
            }
        }
        needDefaults.add(ew.update());
        mapperSql.SET(mapping, needDefaults);
        mapperSql.WHERE_GROUP_ORDER_BY(mapping, ew);
        mapperSql.LIMIT(ew, true);
        return mapperSql.toString();
    }

    @Override
    public IUpdate updateById(IMapping mapping, IEntity entity) {
        MybatisUtil.assertNotNull("entity", entity);
        Object update = mapping.updater();
        update.data().segments().where.clear();
        List<FieldMapping> fields = mapping.allFields();
        FieldMapping primary = null;
        FieldMapping version = null;
        Map<String, Object> values = entity.toColumnMap();
        for (FieldMapping f : fields) {
            Object value = values.get(f.column);
            Column column = Column.set((IWrapper)update, f.column);
            if (f.isPrimary()) {
                primary = f;
                continue;
            }
            if (f.isVersion()) {
                version = f;
                update.data().updateSql(column, f.update, new Object[0]);
                continue;
            }
            if (value != null) {
                update.updateSet(f.column, value);
                continue;
            }
            if (!If.notBlank(f.update)) continue;
            update.data().updateSql(column, f.update, new Object[0]);
        }
        if (primary == null) {
            throw new IllegalArgumentException("Primary of entity[" + entity.entityClass().getSimpleName() + "] is not found.");
        }
        update.where().apply(primary.column, (ISqlOp)SqlOp.EQ, values.get(primary.column));
        if (version != null) {
            MybatisUtil.assertNotNull("lock version field(" + version.name + ")", values.get(version.column));
            update.where().apply(version.column, (ISqlOp)SqlOp.EQ, values.get(version.column));
        }
        return update;
    }

    @Override
    public String countNoLimit(IMapping mapping, WrapperData ew) {
        if (ew.getCustomizedSql().notEmpty()) {
            return ew.getCustomizedSql().get(mapping);
        }
        return this.count(mapping, ew, false);
    }

    @Override
    public String count(IMapping mapping, WrapperData ew) {
        if (ew.getCustomizedSql().notEmpty()) {
            return ew.getCustomizedSql().get(mapping);
        }
        return this.count(mapping, ew, true);
    }

    private String count(IMapping mapping, WrapperData ew, boolean withLimit) {
        MapperSql text = new MapperSql();
        text.COUNT(mapping, ew.table(), ew);
        text.WHERE_GROUP_BY(mapping, ew);
        String sql = text.toString();
        if (withLimit) {
            sql = ew.wrappedByPaged(sql).get(mapping);
        }
        if (ew.hasGroupBy()) {
            return MybatisUtil.joinWithSpace(KeyFrag.SELECT.key(), "COUNT(*)", KeyFrag.FROM.key(), MapperSql.brackets(sql), MapperSql.tmpTable());
        }
        return sql;
    }

    @Override
    public String queryBy(IMapping mapping, WrapperData ew) {
        return ew.sql(true).get(mapping);
    }

    protected <E extends IEntity> List<Map> toMaps(IMapping mapping, Collection<E> entities, boolean withPk) {
        ArrayList<Map> maps = new ArrayList<Map>(entities.size());
        for (IEntity entity : entities) {
            this.validateInsertEntity(mapping, entity, withPk, mapping.defaultSetter()::setInsertDefault, mapping.tableId());
            maps.add(entity.toColumnMap());
        }
        return maps;
    }

    protected List<FieldMapping> nonFields(IMapping mapping, List<Map> maps, boolean withPk) {
        HashSet set = new HashSet();
        maps.forEach(m -> set.addAll(m.keySet()));
        List<FieldMapping> fields = mapping.allFields();
        return fields.stream().filter(f -> set.contains(f.column) || If.notBlank(f.insert)).filter(f -> !f.isPrimary() || withPk).collect(Collectors.toList());
    }

    private boolean validateInsertEntity(IMapping mapping, IEntity entity, boolean withPk, Consumer<IEntity> setByDefault, TableId tableId) {
        Object oldId = entity.findPk();
        PkGeneratorKits.setPkByGenerator(entity);
        Object newId = entity.findPk();
        if (tableId == null || !tableId.isSeqBefore(mapping.db())) {
            if (withPk || oldId == null && newId != null) {
                MybatisUtil.isTrue(newId != null, "The pk of insert entity can't be null, you should use method insert without pk.", new Object[0]);
            } else {
                MybatisUtil.isTrue(newId == null, "The pk of insert entity must be null, you should use method insert with pk.", new Object[0]);
            }
        }
        setByDefault.accept(entity);
        return newId != null;
    }

    static String dynamic(IEntity entity, IMapping mapping) {
        IFragment fragment = RefKit.byEntity(entity.entityClass()).table(entity);
        String tableName = fragment.get(mapping);
        if (entity instanceof IRichEntity) {
            String dynamic = entity.tableSupplier();
            return If.isBlank(dynamic) ? tableName : dynamic;
        }
        return tableName;
    }

    static <E extends IEntity> String dynamic(Collection<E> entities, IMapping mapping) {
        Set tables = entities.stream().map(e -> CommonSqlKit.dynamic(e, mapping)).collect(Collectors.toSet());
        if (tables.size() != 1) {
            throw new RuntimeException("Cannot batch insert data into multiple target tables:" + tables);
        }
        return (String)tables.iterator().next();
    }

    static JoiningFrag updateDefaults(IMapping mapping, IWrapper wrapper, Map<IFragment, String> updates, boolean ignoreLockVersion) {
        List<FieldMapping> fields = mapping.allFields();
        UpdateDefault defaults = new UpdateDefault(updates);
        for (FieldMapping f : fields) {
            if (If.isBlank(f.update) || f.isVersion() && ignoreLockVersion) continue;
            defaults.add(wrapper, f, f.update);
        }
        return defaults.getUpdateDefaults();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String getSeq(String seq) {
        if (SEQs.containsKey(seq)) {
            return SEQs.get(seq);
        }
        Map<String, String> map = SEQs;
        synchronized (map) {
            int index;
            if (SEQs.containsKey(seq)) {
                return SEQs.get(seq);
            }
            String upper = seq.toUpperCase().trim();
            String value = seq;
            if (upper.startsWith(KeyFrag.SELECT.name())) {
                value = value.substring(6);
                upper = upper.substring(6);
            }
            if ((index = upper.indexOf(KeyFrag.FROM.name())) > 0 && upper.endsWith("DUAL")) {
                value = value.substring(0, index);
            }
            SEQs.put(seq, value.trim());
            return SEQs.get(seq);
        }
    }
}

