/*
 * Decompiled with CFR 0.152.
 */
package cn.org.atool.fluent.mybatis.base.model;

import cn.org.atool.fluent.mybatis.base.model.ISqlOp;
import java.util.Collection;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum SqlOp implements ISqlOp
{
    IS_NULL("IS NULL", 0),
    NOT_NULL("IS NOT NULL", 0),
    EQ("= ?", "= %s", 1),
    NE("<> ?", "<> %s", 1),
    GT("> ?", "> %s", 1),
    GE(">= ?", ">= %s", 1),
    LT("< ?", "< %s", 1),
    LE("<= ?", "<= %s", 1),
    BETWEEN("BETWEEN ? AND ?", "BETWEEN %s", 2),
    NOT_BETWEEN("NOT BETWEEN ? AND ?", "NOT BETWEEN %s", 2),
    LIKE("LIKE ?", "LIKE %s", 1),
    NOT_LIKE("NOT LIKE ?", "NOT LIKE %s", 1),
    IN("IN (%s)", -1),
    NOT_IN("NOT IN (%s)", -1),
    EXISTS("EXISTS (%s)", -1),
    NOT_EXISTS("NOT EXISTS (%s)", -1),
    BRACKET("(%s)", -1),
    RETAIN("%s", -1);

    private final String placeHolder;
    private final String expression;
    private final int argSize;

    private SqlOp(String placeHolder, int argSize) {
        this.placeHolder = placeHolder;
        this.expression = placeHolder;
        this.argSize = argSize;
    }

    private SqlOp(String placeHolder, String expression, int argSize) {
        this.placeHolder = placeHolder;
        this.expression = expression;
        this.argSize = argSize;
    }

    static String placeHolder(String placeHolder, Object ... values) {
        String replacedStr;
        if (values.length == 1 && values[0] instanceof Collection) {
            Collection list = (Collection)values[0];
            replacedStr = list.stream().map(v -> "?").collect(Collectors.joining(", "));
        } else {
            replacedStr = Stream.of(values).map(v -> "?").collect(Collectors.joining(", "));
        }
        return String.format(placeHolder, replacedStr);
    }

    @Override
    public String getPlaceHolder() {
        return this.placeHolder;
    }

    @Override
    public String getExpression() {
        return this.expression;
    }

    @Override
    public int getArgSize() {
        return this.argSize;
    }
}

