/*
 * Decompiled with CFR 0.152.
 */
package cn.org.atool.fluent.mybatis.base.crud;

import cn.org.atool.fluent.mybatis.base.IEntity;
import cn.org.atool.fluent.mybatis.base.entity.IMapping;
import cn.org.atool.fluent.mybatis.base.mapper.IRichMapper;
import cn.org.atool.fluent.mybatis.base.mapper.QueryExecutor;
import cn.org.atool.fluent.mybatis.segment.BaseWrapper;
import cn.org.atool.fluent.mybatis.segment.OrderByBase;
import cn.org.atool.fluent.mybatis.segment.WhereBase;
import cn.org.atool.fluent.mybatis.segment.model.WrapperData;
import cn.org.atool.fluent.mybatis.utility.MybatisUtil;
import cn.org.atool.fluent.mybatis.utility.RefKit;
import java.util.Optional;
import java.util.function.Function;

public interface IQuery<E extends IEntity> {
    public Optional<IMapping> mapping();

    public <Q extends IQuery<E>> Q distinct();

    public <Q extends IQuery<E>> Q selectAll();

    public <Q extends IQuery<E>> Q selectId();

    public <Q extends IQuery<E>> Q limit(int var1);

    public <Q extends IQuery<E>> Q limit(int var1, int var2);

    default public <Q extends IQuery<E>> Q paged(int currPage, int pageSize) {
        MybatisUtil.assertTrue("The currPage must be greater than one.", currPage >= 1);
        MybatisUtil.assertTrue("The pageSize must be greater than one.", pageSize >= 1);
        return this.limit((currPage - 1) * pageSize, pageSize);
    }

    public <Q extends IQuery<E>> Q last(String var1);

    public WhereBase where();

    public OrderByBase orderBy();

    public WrapperData data();

    default public QueryExecutor<E> to() {
        Class entityClass = ((BaseWrapper)((Object)this)).getEntityClass();
        MybatisUtil.assertNotNull("entity class", entityClass);
        IRichMapper mapper = RefKit.mapper(entityClass);
        return new QueryExecutor(mapper, this);
    }

    default public QueryExecutor<E> of(IRichMapper<E> mapper) {
        return new QueryExecutor(mapper, this);
    }

    @Deprecated
    default public <R> R execute(Function<IQuery<E>, R> executor) {
        return executor.apply(this);
    }

    public IQuery union(IQuery ... var1);

    public IQuery unionAll(IQuery ... var1);
}

