/*
 * Decompiled with CFR 0.152.
 */
package cn.org.atool.fluent.mybatis.base.crud;

import cn.org.atool.fluent.mybatis.base.IEntity;
import cn.org.atool.fluent.mybatis.base.crud.EmptyWrapper;
import cn.org.atool.fluent.mybatis.base.crud.IQuery;
import cn.org.atool.fluent.mybatis.base.crud.IUpdate;
import cn.org.atool.fluent.mybatis.base.entity.AMapping;
import cn.org.atool.fluent.mybatis.base.entity.IMapping;
import cn.org.atool.fluent.mybatis.base.entity.PkGeneratorKits;
import cn.org.atool.fluent.mybatis.base.intf.BatchCrud;
import cn.org.atool.fluent.mybatis.base.provider.SqlKit;
import cn.org.atool.fluent.mybatis.segment.BaseWrapper;
import cn.org.atool.fluent.mybatis.segment.model.WrapperData;
import cn.org.atool.fluent.mybatis.utility.MybatisUtil;
import cn.org.atool.fluent.mybatis.utility.RefKit;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.stream.Collectors;

public class BatchCrudImpl
implements BatchCrud {
    protected final WrapperData data;
    private final List<BiFunction<IMapping, SqlKit, String>> list = new ArrayList<BiFunction<IMapping, SqlKit, String>>();
    private static final String ENTITY_LIST_KEY = "list";

    public BatchCrudImpl() {
        this.data = new WrapperData(EmptyWrapper.INSTANCE);
    }

    public String batchSql(IMapping mapping, SqlKit sqlKit) {
        return this.list.stream().map(fun -> (String)fun.apply(mapping, sqlKit)).collect(Collectors.joining(";\n"));
    }

    @Override
    public BatchCrud addUpdate(IUpdate ... updates) {
        for (IUpdate updater : updates) {
            if (!(updater instanceof BaseWrapper)) {
                throw new IllegalArgumentException("the updater should be instance of BaseWrapper");
            }
            updater.data().sharedParameter(this.data);
            this.list.add((m, kit) -> kit.updateBy((IMapping)m, updater.data()));
        }
        return this;
    }

    @Override
    public BatchCrud addDelete(IQuery ... deletes) {
        for (IQuery query : deletes) {
            if (!(query instanceof BaseWrapper)) {
                throw new IllegalArgumentException("the query should be instance of BaseWrapper");
            }
            query.data().sharedParameter(this.data);
            this.list.add((m, kit) -> kit.deleteBy((IMapping)m, query.data()));
        }
        return this;
    }

    private AMapping findMapping(Class<? extends IEntity> klass) {
        return RefKit.byEntity(klass);
    }

    @Override
    public BatchCrud addInsert(IEntity ... entities) {
        for (IEntity entity : entities) {
            if (entity == null) continue;
            if (!this.data.getParameters().containsKey(ENTITY_LIST_KEY)) {
                this.data.getParameters().put(ENTITY_LIST_KEY, (Object)new ArrayList());
            }
            List values = (List)this.data.getParameters().get(ENTITY_LIST_KEY);
            int index = values.size();
            values.add(entity);
            String prefix = String.format("ew.data.parameters.%s[%d].", ENTITY_LIST_KEY, index);
            PkGeneratorKits.setPkByGenerator(entity);
            AMapping mapping = this.findMapping(entity.entityClass());
            this.list.add((m, kit) -> kit.insertEntity(mapping, prefix, entity, entity.findPk() != null));
        }
        return this;
    }

    @Override
    public BatchCrud addInsertSelect(String insertTable, String[] fields, IQuery query) {
        MybatisUtil.assertNotNull("query", query);
        query.data().sharedParameter(this.data);
        this.list.add((m, kit) -> kit.insertSelect((IMapping)m, insertTable, fields, query));
        return this;
    }

    public WrapperData getData() {
        return this.data;
    }
}

