/*
 * Decompiled with CFR 0.152.
 */
package cn.org.atool.fluent.form.validator;

import cn.org.atool.fluent.common.kits.ParameterizedTypes;
import cn.org.atool.fluent.form.validator.IValidator;
import cn.org.atool.fluent.mybatis.If;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.executable.ExecutableValidator;

public class Validation {
    private static final ValidatorFactory factory = javax.validation.Validation.buildDefaultValidatorFactory();
    private static final Validator objectValidator = factory.getValidator();
    private static final ExecutableValidator methodValidator = factory.getValidator().forExecutables();

    public static void validate(String prefix, Object ... objects) throws IllegalArgumentException {
        if (objects == null) {
            throw new IllegalArgumentException("validate object can't be null.");
        }
        if (objects.length == 0 || Validation.isFirstObjectNotForm(objects[0])) {
            return;
        }
        int index = -1;
        for (Object object : objects) {
            ++index;
            if (object instanceof Collection) {
                Validation.validate((If.isBlank(prefix) ? "" : prefix) + "[" + index + "]", ((Collection)object).toArray());
                continue;
            }
            if (object instanceof Object[]) {
                Validation.validate((If.isBlank(prefix) ? "" : prefix) + "[" + index + "]", (Object[])object);
                continue;
            }
            Set violations = objectValidator.validate(object, new Class[0]);
            Validation.doValidateResult(prefix, violations);
            Validation.validateArgsByIValidate(object);
        }
    }

    private static boolean isFirstObjectNotForm(Object object) {
        Object first = object;
        if (object instanceof Collection) {
            first = ((Collection)object).stream().filter(If::notNull).findFirst().orElse(null);
        } else if (object instanceof Object[]) {
            first = Arrays.stream((Object[])object).filter(If::notNull).findFirst().orElse(null);
        }
        return first == null || ParameterizedTypes.notFormObject(first.getClass());
    }

    public static <T> void validate(T target, Method method, Object[] args) throws IllegalArgumentException {
        if (method == null || target == null) {
            throw new IllegalArgumentException("validate object can't be null.");
        }
        Set violations = methodValidator.validateParameters(target, method, args, new Class[0]);
        Validation.doValidateResult(null, violations);
        Validation.validateArgsByIValidate(args);
        Validation.validateFormArg(method, args);
    }

    private static void validateFormArg(Method method, Object[] args) {
        int index = -1;
        for (Parameter p : method.getParameters()) {
            ++index;
            Annotation[] as = p.getDeclaredAnnotations();
            boolean hasValidation = false;
            for (Annotation a : as) {
                if (!a.getClass().getName().startsWith("javax.validation.")) continue;
                hasValidation = true;
                break;
            }
            String prefix = method.getName() + ".arg" + index;
            if (Collection.class.isAssignableFrom(p.getType())) {
                Validation.validate(prefix, ((Collection)args[index]).toArray());
                continue;
            }
            if (Object[].class.isAssignableFrom(p.getType())) {
                Validation.validate(prefix, (Object[])args[index]);
                continue;
            }
            if (hasValidation || ParameterizedTypes.notFormObject(p.getType())) continue;
            Validation.validate(prefix, args[index]);
        }
    }

    private static void validateArgsByIValidate(Object ... args) {
        for (Object arg : args) {
            if (arg == null) continue;
            if (arg instanceof IValidator) {
                ((IValidator)arg).validate();
                continue;
            }
            if (arg instanceof Collection) {
                Validation.validateArgsByIValidate(((Collection)arg).toArray());
                continue;
            }
            if (!(arg instanceof Object[])) continue;
            Validation.validateArgsByIValidate((Object[])arg);
        }
    }

    private static <T> void doValidateResult(String prefix, Set<ConstraintViolation<T>> violations) {
        ArrayList<String> messageList = new ArrayList<String>();
        for (ConstraintViolation<T> v : violations) {
            messageList.add((If.isBlank(prefix) ? "" : prefix + ".") + v.getPropertyPath() + ": " + v.getMessage());
        }
        String message = String.join((CharSequence)"\n", messageList);
        if (!message.isEmpty()) {
            throw new IllegalArgumentException(message);
        }
    }
}

