/*
 * Decompiled with CFR 0.152.
 */
package cn.org.atool.fluent.form.setter;

import cn.org.atool.fluent.form.Form;
import cn.org.atool.fluent.form.annotation.EntryType;
import cn.org.atool.fluent.form.meta.EntryMeta;
import cn.org.atool.fluent.form.meta.EntryMetas;
import cn.org.atool.fluent.form.meta.FormMetas;
import cn.org.atool.fluent.form.meta.IEntryMeta;
import cn.org.atool.fluent.form.meta.MethodArgNames;
import cn.org.atool.fluent.form.meta.MethodArgs;
import cn.org.atool.fluent.form.meta.MethodMeta;
import cn.org.atool.fluent.form.setter.FormEntry;
import cn.org.atool.fluent.form.setter.FormItemOrder;
import cn.org.atool.fluent.mybatis.If;
import cn.org.atool.fluent.mybatis.base.EntityRefKit;
import cn.org.atool.fluent.mybatis.base.IEntity;
import cn.org.atool.fluent.mybatis.base.crud.IQuery;
import cn.org.atool.fluent.mybatis.base.crud.IUpdate;
import cn.org.atool.fluent.mybatis.base.crud.IWrapper;
import cn.org.atool.fluent.mybatis.base.entity.AMapping;
import cn.org.atool.fluent.mybatis.base.entity.IMapping;
import cn.org.atool.fluent.mybatis.base.model.FieldMapping;
import cn.org.atool.fluent.mybatis.base.model.ISqlOp;
import cn.org.atool.fluent.mybatis.base.model.SqlOp;
import cn.org.atool.fluent.mybatis.base.model.op.SqlOps;
import cn.org.atool.fluent.mybatis.functions.RefKey;
import cn.org.atool.fluent.mybatis.segment.WhereBase;
import cn.org.atool.fluent.mybatis.utility.MybatisUtil;
import cn.org.atool.fluent.mybatis.utility.RefKit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class FormHelper {
    public static IQuery toQuery(Class entityClass, Form form) {
        MybatisUtil.assertNotNull("entityClass", entityClass);
        if (form.getId() != null && form.getCurrPage() != null) {
            throw new IllegalArgumentException("nextId and currPage can only have one value");
        }
        Object query = RefKit.byEntity(entityClass).query();
        FormHelper.where(entityClass, form, (IWrapper)query);
        FormHelper.oderBy(entityClass, form, query);
        FormHelper.pageBy(entityClass, form, query);
        return query;
    }

    public static IUpdate toUpdate(Class entityClass, Form form) {
        MybatisUtil.assertNotNull("entityClass", entityClass);
        Object updater = RefKit.byEntity(entityClass).updater();
        FormHelper.updateBy(entityClass, form, updater);
        FormHelper.where(entityClass, form, (IWrapper)updater);
        return updater;
    }

    private static void updateBy(Class entityClass, Form form, IUpdate updater) {
        for (Map.Entry<String, Object> entry : form.getUpdate().entrySet()) {
            String column = RefKit.columnOfField(entityClass, entry.getKey());
            if (If.isBlank(column)) {
                throw FormHelper.fieldNotFoundException(entry.getKey(), entityClass);
            }
            updater.updateSet(column, entry.getValue());
        }
    }

    private static void where(Class entityClass, Form form, IWrapper query) {
        WhereBase where = query.where();
        block12: for (FormEntry item : form.getWhere()) {
            Object[] value = item.getValue();
            if (value == null) continue;
            String column = RefKit.columnOfField(entityClass, item.getField());
            if (If.isBlank(column)) {
                throw FormHelper.fieldNotFoundException(item.getField(), entityClass);
            }
            switch (item.getOp()) {
                case "LIKE_LEFT": {
                    ((WhereBase)where.and).apply(column, (ISqlOp)SqlOp.LIKE, value[0] + "%");
                    continue block12;
                }
                case "LIKE": {
                    ((WhereBase)where.and).apply(column, (ISqlOp)SqlOp.LIKE, "%" + value[0] + "%");
                    continue block12;
                }
                case "LIKE_RIGHT": {
                    ((WhereBase)where.and).apply(column, (ISqlOp)SqlOp.LIKE, "%" + value[0]);
                    continue block12;
                }
                case "NOT_LIKE": {
                    ((WhereBase)where.and).apply(column, (ISqlOp)SqlOp.NOT_LIKE, "%" + value[0] + "%");
                    continue block12;
                }
            }
            ((WhereBase)where.and).apply(column, SqlOps.get(item.getOp()), value);
        }
    }

    private static void pageBy(Class entityClass, Form form, IQuery query) {
        if (form.getCurrPage() != null) {
            int from = form.getPageSize() * (form.getCurrPage() - 1);
            query.limit(from, form.getPageSize());
        } else if (form.getId() != null) {
            String column = RefKit.primaryId(entityClass);
            ((WhereBase)query.where().and).apply(column, (ISqlOp)SqlOp.GE, form.getId());
            query.limit(form.getPageSize());
        }
    }

    private static void oderBy(Class entityClass, Form form, IQuery query) {
        for (FormItemOrder item : form.getOrder()) {
            String column = RefKit.columnOfField(entityClass, item.getField());
            query.orderBy().apply(true, item.isAsc(), column);
        }
    }

    public static <E extends IEntity> E newEntity(MethodMeta method, Object[] args) {
        AMapping mapping = RefKit.byEntity(method.entityClass);
        Object entity = mapping.newEntity();
        for (IEntryMeta entryMeta : method.metas().getMetas()) {
            EntryMeta meta = (EntryMeta)entryMeta;
            if (meta.getter == null) continue;
            FieldMapping fm = mapping.getFieldsMap().get(meta.name);
            fm.setter.set(entity, meta.get((Object)args));
        }
        return entity;
    }

    public static <E extends IEntity> IUpdate<E> newUpdate(MethodArgs args) {
        AMapping mapping = RefKit.byEntity(args.meta.entityClass);
        Object updater = mapping.updater();
        Object where = mapping.emptyQuery();
        FormHelper.wrapperByMetas(mapping, args.meta.metas(), args, (IWrapper)updater, where);
        updater.where().and((IQuery)where);
        return updater;
    }

    public static <E extends IEntity> IQuery<E> newQuery(MethodArgs args) {
        AMapping mapping = RefKit.byEntity(args.meta.entityClass);
        Object query = mapping.query();
        Object where = mapping.emptyQuery();
        FormHelper.wrapperByMetas(mapping, args.meta.metas(), args, (IWrapper)query, where);
        query.where().and((IQuery)where);
        FormHelper.limitAndOrderBy(query, args.meta.argNames);
        return query;
    }

    private static <E extends IEntity> void limitAndOrderBy(IQuery<E> query, MethodArgNames argNames) {
        if (argNames == null) {
            return;
        }
        if (argNames.getTopN() > 0) {
            query.limit(argNames.getTopN());
        }
        for (MethodArgNames.OrderBy orderBy : argNames.orderBy) {
            query.orderBy().apply(true, orderBy.isAsc, orderBy.name);
        }
    }

    private static void wrapperByMetas(IMapping mapping, EntryMetas metas, MethodArgs args, IWrapper wrapper, IQuery where) {
        for (IEntryMeta entryMeta : metas.getMetas()) {
            if (entryMeta instanceof EntryMeta) {
                FormHelper.wrapperByMeta(mapping, metas.isAnd(), (EntryMeta)entryMeta, args, wrapper, where);
                continue;
            }
            if (!(entryMeta instanceof EntryMetas)) continue;
            EntryMetas meta = (EntryMetas)entryMeta;
            Object nested = mapping.emptyQuery();
            FormHelper.wrapperByMetas(mapping, meta, args, wrapper, nested);
            if (metas.isAnd()) {
                where.where().and((IQuery)nested);
                continue;
            }
            where.where().or((IQuery)nested);
        }
        if (wrapper instanceof IQuery) {
            for (EntryMeta meta : metas.getOrderBy()) {
                FormHelper.addOrderBy(mapping, (IQuery)((Object)wrapper), meta, args);
            }
            if (metas.getPageSize() != null) {
                FormHelper.setPaged(mapping, (IQuery)((Object)wrapper), args);
            }
        }
    }

    private static void wrapperByMeta(IMapping mapping, boolean isAnd, EntryMeta meta, MethodArgs args, IWrapper wrapper, IQuery where) {
        Object value = meta.get((Object)args.args);
        if (meta.getter == null || meta.ignoreNull && value == null) {
            return;
        }
        FieldMapping fm = mapping.getFieldsMap().get(meta.name);
        if (fm == null) {
            throw FormHelper.fieldNotFoundException(meta.name, args.meta.entityClass);
        }
        if (meta.entryType == EntryType.Update && args.meta.isUpdate() && wrapper instanceof IUpdate) {
            ((IUpdate)((Object)wrapper)).updateSet(fm.column, value);
        } else {
            FormHelper.where(isAnd ? where.where().and : where.where().or, fm.column, meta, value);
        }
    }

    private static <E extends IEntity> void addOrderBy(IMapping mapping, IQuery<E> query, EntryMeta meta, MethodArgs args) {
        Boolean asc = (Boolean)meta.get((Object)args.args);
        if (asc == null) {
            return;
        }
        FieldMapping fm = mapping.getFieldsMap().get(meta.name);
        if (fm == null) {
            throw FormHelper.fieldNotFoundException(meta.name, args.meta.entityClass);
        }
        query.orderBy().apply(true, (boolean)asc, fm.column);
    }

    private static void setPaged(IMapping mapping, IQuery query, MethodArgs args) {
        int pageSize = args.getPageSize();
        if (pageSize < 1) {
            throw new IllegalArgumentException("PageSize must be greater than 0.");
        }
        Integer currPage = args.getCurrPage();
        if (currPage == null || currPage < 1) {
            currPage = 1;
        }
        query.paged(currPage, pageSize);
        Object pagedTag = args.getPagedTag();
        if (pagedTag != null) {
            String pk = mapping.primaryId(true);
            query.where().apply(pk, (ISqlOp)SqlOp.GE, pagedTag);
        }
    }

    private static void where(WhereBase where, String column, EntryMeta meta, Object value) {
        if (value == null || value instanceof String && If.isBlank((String)value)) {
            if (!meta.ignoreNull) {
                if (meta.entryType == EntryType.EQ) {
                    where.apply(column, (ISqlOp)SqlOp.IS_NULL, new Object[0]);
                } else {
                    throw new IllegalArgumentException("Condition field[" + meta.name + "] not assigned.");
                }
            }
            return;
        }
        switch (meta.entryType) {
            case EQ: {
                if (value instanceof Collection || value.getClass().isArray()) {
                    where.apply(column, (ISqlOp)SqlOp.IN, FormHelper.toArray(meta.name, value));
                    break;
                }
                where.apply(column, (ISqlOp)SqlOp.EQ, value);
                break;
            }
            case GT: {
                where.apply(column, (ISqlOp)SqlOp.GT, value);
                break;
            }
            case GE: {
                where.apply(column, (ISqlOp)SqlOp.GE, value);
                break;
            }
            case LT: {
                where.apply(column, (ISqlOp)SqlOp.LT, value);
                break;
            }
            case LE: {
                where.apply(column, (ISqlOp)SqlOp.LE, value);
                break;
            }
            case NE: {
                where.apply(column, (ISqlOp)SqlOp.NE, value);
                break;
            }
            case IN: {
                where.apply(column, (ISqlOp)SqlOp.IN, FormHelper.toArray(meta.name, value));
                break;
            }
            case Like: {
                where.apply(column, (ISqlOp)SqlOp.LIKE, "%" + value + "%");
                break;
            }
            case StartWith: {
                where.apply(column, (ISqlOp)SqlOp.LIKE, value + "%");
                break;
            }
            case EndWith: {
                where.apply(column, (ISqlOp)SqlOp.LIKE, "%" + value);
                break;
            }
            case Between: {
                Object[] args = FormHelper.toArray(meta.name, value);
                FormHelper.between(where, meta, column, args);
                break;
            }
        }
    }

    private static void between(WhereBase where, EntryMeta meta, String column, Object[] args) {
        if (args.length == 0 && meta.ignoreNull) {
            return;
        }
        if (args.length != 2) {
            throw new IllegalArgumentException("The value size of the between condition[" + meta.name + "] must be 2.");
        }
        if (args[0] == null && args[1] != null) {
            where.apply(column, (ISqlOp)SqlOp.LE, args[1]);
        } else if (args[0] != null && args[1] == null) {
            where.apply(column, (ISqlOp)SqlOp.GE, args[0]);
        } else if (args[0] != null) {
            where.apply(column, (ISqlOp)SqlOp.BETWEEN, args);
        } else if (!meta.ignoreNull) {
            throw new IllegalArgumentException("The value of the between condition[" + meta.name + "] can't be null.");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Object[] toArray(String methodName, Object object) {
        MybatisUtil.assertNotNull("result of method[" + methodName + "]", object);
        Class<?> aClass = object.getClass();
        ArrayList<Object> list = new ArrayList<Object>();
        if (aClass.isArray()) {
            if (aClass == int[].class) {
                for (int i : (int[])object) {
                    list.add(i);
                }
                return list.toArray();
            } else if (aClass == long[].class) {
                for (long l : (long[])object) {
                    list.add(l);
                }
                return list.toArray();
            } else if (aClass == short[].class) {
                for (short s : (short[])object) {
                    list.add(s);
                }
                return list.toArray();
            } else if (aClass == double[].class) {
                for (double d : (double[])object) {
                    list.add(d);
                }
                return list.toArray();
            } else if (aClass == float[].class) {
                for (float f : (float[])object) {
                    list.add(Float.valueOf(f));
                }
                return list.toArray();
            } else if (aClass == boolean[].class) {
                for (boolean b : (boolean[])object) {
                    list.add(b);
                }
                return list.toArray();
            } else if (aClass == char[].class) {
                for (char c : (char[])object) {
                    list.add(Character.valueOf(c));
                }
                return list.toArray();
            } else {
                if (aClass != byte[].class) return (Object[])object;
                for (byte b : (byte[])object) {
                    list.add(b);
                }
            }
            return list.toArray();
        } else if (Collection.class.isAssignableFrom(aClass)) {
            list.addAll((Collection)object);
            return list.toArray();
        } else {
            list.add(object);
        }
        return list.toArray();
    }

    public static <R> List<R> entities2result(List<IEntity> entities, Class<R> rClass) {
        if (rClass == null) {
            return entities;
        }
        EntryMetas metas = EntryMetas.getFormMeta(rClass);
        return FormHelper.entities2result(entities, metas);
    }

    private static List entities2result(List<IEntity> entities, EntryMetas metas) {
        if (entities == null || entities.isEmpty()) {
            return Collections.emptyList();
        }
        Class entityClass = entities.stream().filter(Objects::nonNull).findFirst().map(IEntity::entityClass).orElse(null);
        if (entityClass == null) {
            return Collections.emptyList();
        }
        for (FormMetas form : metas.getForms()) {
            RefKey refKey = EntityRefKit.getRefKeyOfRefMethod(entityClass, form.entryName);
            if (refKey == null) {
                throw new RuntimeException("The @RefMethod[" + form.entryName + "] of Entity[" + entityClass.getName() + "] not found.");
            }
            if (refKey.src == null || refKey.ref == null) continue;
            RefKit.invokeRefMethod(entityClass, refKey.refMethodName, entities);
        }
        ArrayList<Object> list = new ArrayList<Object>();
        for (IEntity entity : entities) {
            list.add(FormHelper.entity2result(entity, metas));
        }
        return list;
    }

    public static <R> R entity2result(IEntity entity, Class<R> rClass) {
        if (entity == null) {
            return null;
        }
        EntryMetas metas = EntryMetas.getFormMeta(rClass);
        return (R)FormHelper.entity2result(entity, metas);
    }

    private static Object entity2result(IEntity entity, EntryMetas metas) {
        if (entity == null || metas.objType == null) {
            return null;
        }
        try {
            Object target = metas.objType.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            Class<IEntity> entityClass = entity.entityClass();
            Map<String, FieldMapping> mapping = RefKit.byEntity(entityClass).getFieldsMap();
            for (IEntryMeta meta : metas.getMetas()) {
                FormHelper.setFieldValue(mapping, (EntryMeta)meta, entity, target);
            }
            for (FormMetas form : metas.getForms()) {
                Object data = EntityRefKit.findRefData(entityClass, entity, form.entryName);
                if (data instanceof Collection) {
                    List list = FormHelper.entities2result((List<IEntity>)((List)data), (EntryMetas)form);
                    form.setValue(target, (Object)list);
                    continue;
                }
                Object value = FormHelper.entity2result((IEntity)data, (EntryMetas)form);
                form.setValue(target, value);
            }
            return target;
        }
        catch (Exception e) {
            throw MybatisUtil.wrap(e);
        }
    }

    private static void setFieldValue(Map<String, FieldMapping> mapping, EntryMeta meta, IEntity source, Object target) {
        if (meta.setter == null) {
            return;
        }
        FieldMapping fm = mapping.get(meta.name);
        if (fm == null) {
            throw FormHelper.fieldNotFoundException(meta.name, source.entityClass());
        }
        Object value = fm.getter.get(source);
        meta.set(target, value);
    }

    private static RuntimeException fieldNotFoundException(String name, Class entityClass) {
        return new IllegalArgumentException("The field[" + name + "] of entity[" + entityClass.getName() + "] not found.");
    }
}

