/*
 * Decompiled with CFR 0.152.
 */
package cn.org.atool.fluent.form.setter;

import cn.org.atool.fluent.form.setter.FormSqlOp;
import cn.org.atool.fluent.mybatis.If;
import cn.org.atool.fluent.mybatis.utility.MybatisUtil;
import java.io.Serializable;
import java.util.Arrays;

public class FormEntry
implements Serializable {
    private static final long serialVersionUID = 5691660056854381559L;
    private String field;
    private String op = "EQ";
    private Object[] value;

    public FormEntry() {
    }

    public FormEntry(String item, String op, Object ... value) {
        this.field = item;
        this.op = op;
        this.value = value;
        this.validate();
    }

    private void validate() {
        MybatisUtil.assertNotBlank("key", this.field);
        if (If.isBlank(this.op)) {
            this.op = "EQ";
        } else if (!FormSqlOp.ALL_OP.contains(this.op)) {
            throw new RuntimeException("only support operation:" + String.join((CharSequence)", ", FormSqlOp.ALL_OP) + ", but find:" + this.op);
        }
        if ("BETWEEN".equals(this.op) || "NOT_BETWEEN".equals(this.op)) {
            MybatisUtil.assertNotEmpty("value", this.value);
            if (this.value.length != 2) {
                throw new RuntimeException("The number of between operation parameters[" + this.field + "] must be two.");
            }
        } else if ("IN".equals(this.op) || "NOT_IN".equals(this.op)) {
            MybatisUtil.assertNotEmpty("parameter of " + this.field, this.value);
        } else if (!"IS_NULL".equals(this.op) && !"NOT_NULL".equals(this.op)) {
            MybatisUtil.assertNotEmpty("parameter of " + this.field, this.value);
            if (this.value.length != 1) {
                throw new RuntimeException("The number of parameters[" + this.field + "] must be one.");
            }
        }
    }

    public String getField() {
        return this.field;
    }

    public String getOp() {
        return this.op;
    }

    public Object[] getValue() {
        return this.value;
    }

    public FormEntry setField(String field) {
        this.field = field;
        return this;
    }

    public FormEntry setOp(String op) {
        this.op = op;
        return this;
    }

    public FormEntry setValue(Object[] value) {
        this.value = value;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FormEntry)) {
            return false;
        }
        FormEntry other = (FormEntry)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$field = this.getField();
        String other$field = other.getField();
        if (this$field == null ? other$field != null : !this$field.equals(other$field)) {
            return false;
        }
        String this$op = this.getOp();
        String other$op = other.getOp();
        if (this$op == null ? other$op != null : !this$op.equals(other$op)) {
            return false;
        }
        return Arrays.deepEquals(this.getValue(), other.getValue());
    }

    protected boolean canEqual(Object other) {
        return other instanceof FormEntry;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $field = this.getField();
        result = result * 59 + ($field == null ? 43 : $field.hashCode());
        String $op = this.getOp();
        result = result * 59 + ($op == null ? 43 : $op.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getValue());
        return result;
    }

    public String toString() {
        return "FormEntry(field=" + this.getField() + ", op=" + this.getOp() + ", value=" + Arrays.deepToString(this.getValue()) + ")";
    }
}

