/*
 * Decompiled with CFR 0.152.
 */
package cn.org.atool.fluent.form.registrar;

import cn.org.atool.fluent.common.kits.KeyMap;
import cn.org.atool.fluent.common.kits.ParameterizedTypes;
import cn.org.atool.fluent.common.kits.SegmentLocks;
import cn.org.atool.fluent.form.IMethodAround;
import cn.org.atool.fluent.form.annotation.FormMethod;
import cn.org.atool.fluent.form.annotation.FormService;
import cn.org.atool.fluent.form.meta.MethodMeta;
import cn.org.atool.fluent.form.registrar.FormServiceKit;
import cn.org.atool.fluent.form.registrar.NoMethodAround;
import cn.org.atool.fluent.form.validator.Validation;
import cn.org.atool.fluent.mybatis.base.IBaseDao;
import cn.org.atool.fluent.mybatis.base.IEntity;
import cn.org.atool.fluent.mybatis.base.dao.BaseDao;
import cn.org.atool.fluent.mybatis.utility.RefKit;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.Objects;
import org.springframework.cglib.proxy.Callback;
import org.springframework.cglib.proxy.Enhancer;
import org.springframework.cglib.proxy.MethodInterceptor;
import org.springframework.cglib.proxy.MethodProxy;
import org.springframework.cglib.proxy.NoOp;

public class FormServiceProxy
implements MethodInterceptor {
    private final Class serviceClass;
    private final IMethodAround methodAround;
    private Class entityClass;
    private static final KeyMap<IMethodAround> instances = new KeyMap().put(NoMethodAround.class, (Object)NoMethodAround.instance);
    private static final SegmentLocks<Class> locks = new SegmentLocks(16);

    public static Object create(Class serviceClass, Class aroundClass) {
        Enhancer enhancer = new Enhancer();
        if (serviceClass.isInterface()) {
            enhancer.setInterfaces(new Class[]{serviceClass});
        } else {
            enhancer.setSuperclass(serviceClass);
        }
        enhancer.setCallbackFilter(method -> FormServiceProxy.isAbstract(method) ? 0 : 1);
        FormServiceProxy formServiceProxy = new FormServiceProxy(serviceClass, aroundClass);
        enhancer.setCallbacks(new Callback[]{formServiceProxy, NoOp.INSTANCE});
        Object proxy = enhancer.create();
        if (proxy instanceof BaseDao) {
            ((BaseDao)proxy).setMapper(RefKit.mapper(formServiceProxy.getEntityClass()));
        }
        return proxy;
    }

    private static boolean isAbstract(Method method) {
        return Modifier.isAbstract(method.getModifiers());
    }

    public FormServiceProxy(Class serviceClass, Class aroundClass) {
        this.serviceClass = serviceClass;
        this.methodAround = this.aroundInstance(aroundClass);
    }

    public Object intercept(Object target, Method method, Object[] args, MethodProxy methodProxy) {
        Validation.validate(target, method, args);
        Class<?> declaringClass = method.getDeclaringClass();
        if (IBaseDao.class.equals(declaringClass) && Objects.equals(method.getName(), "mapper")) {
            Class<? extends IEntity> eClass = this.getEntityClass(method);
            return RefKit.mapper(eClass);
        }
        Class<? extends IEntity> eClass = this.getEntityClass(method);
        try {
            MethodMeta methodMeta = this.methodAround.cache(eClass, method);
            Object[] _args = this.methodAround.before(methodMeta, args);
            Object result = FormServiceKit.invoke(methodMeta, _args);
            return this.methodAround.after(eClass, method, args, result);
        }
        catch (RuntimeException e) {
            return this.methodAround.after(eClass, method, args, e);
        }
    }

    private Class<? extends IEntity> getEntityClass(Method method) {
        FormMethod aMethod = method.getDeclaredAnnotation(FormMethod.class);
        if (aMethod == null) {
            return this.getEntityClass();
        }
        Class<? extends IEntity> entity = FormServiceKit.getEntityClass(aMethod.entity(), aMethod.table());
        if (entity == null || entity == Object.class) {
            entity = this.getEntityClass();
        }
        if (entity == null || entity == Object.class) {
            throw new RuntimeException("The entityClass value of @MethodService of Method[" + method.getName() + "] must be a subclass of IEntity.");
        }
        return entity;
    }

    private Class<? extends IEntity> getEntityClass() {
        if (this.entityClass == null) {
            FormService annotation = this.serviceClass.getDeclaredAnnotation(FormService.class);
            Class klass = FormServiceKit.getEntityClass(annotation.entity(), annotation.table());
            this.entityClass = klass != Object.class ? klass : (IBaseDao.class.isAssignableFrom(this.serviceClass) ? (Class)ParameterizedTypes.getType((Type)this.serviceClass, IBaseDao.class, (String)"E") : Object.class);
        }
        return this.entityClass;
    }

    private IMethodAround aroundInstance(Class<? extends IMethodAround> aClass) {
        locks.lockDoing(arg_0 -> instances.containsKey(arg_0), aClass, () -> {
            try {
                IMethodAround aop = (IMethodAround)aClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                instances.put((Type)aClass, (Object)aop);
            }
            catch (Exception ignored) {
                instances.put((Type)aClass, (Object)NoMethodAround.instance);
            }
        });
        return (IMethodAround)instances.get(aClass);
    }
}

