/*
 * Decompiled with CFR 0.152.
 */
package cn.org.atool.fluent.form.registrar;

import cn.org.atool.fluent.common.kits.KeyMap;
import cn.org.atool.fluent.form.annotation.FormService;
import cn.org.atool.fluent.form.meta.ClassKit;
import cn.org.atool.fluent.form.meta.MethodArgs;
import cn.org.atool.fluent.form.meta.MethodMeta;
import cn.org.atool.fluent.form.setter.FormHelper;
import cn.org.atool.fluent.mybatis.If;
import cn.org.atool.fluent.mybatis.base.IEntity;
import cn.org.atool.fluent.mybatis.base.crud.BaseQuery;
import cn.org.atool.fluent.mybatis.base.crud.IQuery;
import cn.org.atool.fluent.mybatis.base.crud.IUpdate;
import cn.org.atool.fluent.mybatis.base.entity.AMapping;
import cn.org.atool.fluent.mybatis.model.StdPagedList;
import cn.org.atool.fluent.mybatis.model.TagPagedList;
import cn.org.atool.fluent.mybatis.utility.RefKit;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

public interface FormServiceKit {
    public static final KeyMap<Class> TableEntityClass = new KeyMap();
    public static final Map<String, MethodMeta> METHOD_CACHED = new HashMap<String, MethodMeta>();

    public static Object save(MethodMeta meta, Object ... args) {
        Object entity = FormHelper.newEntity(meta, args);
        Object pk = RefKit.mapper(meta.entityClass).save(entity);
        if (meta.isReturnVoid()) {
            return null;
        }
        if (meta.isReturnBool()) {
            return pk != null;
        }
        if (meta.returnType.isAssignableFrom(meta.entityClass)) {
            return entity;
        }
        return FormHelper.entity2result(entity, meta.returnType);
    }

    public static Object save(MethodMeta meta, Collection list) {
        if (list.size() == 0) {
            throw new IllegalArgumentException("the save list can't be empty.");
        }
        ArrayList entities = new ArrayList();
        for (Object obj : list) {
            Object entity = FormHelper.newEntity(meta, new Object[]{obj});
            entities.add(entity);
        }
        int count = RefKit.mapper(meta.entityClass).save(entities);
        return FormServiceKit.returnUpdateResult(meta, count);
    }

    public static Object delete(MethodMeta meta, Collection list, boolean isLogic) {
        if (list.size() == 0) {
            throw new IllegalArgumentException("the delete list can't be empty.");
        }
        ArrayList<Integer> counts = new ArrayList<Integer>(list.size());
        for (Object obj : list) {
            IQuery query = FormHelper.newQuery(new MethodArgs(meta, new Object[]{obj}));
            int count = isLogic ? RefKit.mapper(meta.entityClass).logicDelete(query) : RefKit.mapper(meta.entityClass).delete(query);
            counts.add(count);
        }
        return FormServiceKit.returnUpdateResult(meta, counts);
    }

    public static Object update(MethodMeta meta, Object ... args) {
        IUpdate update = FormHelper.newUpdate(new MethodArgs(meta, args));
        int count = RefKit.mapper(meta.entityClass).updateBy(update);
        return FormServiceKit.returnUpdateResult(meta, count);
    }

    public static Object delete(MethodMeta meta, boolean isLogic, Object ... args) {
        IQuery query = FormHelper.newQuery(new MethodArgs(meta, args));
        int count = isLogic ? RefKit.mapper(meta.entityClass).logicDelete(query) : RefKit.mapper(meta.entityClass).delete(query);
        return FormServiceKit.returnUpdateResult(meta, count);
    }

    public static Object update(MethodMeta meta, Collection list) {
        if (list.size() == 0) {
            throw new IllegalArgumentException("the update list can't be empty.");
        }
        IUpdate[] updates = new IUpdate[list.size()];
        int index = 0;
        for (Object obj : list) {
            IUpdate update = FormHelper.newUpdate(new MethodArgs(meta, new Object[]{obj}));
            updates[index++] = update;
        }
        int count = RefKit.mapper(meta.entityClass).updateBy(updates);
        return FormServiceKit.returnUpdateResult(meta, count);
    }

    public static Object query(MethodMeta meta, Object ... args) {
        IQuery query = FormHelper.newQuery(new MethodArgs(meta, args));
        if (meta.isCount()) {
            int count = query.to().count();
            return meta.isReturnLong() ? (long)count : (long)count;
        }
        if (meta.isStdPage()) {
            StdPagedList paged = query.to().stdPagedEntity();
            List data = FormHelper.entities2result(paged.getData(), meta.returnParameterType);
            return paged.setData(data);
        }
        if (meta.isTagPage()) {
            TagPagedList paged = query.to().tagPagedEntity();
            List data = FormHelper.entities2result(paged.getData(), meta.returnParameterType);
            IEntity next = (IEntity)paged.getNext();
            return new TagPagedList<Object>(data, next == null ? null : next.findPk());
        }
        if (meta.isList()) {
            List<IEntity> list = query.to().listEntity();
            return FormHelper.entities2result(list, meta.returnParameterType);
        }
        if (meta.isReturnBool()) {
            ((BaseQuery)((BaseQuery)query).select("1")).limit(1);
            Optional<Map> ret = query.to().findOneMap();
            return ret.isPresent();
        }
        query.limit(1);
        IEntity entity = query.to().findOne().orElse(null);
        return FormHelper.entity2result(entity, meta.returnType);
    }

    public static Object returnUpdateResult(MethodMeta meta, int count) {
        if (meta.isReturnVoid()) {
            return null;
        }
        if (meta.isReturnBool()) {
            return count > 0;
        }
        if (meta.isReturnInt()) {
            return count;
        }
        if (meta.isReturnLong()) {
            return (long)count;
        }
        throw new IllegalStateException("The type of batch result can only be: void, int, long, or boolean.");
    }

    public static Object returnUpdateResult(MethodMeta meta, List<Integer> counts) {
        if (meta.isReturnList()) {
            return counts;
        }
        int total = 0;
        for (int c : counts) {
            total += c;
        }
        return FormServiceKit.returnUpdateResult(meta, total);
    }

    public static Class getEntityClass(String className, String entityTable) {
        if (If.notBlank(entityTable)) {
            return FormServiceKit.getEntityClass(entityTable);
        }
        if (Objects.equals(Object.class.getName(), className)) {
            return Object.class;
        }
        Class entityClass = ClassKit.forName((String)className);
        if (IEntity.class.isAssignableFrom(entityClass)) {
            return entityClass;
        }
        throw new RuntimeException("The value of entity() of @FormService must be a subclass of IEntity.");
    }

    public static Class getEntityClass(Class entityClass, String entityTable) {
        if (If.notBlank(entityTable)) {
            return FormServiceKit.getEntityClass(entityTable);
        }
        if (Object.class.equals((Object)entityClass)) {
            return Object.class;
        }
        if (IEntity.class.isAssignableFrom(entityClass)) {
            return entityClass;
        }
        throw new RuntimeException("The value of entity() of @FormService must be a subclass of IEntity.");
    }

    public static Class<? extends IEntity> getEntityClass(String table) {
        if (If.isBlank(table)) {
            return null;
        }
        if (TableEntityClass.containsKey(table)) {
            return (Class)TableEntityClass.get(table);
        }
        AMapping mapping = RefKit.byTable(table);
        if (mapping == null) {
            throw new RuntimeException("The table[" + table + "] not found.");
        }
        return mapping.entityClass();
    }

    public static <T> T invoke(MethodMeta meta, Object[] args) {
        if (meta.isOneArgListOrArray() && !meta.isQuery()) {
            Collection list = FormServiceKit.asCollection(args[0]);
            if (meta.isSave()) {
                return (T)FormServiceKit.save(meta, list);
            }
            if (meta.isDelete()) {
                return (T)FormServiceKit.delete(meta, list, false);
            }
            if (meta.isLogicDelete()) {
                return (T)FormServiceKit.delete(meta, list, true);
            }
            return (T)FormServiceKit.update(meta, list);
        }
        if (meta.isSave()) {
            return (T)FormServiceKit.save(meta, args);
        }
        if (meta.isUpdate()) {
            return (T)FormServiceKit.update(meta, args);
        }
        if (meta.isDelete()) {
            return (T)FormServiceKit.delete(meta, false, args);
        }
        if (meta.isLogicDelete()) {
            return (T)FormServiceKit.delete(meta, true, args);
        }
        return (T)FormServiceKit.query(meta, args);
    }

    public static Collection asCollection(Object arg) {
        if (arg instanceof Collection) {
            return (Collection)arg;
        }
        return Arrays.asList((Object[])arg);
    }

    public static MethodMeta meta(Class klass, String methodName, Class ... pClasses) {
        String key = Arrays.stream(pClasses).map(Class::getName).collect(Collectors.joining(",", klass.getName() + "#" + methodName + "(", ")"));
        if (METHOD_CACHED.containsKey(key)) {
            return METHOD_CACHED.get(key);
        }
        try {
            FormService annotation = klass.getAnnotation(FormService.class);
            Class entityClass = FormServiceKit.getEntityClass(annotation.entity(), annotation.table());
            Method method = klass.getMethod(methodName, pClasses);
            return MethodMeta.meta((Class)entityClass, (Method)method);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("find method error:" + e.getMessage(), e);
        }
    }
}

