/*
 * Decompiled with CFR 0.152.
 */
package cn.org.atool.fluent.form.meta.entry;

import cn.org.atool.fluent.form.annotation.Entry;
import cn.org.atool.fluent.form.annotation.EntryType;

public class PagedEntry {
    @Entry(type=EntryType.PageSize)
    private int pageSize;
    @Entry(type=EntryType.CurrPage)
    private Integer currPage;
    @Entry(type=EntryType.PagedTag)
    private String pagedTag;

    public PagedEntry(int currPage, int pageSize) {
        this.pageSize = Math.max(pageSize, 1);
        this.currPage = Math.max(currPage, 1);
    }

    public PagedEntry(String pagedTag, int pageSize) {
        this.pageSize = Math.max(pageSize, 1);
        this.pagedTag = pagedTag;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public Integer getCurrPage() {
        return this.currPage;
    }

    public String getPagedTag() {
        return this.pagedTag;
    }

    public PagedEntry setPageSize(int pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    public PagedEntry setCurrPage(Integer currPage) {
        this.currPage = currPage;
        return this;
    }

    public PagedEntry setPagedTag(String pagedTag) {
        this.pagedTag = pagedTag;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PagedEntry)) {
            return false;
        }
        PagedEntry other = (PagedEntry)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getPageSize() != other.getPageSize()) {
            return false;
        }
        Integer this$currPage = this.getCurrPage();
        Integer other$currPage = other.getCurrPage();
        if (this$currPage == null ? other$currPage != null : !((Object)this$currPage).equals(other$currPage)) {
            return false;
        }
        String this$pagedTag = this.getPagedTag();
        String other$pagedTag = other.getPagedTag();
        return !(this$pagedTag == null ? other$pagedTag != null : !this$pagedTag.equals(other$pagedTag));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PagedEntry;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPageSize();
        Integer $currPage = this.getCurrPage();
        result = result * 59 + ($currPage == null ? 43 : ((Object)$currPage).hashCode());
        String $pagedTag = this.getPagedTag();
        result = result * 59 + ($pagedTag == null ? 43 : $pagedTag.hashCode());
        return result;
    }

    public String toString() {
        return "PagedEntry(pageSize=" + this.getPageSize() + ", currPage=" + this.getCurrPage() + ", pagedTag=" + this.getPagedTag() + ")";
    }

    public PagedEntry() {
    }
}

