/*
 * Decompiled with CFR 0.152.
 */
package cn.org.atool.fluent.form.meta.entry;

import cn.org.atool.fluent.common.kits.StringKit;
import cn.org.atool.fluent.form.annotation.EntryType;
import cn.org.atool.fluent.form.meta.EntryMeta;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.function.BiConsumer;
import java.util.function.Function;

public class MethodEntryMeta
extends EntryMeta {
    private final Method getter;
    private final Method setter;

    public MethodEntryMeta(String name, EntryType type, Method getter, Method setter, boolean ignoreNull) {
        super(name, MethodEntryMeta.getJavaType(getter, setter), type, ignoreNull);
        this.getter = getter;
        this.setter = setter;
    }

    private static Type getJavaType(Method getter, Method setter) {
        if (getter != null) {
            return getter.getGenericReturnType();
        }
        if (setter != null) {
            Parameter p = setter.getParameters()[0];
            return p.getParameterizedType();
        }
        return null;
    }

    @Override
    protected Function getter() {
        return target -> {
            if (this.getter == null || target == null) {
                return null;
            }
            try {
                return this.getter.invoke(target, new Object[0]);
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        };
    }

    @Override
    protected BiConsumer setter() {
        return (target, value) -> {
            if (this.setter == null || target == null) {
                return;
            }
            try {
                this.setter.invoke(target, value);
            }
            catch (IllegalArgumentException e) {
                String err = "method:" + this.setter + ", value " + (value == null ? "<null>" : value.getClass()) + ":" + value;
                throw new IllegalArgumentException(err, e);
            }
            catch (Exception e) {
                throw StringKit.wrap(e);
            }
        };
    }
}

