/*
 * Decompiled with CFR 0.152.
 */
package cn.org.atool.fluent.form.meta;

import cn.org.atool.fluent.common.kits.KeyMap;
import cn.org.atool.fluent.common.kits.ParameterizedTypes;
import cn.org.atool.fluent.common.kits.SegmentLocks;
import cn.org.atool.fluent.common.kits.StringKit;
import cn.org.atool.fluent.form.annotation.EntryType;
import cn.org.atool.fluent.form.annotation.FormMethod;
import cn.org.atool.fluent.form.annotation.MethodType;
import cn.org.atool.fluent.form.meta.ArgNamesKit;
import cn.org.atool.fluent.form.meta.ArgumentMeta;
import cn.org.atool.fluent.form.meta.EntryMeta;
import cn.org.atool.fluent.form.meta.EntryMetas;
import cn.org.atool.fluent.form.meta.IEntryMeta;
import cn.org.atool.fluent.form.meta.MethodArgNames;
import cn.org.atool.fluent.form.meta.entry.ArgEntryMeta;
import cn.org.atool.fluent.mybatis.model.StdPagedList;
import cn.org.atool.fluent.mybatis.model.TagPagedList;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.UUID;

public class MethodMeta {
    public final Class entityClass;
    public final String method;
    public final MethodType methodType;
    public final MethodArgNames argNames;
    public final ArgumentMeta[] argMetas;
    public final Class returnType;
    public final Class returnParameterType;
    private static final List<MethodType> autos = Arrays.asList(MethodType.Delete, MethodType.LogicDelete, MethodType.Save, MethodType.Update);
    private static final SegmentLocks<String> MethodLock = new SegmentLocks(16);
    public static final KeyMap<EntryMetas> MethodArgsMeta = new KeyMap();

    private MethodMeta(Class entityClass, Method method, MethodType methodType, ArgumentMeta[] metas, Class returnType, Class returnParameterType) {
        this.entityClass = entityClass;
        this.method = method == null ? UUID.randomUUID() + "()" : method.toString();
        this.methodType = methodType;
        this.argMetas = metas;
        this.returnType = returnType;
        this.returnParameterType = returnParameterType;
        this.argNames = null;
    }

    private MethodMeta(Class entityClass, Method method) {
        this.entityClass = entityClass;
        this.method = method.toString();
        this.returnType = method.getReturnType();
        this.returnParameterType = this.getParameterTypeOfReturn(method);
        this.argNames = ArgNamesKit.parseMethodStyle(method.getName());
        this.methodType = MethodMeta.parseMethodType(method);
        this.argMetas = this.buildArgumentMeta(this.argNames, method.getParameters());
    }

    private static MethodType parseMethodType(Method method) {
        FormMethod aMethod = method.getDeclaredAnnotation(FormMethod.class);
        if (aMethod != null && aMethod.type() != MethodType.Auto) {
            return aMethod.type();
        }
        String name = method.getName();
        for (MethodType type : autos) {
            if (!type.match(name)) continue;
            return type;
        }
        return MethodType.Query;
    }

    public static MethodMeta meta(Class entityClass, Method method) {
        return new MethodMeta(entityClass, method);
    }

    public static MethodMeta meta(Class entityClass, Method method, MethodType methodType, ArgumentMeta[] args, Class returnType, Class returnParameterType) {
        return new MethodMeta(entityClass, method, methodType, args, returnType, returnParameterType);
    }

    private ArgumentMeta[] buildArgumentMeta(MethodArgNames names, Parameter[] parameters) {
        ArgumentMeta[] args = new ArgumentMeta[parameters.length];
        int index = 0;
        for (int i = 0; i < parameters.length; ++i) {
            String name = names.get(index);
            if (name == null) {
                args[i] = new ArgumentMeta(this.methodType, parameters[i], null, i, null);
                continue;
            }
            args[i] = new ArgumentMeta(this.methodType, parameters[i], name, i, null);
            if (!Objects.equals(name, args[i].entryName)) continue;
            ++index;
        }
        return args;
    }

    public EntryMetas metas() {
        if (StringKit.isBlank(this.method)) {
            return this.buildMetasFromArgs();
        }
        MethodLock.lockDoing(MethodArgsMeta::containsKey, this.method, () -> MethodArgsMeta.put(this.method, this.buildMetasFromArgs()));
        return MethodArgsMeta.get(this.method);
    }

    private EntryMetas buildMetasFromArgs() {
        this.validate();
        EntryMetas argsMetas = new EntryMetas(null, this.isAnd());
        for (ArgumentMeta arg : this.argMetas) {
            if (ParameterizedTypes.notFormObject(arg.type)) {
                argsMetas.addMeta(new ArgEntryMeta(arg));
                continue;
            }
            EntryMetas entryMetas = EntryMetas.getFormMeta(arg.type);
            for (IEntryMeta entryMeta : entryMetas.allMetas()) {
                EntryMeta meta = (EntryMeta)entryMeta;
                if (meta.getter == null) continue;
                argsMetas.addMeta(new ArgEntryMeta(arg, meta));
            }
        }
        return argsMetas;
    }

    public boolean isAnd() {
        return this.argNames == null || this.argNames.isAnd;
    }

    private void validate() {
        if (this.entityClass == null) {
            throw new IllegalArgumentException("Annotation[@Action] must be declared on method[" + this.method + "].");
        }
        if (this.argMetas == null || this.argMetas.length == 0) {
            throw new IllegalArgumentException("Method[" + this.method + "] must be have one parameter.");
        }
        if (this.returnType == null) {
            throw new IllegalArgumentException("The result type can't be null.");
        }
    }

    private Class getParameterTypeOfReturn(Method method) {
        Class pType = null;
        Type rType = method.getGenericReturnType();
        if (rType instanceof ParameterizedType) {
            pType = (Class)((ParameterizedType)rType).getActualTypeArguments()[0];
        }
        return pType;
    }

    public boolean isCount() {
        return this.methodType == MethodType.Query && (this.isReturnInt() || this.isReturnLong());
    }

    public boolean isReturnNumber() {
        return this.isReturnInt() || this.isReturnLong();
    }

    public boolean isReturnLong() {
        return this.returnType == Long.class || this.returnType == Long.TYPE;
    }

    public boolean isReturnInt() {
        return this.returnType == Integer.class || this.returnType == Integer.TYPE;
    }

    public boolean isReturnBool() {
        return this.returnType == Boolean.class || this.returnType == Boolean.TYPE;
    }

    public boolean isReturnList() {
        return Collection.class.isAssignableFrom(this.returnType);
    }

    public boolean isReturnVoid() {
        return this.returnType == Void.TYPE || this.returnType == Void.class;
    }

    public boolean isStdPage() {
        return this.methodType == MethodType.Query && StdPagedList.class.isAssignableFrom(this.returnType);
    }

    public boolean isTagPage() {
        return this.methodType == MethodType.Query && TagPagedList.class.isAssignableFrom(this.returnType);
    }

    public boolean isList() {
        return this.methodType == MethodType.Query && Collection.class.isAssignableFrom(this.returnType);
    }

    public boolean isOneArgArr() {
        return this.argMetas.length == 1 && this.argMetas[0].isArray;
    }

    public boolean isOneArgListOrArray() {
        ArgumentMeta meta = this.argMetas[0];
        return this.argMetas.length == 1 && meta.entryType == EntryType.Form && (meta.isList || meta.isArray);
    }

    public boolean isQuery() {
        return this.methodType == null || this.methodType == MethodType.Query;
    }

    public boolean isUpdate() {
        return this.methodType == MethodType.Update;
    }

    public boolean isSave() {
        return this.methodType == MethodType.Save;
    }

    public boolean isDelete() {
        return this.methodType == MethodType.Delete;
    }

    public boolean isLogicDelete() {
        return this.methodType == MethodType.LogicDelete;
    }
}

