/*
 * Decompiled with CFR 0.152.
 */
package cn.org.atool.fluent.form.meta;

import cn.org.atool.fluent.common.kits.KeyMap;
import cn.org.atool.fluent.common.kits.ParameterizedTypes;
import cn.org.atool.fluent.common.kits.SegmentLocks;
import cn.org.atool.fluent.common.kits.StringKit;
import cn.org.atool.fluent.form.annotation.Entry;
import cn.org.atool.fluent.form.annotation.EntryType;
import cn.org.atool.fluent.form.annotation.Form;
import cn.org.atool.fluent.form.meta.EntryMeta;
import cn.org.atool.fluent.form.meta.FormMetas;
import cn.org.atool.fluent.form.meta.IEntryMeta;
import cn.org.atool.fluent.form.meta.entry.EntryMetaKit;
import cn.org.atool.fluent.form.meta.entry.MethodEntryMeta;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class EntryMetas
implements IEntryMeta {
    public final Class objType;
    private final List<IEntryMeta> metas = new ArrayList<IEntryMeta>();
    private final List<FormMetas> forms = new ArrayList<FormMetas>();
    private EntryMeta pageSize;
    private EntryMeta currPage;
    private EntryMeta pagedTag;
    private final List<EntryMeta> orderBy = new ArrayList<EntryMeta>();
    private boolean isUpdate = false;
    private final boolean isAnd;
    private static final KeyMap<EntryMetas> ClassFormMetas = new KeyMap();
    static List<String> root_classes = Arrays.asList(Object.class.getName(), "cn.org.atool.fluent.mybatis.base.RichEntity", "cn.org.atool.fluent.mybatis.base.BaseEntity");
    private static final SegmentLocks<Class> ClassLock = new SegmentLocks(16);

    public EntryMetas(Class objType, boolean isAnd) {
        this.objType = objType;
        this.isAnd = isAnd;
    }

    public Integer getPageSize(Object form) {
        return this.pageSize == null ? null : (Integer)this.pageSize.get(form);
    }

    public Integer getCurrPage(Object form) {
        return this.currPage == null ? null : (Integer)this.currPage.get(form);
    }

    public Object getPagedTag(Object form) {
        return this.pagedTag == null ? null : this.pagedTag.get(form);
    }

    public void addMeta(EntryMeta meta) {
        if (meta == null) {
            return;
        }
        switch (meta.entryType) {
            case Ignore: {
                return;
            }
            case PageSize: {
                this.pageSize = meta;
                break;
            }
            case CurrPage: {
                this.currPage = meta;
                break;
            }
            case PagedTag: {
                this.pagedTag = meta;
                break;
            }
            case Form: {
                throw new RuntimeException("can't add EntryType.Form directly.");
            }
            case Update: {
                this.isUpdate = true;
                this.metas.add(meta);
                break;
            }
            case OrderBy: {
                this.orderBy.add(meta);
                break;
            }
            default: {
                this.metas.add(meta);
            }
        }
    }

    public List<IEntryMeta> allMetas() {
        ArrayList<IEntryMeta> all = new ArrayList<IEntryMeta>();
        all.addAll(this.metas);
        all.addAll(this.orderBy);
        if (this.pageSize != null) {
            all.add(this.pageSize);
        }
        if (this.currPage != null) {
            all.add(this.currPage);
        }
        if (this.pagedTag != null) {
            all.add(this.pagedTag);
        }
        return all;
    }

    private void addMeta(String name, Method getter, Method setter, Entry entry) {
        if (getter != null || setter != null) {
            if (entry == null) {
                this.addMeta(new MethodEntryMeta(name, EntryType.EQ, getter, setter, true));
            } else {
                this.addMeta(new MethodEntryMeta(name, entry.type(), getter, setter, entry.ignoreNull()));
            }
        }
    }

    public static EntryMetas getFormMeta(Class aClass) {
        ClassLock.lockDoing(ClassFormMetas::containsKey, aClass, () -> ClassFormMetas.put(aClass, EntryMetas.buildFormMeta(aClass)));
        return ClassFormMetas.get(aClass);
    }

    private static EntryMetas buildFormMeta(Class aClass) {
        Form form = aClass.getDeclaredAnnotation(Form.class);
        EntryMetas metas = new EntryMetas(aClass, form == null || form.and());
        ClassFormMetas.put(aClass, metas);
        Class declared = aClass;
        while (!(root_classes.contains(declared.getName()) || declared.isPrimitive() || declared.getName().startsWith("java."))) {
            try {
                metas.addMetasByFormKits(declared);
            }
            catch (Exception ignored) {
                metas.addMetasByReflector(aClass, declared);
            }
            declared = declared.getSuperclass();
        }
        return metas;
    }

    private void addMetasByFormKits(Class declared) throws Exception {
        if (Objects.equals(declared, Object.class)) {
            return;
        }
        EntryMetaKit kit = (EntryMetaKit)Class.forName(declared.getName() + "MetaKit").getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        kit.entryMetas().forEach(this::addMeta);
    }

    private void addMetasByReflector(Class aClass, Class declared) {
        if (Objects.equals(declared, Object.class)) {
            return;
        }
        for (Field field : declared.getDeclaredFields()) {
            int mod = field.getModifiers();
            if (Modifier.isStatic(mod) || Modifier.isTransient(mod)) continue;
            Entry entry = field.getAnnotation(Entry.class);
            String name = this.noEntryName(entry) ? field.getName() : entry.value();
            Class fClass = this.getFieldType(field);
            Method setter = EntryMetas.findSetter(aClass, field);
            if (ParameterizedTypes.notFormObject(fClass)) {
                Method getter = EntryMetas.findGetter(aClass, field);
                if (getter == null && setter == null) continue;
                this.addMeta(name, getter, setter, entry);
                continue;
            }
            if (setter == null) continue;
            EntryMetas form = EntryMetas.getFormMeta(fClass);
            boolean isList = List.class.isAssignableFrom(field.getType());
            this.forms.add(new FormMetas(name, fClass, setter, isList, form));
        }
    }

    private Class getFieldType(Field field) {
        Class<Object> fClass = field.getType();
        if (List.class.isAssignableFrom(fClass)) {
            fClass = (Class<Object>)ParameterizedTypes.getType(field.getGenericType(), List.class, "E");
        }
        return fClass == null ? field.getType() : fClass;
    }

    private boolean noEntryName(Entry entry) {
        return entry == null || StringKit.isBlank(entry.value());
    }

    public static Method findGetter(Class klass, Field field) {
        String getter = field.getType() == Boolean.TYPE ? "is" + StringKit.capitalFirst(field.getName()) : "get" + StringKit.capitalFirst(field.getName());
        try {
            return klass.getMethod(getter, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    public static Method findSetter(Class klass, Field field) {
        String setter = field.getType() == Boolean.TYPE && field.getName().startsWith("is") ? "set" + StringKit.capitalFirst(field.getName().substring(2)) : "set" + StringKit.capitalFirst(field.getName());
        try {
            return klass.getMethod(setter, field.getType());
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    public Class getObjType() {
        return this.objType;
    }

    public List<IEntryMeta> getMetas() {
        return this.metas;
    }

    public List<FormMetas> getForms() {
        return this.forms;
    }

    public EntryMeta getPageSize() {
        return this.pageSize;
    }

    public EntryMeta getCurrPage() {
        return this.currPage;
    }

    public EntryMeta getPagedTag() {
        return this.pagedTag;
    }

    public List<EntryMeta> getOrderBy() {
        return this.orderBy;
    }

    public boolean isUpdate() {
        return this.isUpdate;
    }

    public boolean isAnd() {
        return this.isAnd;
    }

    public String toString() {
        return "EntryMetas(objType=" + this.getObjType() + ")";
    }
}

