/*
 * Decompiled with CFR 0.152.
 */
package cn.org.atool.fluent.form.meta;

import cn.org.atool.fluent.common.kits.ParameterizedTypes;
import cn.org.atool.fluent.common.kits.StringKit;
import cn.org.atool.fluent.form.annotation.Entry;
import cn.org.atool.fluent.form.annotation.EntryType;
import cn.org.atool.fluent.form.annotation.MethodType;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Collection;
import java.util.Map;
import java.util.function.Function;
import org.apache.ibatis.annotations.Param;

public class ArgumentMeta {
    public final String entryName;
    public final int index;
    public final boolean isList;
    public final boolean isArray;
    public final Class type;
    public final EntryType entryType;
    public final boolean ignoreNull;
    private static final Function nonConvert = obj -> obj;

    public ArgumentMeta(MethodType methodType, String entryName, EntryType type, Type argType, int index, Map types) {
        this.entryName = entryName;
        this.entryType = type == null ? EntryType.EQ : type;
        this.isList = Collection.class.isAssignableFrom(this.getRawType(argType));
        this.isArray = this.getRawType(argType).isArray();
        this.type = this.getArgType(methodType, argType, types);
        this.index = index;
        this.ignoreNull = true;
    }

    public ArgumentMeta(MethodType methodType, Parameter parameter, String defaultName, int index, Map types) {
        this.isList = Collection.class.isAssignableFrom(parameter.getType());
        this.isArray = parameter.getType().isArray();
        this.type = this.getArgType(methodType, parameter.getParameterizedType(), types);
        Entry entry = parameter.getDeclaredAnnotation(Entry.class);
        if (entry == null) {
            this.entryName = this.findEntryName(parameter, null, defaultName);
            this.ignoreNull = true;
            EntryType entryType = this.entryType = ParameterizedTypes.notFormObject(this.type) ? EntryType.EQ : EntryType.Form;
            if (this.entryType == EntryType.EQ && defaultName == null) {
                throw new IllegalStateException("Unable to resolve parameter[index=" + index + "] name of method[" + parameter.getDeclaringExecutable().toString() + "].");
            }
        } else {
            this.entryName = this.findEntryName(parameter, entry.value(), defaultName);
            this.ignoreNull = entry.ignoreNull();
            this.entryType = entry.type();
        }
        this.index = index;
    }

    private String findEntryName(Parameter parameter, String entryName, String defaultName) {
        if (StringKit.notBlank(entryName)) {
            return entryName;
        }
        Param param = parameter.getDeclaredAnnotation(Param.class);
        if (param != null && StringKit.notBlank(param.value())) {
            return param.value();
        }
        return defaultName;
    }

    private Class getArgType(MethodType methodType, Type pType, Map<String, Object> types) {
        Class klass = this.getRawType(pType);
        if (!this.isList || methodType == null || methodType == MethodType.Query) {
            return klass;
        }
        assert (pType instanceof ParameterizedType) : "List types must specify generic parameters";
        Type[] pTypes = ((ParameterizedType)pType).getActualTypeArguments();
        if (pTypes.length != 1) {
            throw new IllegalArgumentException("List types must specify generic parameters");
        }
        Type type = pTypes[0];
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return (Class)((ParameterizedType)type).getRawType();
        }
        if (type instanceof TypeVariable && types != null) {
            TypeVariable vType = (TypeVariable)type;
            String vName = vType.getTypeName() + ":" + vType.getGenericDeclaration().toString();
            return (Class)types.get(vName);
        }
        throw new IllegalArgumentException("List types must specify generic parameters");
    }

    private Class getRawType(Type pType) {
        if (pType instanceof Class) {
            return (Class)pType;
        }
        if (pType instanceof ParameterizedType) {
            return (Class)((ParameterizedType)pType).getRawType();
        }
        throw new IllegalArgumentException("The type of method parameter should be Class or ParameterizedType.");
    }

    public String toString() {
        return "ArgumentMeta(entryName=" + this.entryName + ", index=" + this.index + ", entryType=" + (Object)((Object)this.entryType) + ")";
    }
}

