/*
 * Decompiled with CFR 0.152.
 */
package cn.org.atool.fluent.form.meta;

import cn.org.atool.fluent.common.kits.KeyMap;
import cn.org.atool.fluent.common.kits.SegmentLocks;
import cn.org.atool.fluent.form.annotation.MethodType;
import cn.org.atool.fluent.form.meta.MethodArgNames;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Objects;

public class ArgNamesKit {
    private static final KeyMap<MethodArgNames> cached = new KeyMap();
    private static final SegmentLocks<String> lock = new SegmentLocks(32);
    private static final MethodArgNames MethodArgNameNotFound = new MethodArgNames(true, Collections.emptyList());

    public static MethodArgNames parseMethodStyle(String method) {
        lock.lockDoing(cached::containsKey, method, () -> cached.put(method, ArgNamesKit.internalParse(method)));
        return cached.get(method);
    }

    private static MethodArgNames internalParse(String method) {
        int index = method.indexOf("By");
        if (index <= 0) {
            return MethodArgNameNotFound;
        }
        String prefix = method.substring(0, index);
        if (MethodType.AUTO_PREFIX.contains(prefix)) {
            MethodArgNames names = ArgNamesKit.parseArgNames(method, index + 2);
            if (Objects.equals("top", prefix)) {
                names.setTopN(1);
            }
            return names;
        }
        if (prefix.matches("top\\d+")) {
            MethodArgNames names = ArgNamesKit.parseArgNames(method, index + 2);
            names.setTopN(Integer.parseInt(prefix.substring(3)));
            return names;
        }
        return MethodArgNameNotFound;
    }

    private static MethodArgNames parseArgNames(String method, int offset) {
        ArrayList<String> names = new ArrayList<String>();
        StringBuilder name = new StringBuilder();
        Boolean isAnd = null;
        int orderOffset = 0;
        int index = offset;
        while (index < method.length()) {
            char ch = method.charAt(index);
            if (ArgNamesKit.matchWord(method, index, "And") && ArgNamesKit.isCapital(method, index + 3)) {
                names.add(name.toString());
                name = new StringBuilder();
                index += 3;
                if (Objects.equals(isAnd, false)) {
                    throw new IllegalStateException("The method name[" + method + "] cannot contain both and or logic.");
                }
                isAnd = true;
                continue;
            }
            if (ArgNamesKit.matchWord(method, index, "Or") && ArgNamesKit.isCapital(method, index + 2)) {
                names.add(name.toString());
                name = new StringBuilder();
                index += 2;
                if (Objects.equals(isAnd, true)) {
                    throw new IllegalStateException("The method name[" + method + "] cannot contain both and or logic.");
                }
                isAnd = false;
                continue;
            }
            if (ArgNamesKit.matchWord(method, index, "OrderBy") && ArgNamesKit.isCapital(method, index + 7)) {
                orderOffset = index + 7;
                break;
            }
            name.append(ch);
            ++index;
        }
        if (!name.toString().isEmpty()) {
            names.add(name.toString());
        }
        MethodArgNames methodArgNames = new MethodArgNames(isAnd == null || isAnd != false, names);
        if (orderOffset == 0) {
            return methodArgNames;
        }
        name = new StringBuilder();
        int index2 = orderOffset;
        while (index2 < method.length()) {
            char ch = method.charAt(index2);
            if (ArgNamesKit.matchWord(method, index2, "Asc") && ArgNamesKit.isCapital(method, index2 + 3)) {
                methodArgNames.addOrderBy(name.toString(), true);
                name = new StringBuilder();
                index2 += 3;
                continue;
            }
            if (ArgNamesKit.matchWord(method, index2, "Desc") && ArgNamesKit.isCapital(method, index2 + 4)) {
                methodArgNames.addOrderBy(name.toString(), false);
                name = new StringBuilder();
                index2 += 4;
                continue;
            }
            name.append(ch);
            ++index2;
        }
        if (!name.toString().isEmpty()) {
            methodArgNames.addOrderBy(name.toString(), true);
        }
        return methodArgNames;
    }

    static boolean isCapital(String text, int index) {
        if (text.length() <= index) {
            return true;
        }
        char ch = text.charAt(index);
        return ch >= 'A' && ch <= 'Z';
    }

    public static boolean matchWord(String text, int start, String word) {
        if (text.length() < start + word.length()) {
            return false;
        }
        for (int index = 0; index < word.length(); ++index) {
            if (text.charAt(start + index) == word.charAt(index)) continue;
            return false;
        }
        return true;
    }
}

