/*
 * Decompiled with CFR 0.152.
 */
package cn.org.atool.fluent.common.kits;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.time.temporal.Temporal;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class ParameterizedTypes {
    public static <T> T getType(Type type, Class declared, String genericName) {
        Map map = ParameterizedTypes.getTypeMap(type, declared);
        return ParameterizedTypes.getDeclaredType(map, declared, genericName);
    }

    public static <T> T getDeclaredType(Map<String, Object> map, Type declared, String genericName) {
        String name = genericName + ":" + declared.toString();
        while (map.containsKey(name)) {
            Object value = map.get(name);
            if (value instanceof String) {
                name = (String)value;
                continue;
            }
            return (T)value;
        }
        return null;
    }

    public static ParameterizedType toParameterizedType(Type type, Class declared) {
        Type[] genericInterfaces;
        if (type instanceof ParameterizedType) {
            return (ParameterizedType)type;
        }
        if (!(type instanceof Class) || Object.class.equals((Object)type)) {
            return null;
        }
        Class clazz = (Class)type;
        if (!declared.isAssignableFrom(clazz)) {
            return null;
        }
        if (clazz.getSuperclass() != null && declared.isAssignableFrom(clazz.getSuperclass())) {
            return ParameterizedTypes.toParameterizedType(clazz.getGenericSuperclass(), declared);
        }
        for (Type gi : genericInterfaces = clazz.getGenericInterfaces()) {
            Type raw;
            if (gi instanceof Class && declared.isAssignableFrom((Class)gi)) {
                return ParameterizedTypes.toParameterizedType(gi, declared);
            }
            if (!(gi instanceof ParameterizedType) || !((raw = ((ParameterizedType)gi).getRawType()) instanceof Class) || !declared.isAssignableFrom((Class)raw)) continue;
            return ParameterizedTypes.toParameterizedType(gi, declared);
        }
        return null;
    }

    public static Map getTypeMap(Type type, Class declared) {
        ParameterizedType parameterizedType;
        HashMap<String, Object> typeMap = new HashMap<String, Object>();
        while (null != type && null != (parameterizedType = ParameterizedTypes.toParameterizedType(type, declared))) {
            Type[] typeArguments = parameterizedType.getActualTypeArguments();
            Class rawType = (Class)parameterizedType.getRawType();
            TypeVariable<Class<T>>[] typeParameters = rawType.getTypeParameters();
            for (int index = 0; index < typeParameters.length; ++index) {
                typeMap.put((String)ParameterizedTypes.typeName(typeParameters[index]), ParameterizedTypes.typeName(typeArguments[index]));
            }
            type = rawType;
        }
        return typeMap;
    }

    private static Object typeName(Type type) {
        if (type instanceof TypeVariable) {
            Object g = ((TypeVariable)type).getGenericDeclaration();
            return type.getTypeName() + ":" + g.toString();
        }
        return type;
    }

    public static boolean notFormObject(Class type) {
        if (type.isPrimitive() || type.isEnum() || type.getName().startsWith("java.")) {
            return true;
        }
        if (Collection.class.isAssignableFrom(type) || type.isArray() || Map.class.isAssignableFrom(type)) {
            return true;
        }
        return Date.class.isAssignableFrom(type) || Temporal.class.isAssignableFrom(type);
    }
}

