/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.quest;

import com.almasb.fxgl.logging.Logger;
import com.almasb.fxgl.quest.BooleanQuestObjective;
import com.almasb.fxgl.quest.IntQuestObjective;
import com.almasb.fxgl.quest.QuestObjective;
import com.almasb.fxgl.quest.QuestState;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.binding.ObjectBinding;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableObjectValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.util.Duration;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J*\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u00062\b\b\u0002\u0010\u001c\u001a\u00020\u001dH\u0007J*\u0010\u001e\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u001f2\b\b\u0002\u0010\u001c\u001a\u00020\u001dH\u0007J\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u000fH\u0002J\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eJ\b\u0010$\u001a\u00020!H\u0002J\u000e\u0010%\u001a\u00020!2\u0006\u0010\"\u001a\u00020\u000fJ\r\u0010&\u001a\u00020!H\u0000\u00a2\u0006\u0002\b'J\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00130)R\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR2\u0010\r\u001a&\u0012\f\u0012\n \u0010*\u0004\u0018\u00010\u000f0\u000f \u0010*\u0012\u0012\f\u0012\n \u0010*\u0004\u0018\u00010\u000f0\u000f\u0018\u00010\u000e0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\u0011\u001a&\u0012\f\u0012\n \u0010*\u0004\u0018\u00010\u000f0\u000f \u0010*\u0012\u0012\f\u0012\n \u0010*\u0004\u0018\u00010\u000f0\u000f\u0018\u00010\u000e0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0012\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u001c\u0010\u0016\u001a\u0010\u0012\f\u0012\n \u0010*\u0004\u0018\u00010\u00130\u00130\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/almasb/fxgl/quest/Quest;", "", "name", "", "(Ljava/lang/String;)V", "hasStarted", "", "getHasStarted", "()Z", "log", "Lcom/almasb/fxgl/logging/Logger;", "getName", "()Ljava/lang/String;", "objectives", "Ljavafx/collections/ObservableList;", "Lcom/almasb/fxgl/quest/QuestObjective;", "kotlin.jvm.PlatformType", "objectivesReadOnly", "state", "Lcom/almasb/fxgl/quest/QuestState;", "getState", "()Lcom/almasb/fxgl/quest/QuestState;", "stateProp", "Ljavafx/beans/property/ReadOnlyObjectWrapper;", "addBooleanObjective", "desc", "varName", "varValue", "duration", "Ljavafx/util/Duration;", "addIntObjective", "", "addObjective", "", "objective", "objectivesProperty", "rebindStateToObjectives", "removeObjective", "start", "start$fxgl_gameplay", "stateProperty", "Ljavafx/beans/property/ReadOnlyObjectProperty;", "fxgl-gameplay"})
@SourceDebugExtension(value={"SMAP\nQuest.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Quest.kt\ncom/almasb/fxgl/quest/Quest\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,267:1\n1#2:268\n1549#3:269\n1620#3,3:270\n1819#3,8:273\n1549#3:281\n1620#3,3:282\n1819#3,8:285\n*S KotlinDebug\n*F\n+ 1 Quest.kt\ncom/almasb/fxgl/quest/Quest\n*L\n95#1:269\n95#1:270,3\n96#1:273,8\n100#1:281\n100#1:282,3\n101#1:285,8\n*E\n"})
public final class Quest {
    @NotNull
    private final String name;
    @NotNull
    private final Logger log;
    private final ObservableList<QuestObjective> objectives;
    private final ObservableList<QuestObjective> objectivesReadOnly;
    @NotNull
    private final ReadOnlyObjectWrapper<QuestState> stateProp;

    public Quest(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.name = name;
        this.log = Logger.Companion.get(this.getClass());
        this.objectives = FXCollections.observableArrayList();
        this.objectivesReadOnly = FXCollections.unmodifiableObservableList(this.objectives);
        this.stateProp = new ReadOnlyObjectWrapper((Object)QuestState.NOT_STARTED);
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final ObservableList<QuestObjective> objectivesProperty() {
        ObservableList<QuestObjective> observableList = this.objectivesReadOnly;
        Intrinsics.checkNotNullExpressionValue(observableList, (String)"objectivesReadOnly");
        return observableList;
    }

    @NotNull
    public final QuestState getState() {
        Object object = this.stateProp.get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"stateProp.get()");
        return (QuestState)((Object)object);
    }

    @NotNull
    public final ReadOnlyObjectProperty<QuestState> stateProperty() {
        ReadOnlyObjectProperty readOnlyObjectProperty = this.stateProp.getReadOnlyProperty();
        Intrinsics.checkNotNullExpressionValue((Object)readOnlyObjectProperty, (String)"stateProp.readOnlyProperty");
        return readOnlyObjectProperty;
    }

    public final boolean getHasStarted() {
        return this.getState() != QuestState.NOT_STARTED;
    }

    @JvmOverloads
    @NotNull
    public final QuestObjective addIntObjective(@NotNull String desc, @NotNull String varName, int varValue, @NotNull Duration duration) {
        IntQuestObjective intQuestObjective;
        Intrinsics.checkNotNullParameter((Object)desc, (String)"desc");
        Intrinsics.checkNotNullParameter((Object)varName, (String)"varName");
        Intrinsics.checkNotNullParameter((Object)duration, (String)"duration");
        IntQuestObjective it = intQuestObjective = new IntQuestObjective(desc, varName, varValue, duration);
        boolean bl = false;
        this.addObjective(it);
        return intQuestObjective;
    }

    public static /* synthetic */ QuestObjective addIntObjective$default(Quest quest, String string, String string2, int n, Duration duration, int n2, Object object) {
        if ((n2 & 8) != 0) {
            Duration duration2 = Duration.ZERO;
            Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"ZERO");
            duration = duration2;
        }
        return quest.addIntObjective(string, string2, n, duration);
    }

    @JvmOverloads
    @NotNull
    public final QuestObjective addBooleanObjective(@NotNull String desc, @NotNull String varName, boolean varValue, @NotNull Duration duration) {
        BooleanQuestObjective booleanQuestObjective;
        Intrinsics.checkNotNullParameter((Object)desc, (String)"desc");
        Intrinsics.checkNotNullParameter((Object)varName, (String)"varName");
        Intrinsics.checkNotNullParameter((Object)duration, (String)"duration");
        BooleanQuestObjective it = booleanQuestObjective = new BooleanQuestObjective(desc, varName, varValue, duration);
        boolean bl = false;
        this.addObjective(it);
        return booleanQuestObjective;
    }

    public static /* synthetic */ QuestObjective addBooleanObjective$default(Quest quest, String string, String string2, boolean bl, Duration duration, int n, Object object) {
        if ((n & 8) != 0) {
            Duration duration2 = Duration.ZERO;
            Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"ZERO");
            duration = duration2;
        }
        return quest.addBooleanObjective(string, string2, bl, duration);
    }

    private final void addObjective(QuestObjective objective) {
        ObservableList<QuestObjective> observableList = this.objectives;
        Intrinsics.checkNotNullExpressionValue(observableList, (String)"objectives");
        ((Collection)observableList).add(objective);
        if (this.getHasStarted()) {
            this.rebindStateToObjectives();
        }
    }

    public final void removeObjective(@NotNull QuestObjective objective) {
        Intrinsics.checkNotNullParameter((Object)objective, (String)"objective");
        ObservableList<QuestObjective> observableList = this.objectives;
        Intrinsics.checkNotNullExpressionValue(observableList, (String)"objectives");
        ((Collection)observableList).remove(objective);
        if (this.getHasStarted()) {
            this.rebindStateToObjectives();
        }
    }

    public final void start$fxgl_gameplay() {
        if (this.objectives.isEmpty()) {
            this.log.warning("Cannot start quest " + this.name + " because it has no objectives");
            return;
        }
        if (this.getHasStarted()) {
            this.log.warning("Cannot start quest " + this.name + " because it has already been started");
            return;
        }
        this.rebindStateToObjectives();
    }

    /*
     * WARNING - void declaration
     */
    private final void rebindStateToObjectives() {
        void $this$foldRight$iv;
        void $this$mapTo$iv$iv;
        Object state;
        void $this$foldRight$iv2;
        Collection collection;
        void $this$mapTo$iv$iv2;
        ObservableList<QuestObjective> observableList = this.objectives;
        Intrinsics.checkNotNullExpressionValue(observableList, (String)"objectives");
        Iterable $this$map$iv = (Iterable)observableList;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            QuestObjective questObjective = (QuestObjective)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.stateProperty());
        }
        $this$map$iv = (List)destination$iv$iv;
        BooleanBinding initial$iv = Bindings.createBooleanBinding(Quest::rebindStateToObjectives$lambda$3, (Observable[])new Observable[0]);
        boolean $i$f$foldRight = false;
        Object accumulator$iv = initial$iv;
        if (!$this$foldRight$iv2.isEmpty()) {
            ListIterator iterator$iv = $this$foldRight$iv2.listIterator($this$foldRight$iv2.size());
            while (iterator$iv.hasPrevious()) {
                void binding;
                BooleanBinding booleanBinding = accumulator$iv;
                state = (ReadOnlyObjectProperty)iterator$iv.previous();
                boolean bl = false;
                accumulator$iv = state.isEqualTo((Object)QuestState.FAILED).or((ObservableBooleanValue)binding);
            }
        }
        BooleanBinding failedBinding = accumulator$iv;
        ObservableList<QuestObjective> observableList2 = this.objectives;
        Intrinsics.checkNotNullExpressionValue(observableList2, (String)"objectives");
        Iterable $this$map$iv2 = (Iterable)observableList2;
        boolean $i$f$map2 = false;
        accumulator$iv = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            QuestObjective bl = (QuestObjective)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl2 = false;
            collection.add(it.stateProperty());
        }
        $this$map$iv2 = (List)destination$iv$iv2;
        BooleanBinding initial$iv2 = Bindings.createBooleanBinding(Quest::rebindStateToObjectives$lambda$6, (Observable[])new Observable[0]);
        boolean $i$f$foldRight2 = false;
        BooleanBinding accumulator$iv2 = initial$iv2;
        if (!$this$foldRight$iv.isEmpty()) {
            ListIterator iterator$iv = $this$foldRight$iv.listIterator($this$foldRight$iv.size());
            while (iterator$iv.hasPrevious()) {
                void binding;
                state = accumulator$iv2;
                ReadOnlyObjectProperty state2 = (ReadOnlyObjectProperty)iterator$iv.previous();
                boolean bl = false;
                accumulator$iv2 = state2.isEqualTo((Object)QuestState.COMPLETED).and((ObservableBooleanValue)binding);
            }
        }
        BooleanBinding completedBinding = accumulator$iv2;
        ObjectBinding intermediateBinding = Bindings.when((ObservableBooleanValue)((ObservableBooleanValue)completedBinding)).then((Object)QuestState.COMPLETED).otherwise((Object)QuestState.ACTIVE);
        ObjectBinding finalBinding = Bindings.when((ObservableBooleanValue)((ObservableBooleanValue)failedBinding)).then((Object)QuestState.FAILED).otherwise((ObservableObjectValue)intermediateBinding);
        this.stateProp.bind((ObservableValue)finalBinding);
    }

    @JvmOverloads
    @NotNull
    public final QuestObjective addIntObjective(@NotNull String desc, @NotNull String varName, int varValue) {
        Intrinsics.checkNotNullParameter((Object)desc, (String)"desc");
        Intrinsics.checkNotNullParameter((Object)varName, (String)"varName");
        return Quest.addIntObjective$default(this, desc, varName, varValue, null, 8, null);
    }

    @JvmOverloads
    @NotNull
    public final QuestObjective addBooleanObjective(@NotNull String desc, @NotNull String varName, boolean varValue) {
        Intrinsics.checkNotNullParameter((Object)desc, (String)"desc");
        Intrinsics.checkNotNullParameter((Object)varName, (String)"varName");
        return Quest.addBooleanObjective$default(this, desc, varName, varValue, null, 8, null);
    }

    private static final Boolean rebindStateToObjectives$lambda$3() {
        return false;
    }

    private static final Boolean rebindStateToObjectives$lambda$6() {
        return true;
    }
}

