/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.minigames.triggersequence;

import com.almasb.fxgl.input.KeyTrigger;
import com.almasb.fxgl.input.Trigger;
import com.almasb.fxgl.input.view.TriggerView;
import com.almasb.fxgl.logging.Logger;
import com.almasb.fxgl.minigames.MiniGame;
import com.almasb.fxgl.minigames.MiniGameResult;
import com.almasb.fxgl.minigames.triggersequence.TriggerSequenceResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javafx.beans.value.ObservableValue;
import javafx.scene.input.KeyCode;
import javafx.scene.paint.Color;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0016J\u000e\u0010#\u001a\u00020\u00072\u0006\u0010$\u001a\u00020%R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\f\"\u0004\b\u0012\u0010\u000eR\u001a\u0010\u0013\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\f\"\u0004\b\u0015\u0010\u000eR!\u0010\u0016\u001a\u0012\u0012\u0004\u0012\u00020\u00180\u0017j\b\u0012\u0004\u0012\u00020\u0018`\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR!\u0010\u001c\u001a\u0012\u0012\u0004\u0012\u00020\u001d0\u0017j\b\u0012\u0004\u0012\u00020\u001d`\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001b\u00a8\u0006&"}, d2={"Lcom/almasb/fxgl/minigames/triggersequence/TriggerSequenceMiniGame;", "Lcom/almasb/fxgl/minigames/MiniGame;", "Lcom/almasb/fxgl/minigames/triggersequence/TriggerSequenceResult;", "()V", "currentIndex", "", "firstTime", "", "log", "Lcom/almasb/fxgl/logging/Logger;", "moveSpeed", "getMoveSpeed", "()I", "setMoveSpeed", "(I)V", "numCorrectTriggers", "numTriggers", "getNumTriggers", "setNumTriggers", "numTriggersForSuccess", "getNumTriggersForSuccess", "setNumTriggersForSuccess", "triggers", "Ljava/util/ArrayList;", "Lcom/almasb/fxgl/input/KeyTrigger;", "Lkotlin/collections/ArrayList;", "getTriggers", "()Ljava/util/ArrayList;", "views", "Lcom/almasb/fxgl/input/view/TriggerView;", "getViews", "onUpdate", "", "tpf", "", "press", "key", "Ljavafx/scene/input/KeyCode;", "fxgl-gameplay"})
@SourceDebugExtension(value={"SMAP\nTriggerSequenceMiniGame.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TriggerSequenceMiniGame.kt\ncom/almasb/fxgl/minigames/triggersequence/TriggerSequenceMiniGame\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,177:1\n1549#2:178\n1620#2,3:179\n1864#2,3:182\n1855#2,2:185\n*S KotlinDebug\n*F\n+ 1 TriggerSequenceMiniGame.kt\ncom/almasb/fxgl/minigames/triggersequence/TriggerSequenceMiniGame\n*L\n140#1:178\n140#1:179,3\n141#1:182,3\n150#1:185,2\n*E\n"})
public final class TriggerSequenceMiniGame
extends MiniGame<TriggerSequenceResult> {
    @NotNull
    private final Logger log = Logger.Companion.get(this.getClass());
    private int numTriggersForSuccess;
    private int numTriggers = 4;
    private int moveSpeed = 350;
    private int numCorrectTriggers;
    private int currentIndex;
    @NotNull
    private final ArrayList<KeyTrigger> triggers = new ArrayList();
    @NotNull
    private final ArrayList<TriggerView> views = new ArrayList();
    private boolean firstTime = true;

    public final int getNumTriggersForSuccess() {
        return this.numTriggersForSuccess;
    }

    public final void setNumTriggersForSuccess(int n) {
        this.numTriggersForSuccess = n;
    }

    public final int getNumTriggers() {
        return this.numTriggers;
    }

    public final void setNumTriggers(int n) {
        this.numTriggers = n;
    }

    public final int getMoveSpeed() {
        return this.moveSpeed;
    }

    public final void setMoveSpeed(int n) {
        this.moveSpeed = n;
    }

    @NotNull
    public final ArrayList<KeyTrigger> getTriggers() {
        return this.triggers;
    }

    @NotNull
    public final ArrayList<TriggerView> getViews() {
        return this.views;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void onUpdate(double tpf) {
        if (this.firstTime) {
            Iterator $this$mapTo$iv$iv;
            this.numTriggersForSuccess = this.triggers.size();
            Collection collection = this.views;
            Iterable $this$map$iv = this.triggers;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            int $i$f$mapTo = 0;
            TriggerView triggerView = $this$mapTo$iv$iv.iterator();
            while (triggerView.hasNext()) {
                void it;
                Object item$iv$iv = triggerView.next();
                KeyTrigger keyTrigger = (KeyTrigger)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                boolean bl = false;
                Trigger trigger = (Trigger)it;
                Color color = Color.GRAY;
                Intrinsics.checkNotNullExpressionValue((Object)color, (String)"GRAY");
                collection2.add(new TriggerView(trigger, color, 74.0));
            }
            $this$map$iv = (List)destination$iv$iv;
            CollectionsKt.addAll((Collection)collection, (Iterable)$this$map$iv);
            Iterable $this$forEachIndexed$iv = this.views;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void item;
                if (($i$f$mapTo = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                triggerView = (TriggerView)item$iv;
                int i = $i$f$mapTo;
                boolean bl = false;
                item.setTranslateX(400.0 + (double)(300 * i));
                item.setTranslateY(100.0);
                item.opacityProperty().bind((ObservableValue)item.translateXProperty().divide((double)this.numTriggers * 100.0).negate().add(1));
            }
            this.firstTime = false;
        }
        Iterable $this$forEach$iv = this.views;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TriggerView it = (TriggerView)element$iv;
            boolean bl = false;
            it.setTranslateX(it.getTranslateX() - (double)this.moveSpeed * tpf);
        }
    }

    public final boolean press(@NotNull KeyCode key) {
        boolean ok;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        if (this.currentIndex >= this.triggers.size()) {
            this.log.warning("Current index is greater or equal to number of triggers");
            this.setDone(true);
            this.setResult((MiniGameResult)new TriggerSequenceResult(true));
            return true;
        }
        int n = this.currentIndex;
        this.currentIndex = n + 1;
        boolean bl = ok = this.triggers.get(n).getKey() == key;
        if (ok) {
            n = this.numCorrectTriggers;
            this.numCorrectTriggers = n + 1;
        }
        if (this.currentIndex == this.triggers.size()) {
            this.setDone(true);
            this.setResult((MiniGameResult)new TriggerSequenceResult(this.numCorrectTriggers >= this.numTriggersForSuccess));
        }
        return ok;
    }
}

