/*
 * Decompiled with CFR 0.152.
 */
package com.github.aivancioglo.resttest.http;

import com.github.aivancioglo.resttest.http.HTTPResponse;
import com.github.aivancioglo.resttest.http.OAuth1;
import com.github.aivancioglo.resttest.http.OAuth2;
import com.github.aivancioglo.resttest.setters.Setter;
import io.restassured.RestAssured;
import io.restassured.config.HttpClientConfig;
import io.restassured.http.ContentType;
import io.restassured.http.Method;
import io.restassured.response.Response;
import io.restassured.response.ResponseOptions;
import io.restassured.specification.RequestSpecification;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 &2\u00020\u0001:\u0001&B\u0005\u00a2\u0006\u0002\u0010\u0002J)\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0012\u0010\u001d\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001f0\u001e\"\u00020\u001fH\u0004\u00a2\u0006\u0002\u0010 J1\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010!\u001a\u00020\u00042\u0012\u0010\u001d\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001f0\u001e\"\u00020\u001fH\u0004\u00a2\u0006\u0002\u0010\"J!\u0010#\u001a\u00020$2\u0012\u0010\u001d\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001f0\u001e\"\u00020\u001fH\u0004\u00a2\u0006\u0002\u0010%R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R$\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0004@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0006\"\u0004\b\u0014\u0010\bR\u0011\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006'"}, d2={"Lcom/github/aivancioglo/resttest/http/HTTPRequest;", "", "()V", "host", "", "getHost", "()Ljava/lang/String;", "setHost", "(Ljava/lang/String;)V", "oAuth1", "Lcom/github/aivancioglo/resttest/http/OAuth1;", "getOAuth1", "()Lcom/github/aivancioglo/resttest/http/OAuth1;", "oAuth2", "Lcom/github/aivancioglo/resttest/http/OAuth2;", "getOAuth2", "()Lcom/github/aivancioglo/resttest/http/OAuth2;", "value", "protocol", "getProtocol", "setProtocol", "requestSpecification", "Lio/restassured/specification/RequestSpecification;", "getRequestSpecification", "()Lio/restassured/specification/RequestSpecification;", "send", "Lcom/github/aivancioglo/resttest/http/HTTPResponse;", "method", "Lio/restassured/http/Method;", "setters", "", "Lcom/github/aivancioglo/resttest/setters/Setter;", "(Lio/restassured/http/Method;[Lcom/github/aivancioglo/resttest/setters/Setter;)Lcom/github/aivancioglo/resttest/http/HTTPResponse;", "path", "(Lio/restassured/http/Method;Ljava/lang/String;[Lcom/github/aivancioglo/resttest/setters/Setter;)Lcom/github/aivancioglo/resttest/http/HTTPResponse;", "set", "", "([Lcom/github/aivancioglo/resttest/setters/Setter;)V", "Companion", "resttest"})
public class HTTPRequest {
    @NotNull
    private final RequestSpecification requestSpecification;
    @NotNull
    private final OAuth1 oAuth1;
    @NotNull
    private final OAuth2 oAuth2;
    @NotNull
    private String protocol;
    @NotNull
    private String host;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final RequestSpecification getRequestSpecification() {
        return this.requestSpecification;
    }

    @NotNull
    public final OAuth1 getOAuth1() {
        return this.oAuth1;
    }

    @NotNull
    public final OAuth2 getOAuth2() {
        return this.oAuth2;
    }

    @NotNull
    public final String getProtocol() {
        return this.protocol;
    }

    public final void setProtocol(@NotNull String value) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        this.protocol = "" + value + "://";
    }

    @NotNull
    public final String getHost() {
        return this.host;
    }

    public final void setHost(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
        this.host = string;
    }

    protected final void set(Setter ... setters) {
        Intrinsics.checkParameterIsNotNull((Object)setters, (String)"setters");
        for (Setter setter : setters) {
            setter.update(this);
        }
    }

    @NotNull
    protected final HTTPResponse send(@NotNull Method method, Setter ... setters) {
        Intrinsics.checkParameterIsNotNull((Object)method, (String)"method");
        Intrinsics.checkParameterIsNotNull((Object)setters, (String)"setters");
        for (Setter setter : setters) {
            setter.update(this);
        }
        if (this.oAuth1.getUsed() && this.oAuth2.getUsed()) {
            throw (Throwable)new RuntimeException("You can not use OAuth 1.0 and OAuth 2 in the same requestSpecification!");
        }
        if (this.oAuth1.getUsed()) {
            this.requestSpecification.auth().oauth(this.oAuth1.getConsumerKey(), this.oAuth1.getConsumerSecret(), this.oAuth1.getToken(), this.oAuth1.getTokenSecret());
        }
        if (this.oAuth2.getUsed()) {
            this.requestSpecification.auth().oauth2(this.oAuth2.getToken());
        }
        this.requestSpecification.baseUri(this.protocol + this.host);
        ResponseOptions responseOptions = this.requestSpecification.request(method);
        Intrinsics.checkExpressionValueIsNotNull((Object)responseOptions, (String)"requestSpecification.request(method)");
        return new HTTPResponse((Response)responseOptions);
    }

    @NotNull
    protected final HTTPResponse send(@NotNull Method method, @NotNull String path2, Setter ... setters) {
        Intrinsics.checkParameterIsNotNull((Object)method, (String)"method");
        Intrinsics.checkParameterIsNotNull((Object)path2, (String)"path");
        Intrinsics.checkParameterIsNotNull((Object)setters, (String)"setters");
        for (Setter setter : setters) {
            setter.update(this);
        }
        if (this.oAuth1.getUsed() && this.oAuth2.getUsed()) {
            throw (Throwable)new RuntimeException("You can not use OAuth 1.0 and OAuth 2 in the same requestSpecification!");
        }
        if (this.oAuth1.getUsed()) {
            this.requestSpecification.auth().oauth(this.oAuth1.getConsumerKey(), this.oAuth1.getConsumerSecret(), this.oAuth1.getToken(), this.oAuth1.getTokenSecret());
        }
        if (this.oAuth2.getUsed()) {
            this.requestSpecification.auth().oauth2(this.oAuth2.getToken());
        }
        this.requestSpecification.baseUri(this.protocol + this.host);
        ResponseOptions responseOptions = this.requestSpecification.request(method, path2, new Object[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)responseOptions, (String)"requestSpecification.request(method, path)");
        return new HTTPResponse((Response)responseOptions);
    }

    public HTTPRequest() {
        RequestSpecification requestSpecification = RestAssured.given().contentType(ContentType.JSON);
        if (requestSpecification == null) {
            Intrinsics.throwNpe();
        }
        this.requestSpecification = requestSpecification;
        this.oAuth1 = new OAuth1();
        this.oAuth2 = new OAuth2();
        this.protocol = "http://";
        this.host = "";
    }

    static {
        RestAssured.useRelaxedHTTPSValidation();
        RestAssured.enableLoggingOfRequestAndResponseIfValidationFails();
        RestAssured.config = RestAssured.config().httpClient(HttpClientConfig.httpClientConfig().setParam("http.connection.timeout", (Object)20000).setParam("http.socket.timeout", (Object)60000));
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/github/aivancioglo/resttest/http/HTTPRequest$Companion;", "", "()V", "resttest"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

