/*
 * Decompiled with CFR 0.152.
 */
package com.github.abel533.echarts.json;

import com.github.abel533.echarts.axis.Axis;
import com.github.abel533.echarts.axis.CategoryAxis;
import com.github.abel533.echarts.axis.TimeAxis;
import com.github.abel533.echarts.axis.ValueAxis;
import com.github.abel533.echarts.code.AxisType;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;

public class AxisDeserializer
implements JsonDeserializer<Axis> {
    public Axis deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject jsonObject = json.getAsJsonObject();
        String _type = jsonObject.get("type").getAsString();
        AxisType type = AxisType.valueOf(_type);
        Axis axis = null;
        switch (type) {
            case category: {
                axis = (Axis)context.deserialize((JsonElement)jsonObject, CategoryAxis.class);
                break;
            }
            case value: {
                axis = (Axis)context.deserialize((JsonElement)jsonObject, ValueAxis.class);
                break;
            }
            case time: {
                axis = (Axis)context.deserialize((JsonElement)jsonObject, TimeAxis.class);
            }
        }
        return axis;
    }
}

