/*
 * Decompiled with CFR 0.152.
 */
package com.gccloud.dataset.typehandler;

import com.gccloud.common.utils.JSON;
import com.gccloud.dataset.entity.config.BaseDataSetConfig;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.type.BaseTypeHandler;
import org.apache.ibatis.type.JdbcType;
import org.apache.ibatis.type.MappedJdbcTypes;
import org.apache.ibatis.type.MappedTypes;

@MappedJdbcTypes(value={JdbcType.VARCHAR})
@MappedTypes(value={BaseDataSetConfig.class})
public class BaseDataSetConfigTypeHandler
extends BaseTypeHandler<BaseDataSetConfig> {
    public void setNonNullParameter(PreparedStatement preparedStatement, int i, BaseDataSetConfig obj, JdbcType jdbcType) throws SQLException {
        String data = JSON.toJSONString((Object)obj);
        preparedStatement.setString(i, data);
    }

    public BaseDataSetConfig getNullableResult(ResultSet resultSet, String columnName) throws SQLException {
        String data = resultSet.getString(columnName);
        if (StringUtils.isBlank((CharSequence)data)) {
            return null;
        }
        BaseDataSetConfig baseDatasetConfig = (BaseDataSetConfig)JSON.parseObject((String)data, BaseDataSetConfig.class);
        return baseDatasetConfig;
    }

    public BaseDataSetConfig getNullableResult(ResultSet resultSet, int i) throws SQLException {
        String data = resultSet.getString(i);
        if (StringUtils.isBlank((CharSequence)data)) {
            return null;
        }
        BaseDataSetConfig baseDatasetConfig = (BaseDataSetConfig)JSON.parseObject((String)data, BaseDataSetConfig.class);
        return baseDatasetConfig;
    }

    public BaseDataSetConfig getNullableResult(CallableStatement callableStatement, int i) throws SQLException {
        String data = callableStatement.getString(i);
        if (StringUtils.isBlank((CharSequence)data)) {
            return null;
        }
        BaseDataSetConfig baseDatasetConfig = (BaseDataSetConfig)JSON.parseObject((String)data, BaseDataSetConfig.class);
        return baseDatasetConfig;
    }
}

