/*
 * Decompiled with CFR 0.152.
 */
package com.gccloud.dataset.service.impl.dataset;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.gccloud.common.entity.SuperEntity;
import com.gccloud.common.vo.PageVO;
import com.gccloud.dataset.dao.DatasetDao;
import com.gccloud.dataset.dto.DatasetParamDTO;
import com.gccloud.dataset.dto.DatasetSearchDTO;
import com.gccloud.dataset.dto.TestExecuteDTO;
import com.gccloud.dataset.entity.DatasetEntity;
import com.gccloud.dataset.extend.dataset.DatasetExtendClient;
import com.gccloud.dataset.permission.DatasetPermissionClient;
import com.gccloud.dataset.service.IBaseDataSetService;
import com.gccloud.dataset.service.ICategoryService;
import com.gccloud.dataset.vo.DataVO;
import com.gccloud.dataset.vo.DeleteCheckVO;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;

@Primary
@Service(value="baseDataSetService")
public class BaseDatasetServiceImpl
extends ServiceImpl<DatasetDao, DatasetEntity>
implements IBaseDataSetService {
    private static final Logger log = LoggerFactory.getLogger(BaseDatasetServiceImpl.class);
    @Resource
    private ICategoryService categoryService;
    @Resource
    private DatasetPermissionClient datasetPermissionClient;
    @Resource
    private DatasetExtendClient extendClient;

    @Override
    public List<DatasetEntity> getList(DatasetSearchDTO searchDTO) {
        if (!this.datasetPermissionClient.hasPermissionService()) {
            return IBaseDataSetService.super.getList(searchDTO);
        }
        LambdaQueryWrapper<DatasetEntity> queryWrapper = this.getQueryWrapper(searchDTO);
        queryWrapper.select((Object[])new SFunction[]{SuperEntity::getId});
        List datasetList = this.list((Wrapper)queryWrapper);
        List<String> datasetIdList = datasetList.stream().map(SuperEntity::getId).collect(Collectors.toList());
        List<String> filterIdList = this.datasetPermissionClient.filterByPermission(datasetIdList, searchDTO.getDatasetType());
        if (filterIdList == null || filterIdList.isEmpty()) {
            return Lists.newArrayList();
        }
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.in(SuperEntity::getId, filterIdList);
        return this.list((Wrapper)wrapper);
    }

    @Override
    public PageVO<DatasetEntity> getPage(DatasetSearchDTO searchDTO) {
        if (!this.datasetPermissionClient.hasPermissionService()) {
            return IBaseDataSetService.super.getPage(searchDTO);
        }
        LambdaQueryWrapper<DatasetEntity> queryWrapper = this.getQueryWrapper(searchDTO);
        queryWrapper.select((Object[])new SFunction[]{SuperEntity::getId});
        List datasetList = this.list((Wrapper)queryWrapper);
        List<String> datasetIdList = datasetList.stream().map(SuperEntity::getId).collect(Collectors.toList());
        int current = searchDTO.getCurrent();
        int size = searchDTO.getSize();
        int start = (current - 1) * size;
        int end = current * size;
        if (start > datasetIdList.size()) {
            return new PageVO();
        }
        List<String> filterIds = this.datasetPermissionClient.filterByPermission(datasetIdList, searchDTO.getDatasetType());
        if (filterIds == null || filterIds.isEmpty()) {
            return new PageVO();
        }
        if (start > filterIds.size()) {
            return new PageVO();
        }
        if (end > filterIds.size()) {
            end = filterIds.size();
        }
        List<String> pageIds = filterIds.subList(start, end);
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.in(SuperEntity::getId, pageIds);
        wrapper.orderByDesc(SuperEntity::getUpdateDate);
        List list = this.list((Wrapper)wrapper);
        PageVO pageVO = new PageVO();
        pageVO.setCurrent((long)current);
        pageVO.setSize((long)size);
        pageVO.setTotalCount((long)filterIds.size());
        pageVO.setList(list);
        int totalPage = filterIds.size() / size;
        if (filterIds.size() % size != 0) {
            ++totalPage;
        }
        pageVO.setTotalPage((long)totalPage);
        return pageVO;
    }

    @Override
    public String add(DatasetEntity entity) {
        String id = IBaseDataSetService.super.add(entity);
        if (this.datasetPermissionClient.hasPermissionService()) {
            this.datasetPermissionClient.addPermission(id);
        }
        return id;
    }

    @Override
    public void delete(String id) {
        IBaseDataSetService.super.delete(id);
        if (this.datasetPermissionClient.hasPermissionService()) {
            this.datasetPermissionClient.deletePermission(id);
        }
    }

    @Override
    public DeleteCheckVO deleteCheck(String id) {
        Map<String, String> reasons = this.extendClient.deleteCheck(id);
        if (reasons == null || reasons.isEmpty()) {
            return new DeleteCheckVO();
        }
        DeleteCheckVO vo = new DeleteCheckVO();
        vo.setReasons(reasons);
        vo.setCanDelete(reasons.size() == 0);
        return vo;
    }

    @Override
    public Object execute(String id, List<DatasetParamDTO> params) {
        log.error("\u8bf7\u901a\u8fc7DataSetServiceFactory\u83b7\u53d6\u5bf9\u5e94\u7684\u6570\u636e\u96c6\u670d\u52a1\u5b9e\u73b0\u7c7b\u6765\u8c03\u7528\u8be5\u65b9\u6cd5");
        return null;
    }

    @Override
    public DataVO execute(TestExecuteDTO executeDTO) {
        log.error("\u8bf7\u901a\u8fc7DataSetServiceFactory\u83b7\u53d6\u5bf9\u5e94\u7684\u6570\u636e\u96c6\u670d\u52a1\u5b9e\u73b0\u7c7b\u6765\u8c03\u7528\u8be5\u65b9\u6cd5");
        return null;
    }

    @Override
    public LambdaQueryWrapper<DatasetEntity> getQueryWrapper(DatasetSearchDTO searchDTO) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.like(StringUtils.isNotBlank((CharSequence)searchDTO.getName()), DatasetEntity::getName, (Object)searchDTO.getName());
        if (StringUtils.isNotBlank((CharSequence)searchDTO.getTypeId())) {
            List<String> allChildrenId = this.categoryService.getAllChildrenId(searchDTO.getTypeId());
            allChildrenId.add(searchDTO.getTypeId());
            queryWrapper.in(DatasetEntity::getTypeId, allChildrenId);
        }
        queryWrapper.in(CollectionUtils.isNotEmpty(searchDTO.getDatasetType()), DatasetEntity::getDatasetType, searchDTO.getDatasetType());
        if (searchDTO.getDatasetIds() != null && searchDTO.getDatasetIds().size() > 0) {
            queryWrapper.in(SuperEntity::getId, searchDTO.getDatasetIds());
        }
        queryWrapper.eq(StringUtils.isNotBlank((CharSequence)searchDTO.getModuleCode()), DatasetEntity::getModuleCode, (Object)searchDTO.getModuleCode());
        queryWrapper.eq(StringUtils.isNotBlank((CharSequence)searchDTO.getSourceId()), DatasetEntity::getSourceId, (Object)searchDTO.getSourceId());
        queryWrapper.orderByDesc(SuperEntity::getUpdateDate);
        return queryWrapper;
    }
}

