/*
 * Decompiled with CFR 0.152.
 */
package com.gccloud.dataset.service;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.gccloud.common.entity.SuperEntity;
import com.gccloud.common.exception.GlobalException;
import com.gccloud.common.service.ISuperService;
import com.gccloud.common.vo.PageVO;
import com.gccloud.dataset.dto.DatasourceDTO;
import com.gccloud.dataset.dto.DatasourceSearchDTO;
import com.gccloud.dataset.entity.DatasourceEntity;
import com.gccloud.dataset.utils.DBUtils;
import com.gccloud.dataset.utils.DESUtils;
import com.gccloud.dataset.vo.DataVO;
import com.gccloud.dataset.vo.DeleteCheckVO;
import com.gccloud.dataset.vo.FieldInfoVO;
import com.gccloud.dataset.vo.TableInfoVO;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public interface IBaseDatasourceService
extends ISuperService<DatasourceEntity> {
    default public PageVO<DatasourceEntity> getPage(DatasourceSearchDTO searchDTO) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.like(StringUtils.isNotBlank((CharSequence)searchDTO.getSourceName()), DatasourceEntity::getSourceName, (Object)searchDTO.getSourceName());
        queryWrapper.eq(StringUtils.isNotBlank((CharSequence)searchDTO.getSourceType()), DatasourceEntity::getSourceType, (Object)searchDTO.getSourceType());
        queryWrapper.eq(StringUtils.isNotBlank((CharSequence)searchDTO.getModuleCode()), DatasourceEntity::getModuleCode, (Object)searchDTO.getModuleCode());
        queryWrapper.orderByDesc(SuperEntity::getCreateDate);
        PageVO page = this.page(searchDTO, queryWrapper);
        page.getList().forEach(datasourceConfig -> datasourceConfig.setPassword(null));
        return page;
    }

    default public List<DatasourceEntity> getList(DatasourceSearchDTO searchDTO) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.like(StringUtils.isNotBlank((CharSequence)searchDTO.getSourceName()), DatasourceEntity::getSourceName, (Object)searchDTO.getSourceName());
        queryWrapper.eq(StringUtils.isNotBlank((CharSequence)searchDTO.getSourceType()), DatasourceEntity::getSourceType, (Object)searchDTO.getSourceType());
        queryWrapper.eq(StringUtils.isNotBlank((CharSequence)searchDTO.getModuleCode()), DatasourceEntity::getModuleCode, (Object)searchDTO.getModuleCode());
        queryWrapper.orderByDesc(SuperEntity::getCreateDate);
        List list = this.list((Wrapper)queryWrapper);
        list.forEach(datasourceConfig -> datasourceConfig.setPassword(null));
        return list;
    }

    default public String add(DatasourceDTO entity) {
        entity.setPassword(DESUtils.getEncryptString(entity.getPassword()));
        this.save((Object)entity);
        return entity.getId();
    }

    default public void update(DatasourceDTO entity) {
        if (StringUtils.isBlank((CharSequence)entity.getPassword())) {
            entity.setPassword(null);
            this.updateById((Object)entity);
            return;
        }
        entity.setPassword(DESUtils.getEncryptString(entity.getPassword()));
        this.updateById((Object)entity);
    }

    default public void delete(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return;
        }
        this.removeById((Serializable)((Object)id));
    }

    default public DeleteCheckVO deleteCheck(String id) {
        return new DeleteCheckVO();
    }

    default public DatasourceEntity getInfoById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            throw new GlobalException("id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        DatasourceEntity entity = (DatasourceEntity)((Object)this.getById((Serializable)((Object)id)));
        if (entity == null) {
            throw new GlobalException("\u6570\u636e\u6e90\u4e0d\u5b58\u5728");
        }
        return entity;
    }

    default public boolean checkNameRepeat(String id, String name, String moduleCode) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.select((Object[])new SFunction[]{SuperEntity::getId});
        queryWrapper.eq(DatasourceEntity::getSourceName, (Object)name);
        queryWrapper.eq(StringUtils.isNotBlank((CharSequence)moduleCode), DatasourceEntity::getModuleCode, (Object)moduleCode);
        queryWrapper.ne(StringUtils.isNotBlank((CharSequence)id), SuperEntity::getId, (Object)id);
        return this.list((Wrapper)queryWrapper).size() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public String sourceLinkTest(DatasourceEntity datasource) {
        Connection connection = null;
        try {
            if (StringUtils.isEmpty((CharSequence)datasource.getId())) {
                datasource.setPassword(DESUtils.getEncryptString(datasource.getPassword()));
            } else {
                DatasourceEntity entity = this.getInfoById(datasource.getId());
                if (StringUtils.isBlank((CharSequence)datasource.getPassword())) {
                    datasource.setPassword(entity.getPassword());
                }
                if (!entity.getPassword().equals(datasource.getPassword())) {
                    datasource.setPassword(DESUtils.getEncryptString(datasource.getPassword()));
                }
            }
            connection = DBUtils.getConnection(datasource);
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return "\u8fde\u63a5\u6210\u529f";
    }

    public DataVO executeSql(DatasourceEntity var1, String var2);

    default public DataVO executeSqlPage(DatasourceEntity datasource, String sql, Integer current, Integer size) {
        return this.executeSql(datasource, sql);
    }

    default public DataVO executeProcedure(DatasourceEntity datasource, String procedure, Integer current, Integer size) {
        return null;
    }

    default public List<TableInfoVO> getTableList(DatasourceEntity datasource) {
        return null;
    }

    default public List<FieldInfoVO> getTableColumnList(DatasourceEntity datasource, String tableName) {
        return null;
    }

    default public List<TableInfoVO> getViewList(DatasourceEntity datasource) {
        return null;
    }

    default public List<FieldInfoVO> getViewColumnList(DatasourceEntity datasource, String viewName) {
        return null;
    }
}

