/*
 * Decompiled with CFR 0.152.
 */
package com.gccloud.dataroom.core.utils;

import com.gccloud.dataroom.core.config.bean.DataRoomSftpConfig;
import com.gccloud.dataroom.core.module.file.service.pool.sftp.SftpPoolService;
import com.gccloud.dataroom.core.utils.PathUtils;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.SftpException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.annotation.Resource;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(prefix="gc.starter.file", name={"type"}, havingValue="sftp")
public class SftpClientUtils {
    private static final Logger log = LoggerFactory.getLogger(SftpClientUtils.class);
    @Resource
    private DataRoomSftpConfig config;
    @Resource
    private SftpPoolService sFtpPoolService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean upload(String uploadPath, String fileName, InputStream inputStream) {
        ChannelSftp sftp = this.sFtpPoolService.borrowObject();
        String[] paths = PathUtils.handlePath(uploadPath, fileName);
        if (!this.exist(uploadPath = paths[0])) {
            try {
                sftp.mkdir(uploadPath);
            }
            catch (SftpException e) {
                log.error(ExceptionUtils.getStackTrace((Throwable)e));
                return false;
            }
        }
        fileName = "/" + paths[1];
        String filePath = uploadPath.concat(fileName);
        try {
            sftp.put(inputStream, filePath);
            String permission = "755";
            sftp.chmod(Integer.parseInt(permission, 8), filePath);
            log.info("\u6587\u4ef6\u4e0a\u4f20\u6210\u529f:{}", (Object)filePath);
            boolean bl = true;
            return bl;
        }
        catch (SftpException e) {
            log.error("\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25:{}", (Object)filePath);
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
        finally {
            if (null != inputStream) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    log.error(ExceptionUtils.getStackTrace((Throwable)e));
                }
            }
            this.sFtpPoolService.returnObject(sftp);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean download(String sftpPath, String fileName, OutputStream outputStream) {
        ChannelSftp sftp = this.sFtpPoolService.borrowObject();
        String[] paths = PathUtils.handlePath(sftpPath, fileName);
        sftpPath = paths[0];
        fileName = "/" + paths[1];
        String filePath = sftpPath.concat(fileName);
        try {
            boolean bl;
            Throwable throwable;
            InputStream inputStream;
            block25: {
                block26: {
                    int len;
                    inputStream = sftp.get(filePath);
                    throwable = null;
                    byte[] bytes = new byte[this.config.getBufferSize()];
                    while ((len = inputStream.read(bytes)) != -1) {
                        outputStream.write(bytes, 0, len);
                    }
                    log.info("\u6587\u4ef6\u4e0b\u8f7d\u6210\u529f:{}", (Object)filePath);
                    bl = true;
                    if (inputStream == null) break block25;
                    if (throwable == null) break block26;
                    try {
                        inputStream.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    break block25;
                }
                inputStream.close();
            }
            return bl;
            catch (Throwable throwable3) {
                try {
                    try {
                        throwable = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        if (inputStream != null) {
                            if (throwable != null) {
                                try {
                                    inputStream.close();
                                }
                                catch (Throwable throwable5) {
                                    throwable.addSuppressed(throwable5);
                                }
                            } else {
                                inputStream.close();
                            }
                        }
                        throw throwable4;
                    }
                }
                catch (Exception e) {
                    log.info("\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25:{}", (Object)filePath);
                    log.error(ExceptionUtils.getStackTrace((Throwable)e));
                }
            }
        }
        finally {
            if (null != outputStream) {
                try {
                    outputStream.close();
                }
                catch (IOException e) {
                    log.error(ExceptionUtils.getStackTrace((Throwable)e));
                }
            }
            this.sFtpPoolService.returnObject(sftp);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean delete(String sftpPath, String fileName) {
        ChannelSftp sftp = this.sFtpPoolService.borrowObject();
        String[] paths = PathUtils.handlePath(sftpPath, fileName);
        String filePath = (sftpPath = paths[0]).concat(fileName = "/" + paths[1]);
        if (!this.exist(filePath)) {
            log.info("\u6587\u4ef6\u4e0d\u5b58\u5728:{}", (Object)filePath);
            return true;
        }
        if (this.isDirectory(filePath)) {
            log.info("\u8be5\u8def\u5f84\u4e3a\u6587\u4ef6\u5939:{}\uff0c\u65e0\u6cd5\u5220\u9664", (Object)filePath);
            return false;
        }
        try {
            sftp.rm(filePath);
            log.info("\u6587\u4ef6\u5220\u9664\u6210\u529f:{}", (Object)filePath);
            boolean bl = true;
            return bl;
        }
        catch (SftpException e) {
            log.info("\u6587\u4ef6\u5220\u9664\u5931\u8d25:{}", (Object)filePath);
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
        finally {
            this.sFtpPoolService.returnObject(sftp);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean copy(String sourcePath, String targetPath) {
        ChannelSftp sftp1 = this.sFtpPoolService.borrowObject();
        ChannelSftp sftp2 = this.sFtpPoolService.borrowObject();
        sourcePath = PathUtils.normalizePath(sourcePath);
        targetPath = PathUtils.normalizePath(targetPath);
        if (!this.exist(sourcePath)) {
            log.error("\u590d\u5236\u6e90\u6587\u4ef6\u4e0d\u5b58\u5728:{}", (Object)sourcePath);
            return false;
        }
        if (this.isDirectory(sourcePath)) {
            log.error("\u6e90\u6587\u4ef6\u4e3a\u6587\u4ef6\u5939:{}\uff0c\u65e0\u6cd5\u590d\u5236", (Object)sourcePath);
            return false;
        }
        InputStream inputStream = null;
        try {
            inputStream = sftp1.get(sourcePath);
            sftp2.put(inputStream, targetPath);
            log.info("\u6587\u4ef6\u590d\u5236\u6210\u529f:{}", (Object)sourcePath);
            boolean bl = true;
            return bl;
        }
        catch (SftpException e) {
            log.error("\u6587\u4ef6\u590d\u5236\u5931\u8d25:{}", (Object)sourcePath);
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
        finally {
            if (null != inputStream) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    log.error(ExceptionUtils.getStackTrace((Throwable)e));
                }
            }
            this.sFtpPoolService.returnObject(sftp1);
            this.sFtpPoolService.returnObject(sftp2);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDirectory(String path) {
        ChannelSftp sftp = this.sFtpPoolService.borrowObject();
        try {
            sftp.cd(path);
            boolean bl = true;
            return bl;
        }
        catch (SftpException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            this.sFtpPoolService.returnObject(sftp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean exist(String filePath) {
        ChannelSftp sftp = this.sFtpPoolService.borrowObject();
        try {
            sftp.lstat(filePath);
            boolean bl = true;
            return bl;
        }
        catch (SftpException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            this.sFtpPoolService.returnObject(sftp);
        }
    }
}

