/*
 * Decompiled with CFR 0.152.
 */
package com.gccloud.dataroom.core.module.type.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.gccloud.common.entity.SuperEntity;
import com.gccloud.common.exception.GlobalException;
import com.gccloud.common.utils.BeanConvertUtils;
import com.gccloud.dataroom.core.module.type.dao.DataRoomTypeDao;
import com.gccloud.dataroom.core.module.type.dto.TypeDTO;
import com.gccloud.dataroom.core.module.type.entity.TypeEntity;
import com.gccloud.dataroom.core.module.type.service.ITypeService;
import com.gccloud.dataroom.core.utils.CodeGenerateUtils;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="dataRoomTypeService")
public class TypeServiceImpl
extends ServiceImpl<DataRoomTypeDao, TypeEntity>
implements ITypeService {
    private static final Logger log = LoggerFactory.getLogger(TypeServiceImpl.class);

    @Override
    public String add(TypeDTO typeDTO) {
        TypeEntity entity = (TypeEntity)BeanConvertUtils.convert((Object)typeDTO, TypeEntity.class);
        if (StringUtils.isBlank((CharSequence)entity.getCode())) {
            String code = CodeGenerateUtils.generate(typeDTO.getType());
            while (this.checkCodeRepeat(null, typeDTO.getType(), code)) {
                code = CodeGenerateUtils.generate(typeDTO.getType());
            }
            entity.setCode(code);
        } else {
            while (this.checkCodeRepeat(null, typeDTO.getType(), entity.getCode())) {
                entity.setCode(CodeGenerateUtils.generate(typeDTO.getType()));
            }
        }
        if (this.checkNameRepeat(null, typeDTO.getType(), entity.getName())) {
            throw new GlobalException("\u5206\u7ec4\u540d\u79f0\u5df2\u5b58\u5728");
        }
        this.save(entity);
        return entity.getId();
    }

    @Override
    public void update(TypeDTO typeDTO) {
        TypeEntity entity = (TypeEntity)BeanConvertUtils.convert((Object)typeDTO, TypeEntity.class);
        if (this.checkNameRepeat(typeDTO.getId(), typeDTO.getType(), entity.getName())) {
            throw new GlobalException("\u5206\u7ec4\u540d\u79f0\u5df2\u5b58\u5728");
        }
        this.updateById(entity);
    }

    @Override
    public void deleteById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return;
        }
        this.removeById((Serializable)((Object)id));
    }

    @Override
    public List<TypeEntity> listByType(String type) {
        if (StringUtils.isBlank((CharSequence)type)) {
            return Lists.newArrayList();
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(TypeEntity::getType, (Object)type);
        queryWrapper.orderByAsc(TypeEntity::getOrderNum);
        queryWrapper.orderByDesc(SuperEntity::getCreateDate);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public boolean checkCodeRepeat(String id, String type, String code) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.select((Object[])new SFunction[]{SuperEntity::getId});
        queryWrapper.eq(TypeEntity::getType, (Object)type);
        queryWrapper.eq(TypeEntity::getCode, (Object)code);
        queryWrapper.ne(StringUtils.isNotBlank((CharSequence)id), SuperEntity::getId, (Object)id);
        return this.list((Wrapper)queryWrapper).size() > 0;
    }

    @Override
    public boolean checkNameRepeat(String id, String type, String name) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.select((Object[])new SFunction[]{SuperEntity::getId});
        queryWrapper.eq(TypeEntity::getName, (Object)name);
        queryWrapper.eq(TypeEntity::getType, (Object)type);
        queryWrapper.ne(StringUtils.isNotBlank((CharSequence)id), SuperEntity::getId, (Object)id);
        return this.list((Wrapper)queryWrapper).size() > 0;
    }
}

