/*
 * Decompiled with CFR 0.152.
 */
package com.gccloud.dataroom.core.module.manage.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.gccloud.common.entity.SuperEntity;
import com.gccloud.common.exception.GlobalException;
import com.gccloud.common.utils.AssertUtils;
import com.gccloud.common.utils.BeanConvertUtils;
import com.gccloud.common.vo.PageVO;
import com.gccloud.dataroom.core.config.DataRoomConfig;
import com.gccloud.dataroom.core.module.basic.dao.DataRoomPageDao;
import com.gccloud.dataroom.core.module.basic.entity.PageEntity;
import com.gccloud.dataroom.core.module.basic.entity.PagePreviewEntity;
import com.gccloud.dataroom.core.module.chart.bean.Chart;
import com.gccloud.dataroom.core.module.chart.bean.Linkage;
import com.gccloud.dataroom.core.module.chart.components.datasource.DataSetDataSource;
import com.gccloud.dataroom.core.module.file.entity.DataRoomFileEntity;
import com.gccloud.dataroom.core.module.file.service.IDataRoomOssService;
import com.gccloud.dataroom.core.module.manage.dto.DataRoomPageDTO;
import com.gccloud.dataroom.core.module.manage.dto.DataRoomSearchDTO;
import com.gccloud.dataroom.core.module.manage.extend.DataRoomExtendClient;
import com.gccloud.dataroom.core.module.manage.service.IDataRoomPagePreviewService;
import com.gccloud.dataroom.core.module.manage.service.IDataRoomPageService;
import com.gccloud.dataroom.core.module.template.entity.PageTemplateEntity;
import com.gccloud.dataroom.core.module.template.service.IPageTemplateService;
import com.gccloud.dataroom.core.permission.DataRoomPermissionClient;
import com.gccloud.dataroom.core.utils.CodeGenerateUtils;
import com.gccloud.dataroom.core.utils.PathUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DataRoomPageServiceImpl
extends ServiceImpl<DataRoomPageDao, PageEntity>
implements IDataRoomPageService {
    private static final Logger log = LoggerFactory.getLogger(DataRoomPageServiceImpl.class);
    @Resource
    private IPageTemplateService pageTemplateService;
    @Resource
    private DataRoomConfig bigScreenConfig;
    @Resource
    private DataRoomExtendClient dataRoomExtendClient;
    @Resource
    private DataRoomPermissionClient permissionClient;
    @Resource
    private IDataRoomPagePreviewService previewService;
    @Resource
    private IDataRoomOssService ossService;
    public static final String COPY_SUFFIX = "-\u526f\u672c";

    @Override
    public PageEntity getByCode(String code) {
        if (code.startsWith("preview")) {
            PagePreviewEntity preview = this.previewService.getByCode(code);
            return (PageEntity)BeanConvertUtils.convert((Object)preview, PageEntity.class);
        }
        return IDataRoomPageService.super.getByCode(code);
    }

    @Override
    public String add(DataRoomPageDTO bigScreenPageDTO) {
        ArrayList chartList;
        if (StringUtils.isBlank((CharSequence)bigScreenPageDTO.getCode())) {
            String code = CodeGenerateUtils.generate(bigScreenPageDTO.getType());
            bigScreenPageDTO.setCode(code);
        }
        if (CollectionUtils.isEmpty(chartList = bigScreenPageDTO.getChartList())) {
            chartList = Lists.newArrayList();
        }
        for (Chart chart : chartList) {
            if (StringUtils.isNotBlank((CharSequence)chart.getCode())) continue;
            chart.setCode(CodeGenerateUtils.generate(chart.getType() == null ? "chart" : chart.getType()));
        }
        if (StringUtils.isNotBlank((CharSequence)bigScreenPageDTO.getCoverPicture())) {
            String base64Str = bigScreenPageDTO.getCoverPicture();
            String fileUrl = this.saveCoverPicture(base64Str, bigScreenPageDTO.getCode());
            bigScreenPageDTO.setCoverPicture(fileUrl);
        }
        PageEntity bigScreenEntity = (PageEntity)BeanConvertUtils.convert((Object)bigScreenPageDTO, PageEntity.class);
        bigScreenEntity.setConfig(bigScreenPageDTO);
        AssertUtils.isTrue((!this.checkNameRepeat(bigScreenEntity) ? 1 : 0) != 0, (String)"\u540d\u79f0\u91cd\u590d");
        AssertUtils.isTrue((!this.checkCodeRepeat(bigScreenEntity) ? 1 : 0) != 0, (String)"\u7f16\u7801\u91cd\u590d");
        this.save(bigScreenEntity);
        this.dataRoomExtendClient.afterAdd(bigScreenEntity.getCode());
        return bigScreenEntity.getCode();
    }

    private String saveCoverPicture(String base64String, String fileName) {
        String fileUrl = "";
        if (StringUtils.isBlank((CharSequence)base64String)) {
            return fileUrl;
        }
        try {
            base64String = base64String.substring(base64String.indexOf(",") + 1);
            byte[] imageBytes = Base64.getDecoder().decode(base64String);
            ByteArrayInputStream inputStream = new ByteArrayInputStream(imageBytes);
            DataRoomFileEntity fileEntity = new DataRoomFileEntity();
            String filePath = "cover" + File.separator + fileName + ".png";
            this.ossService.upload(inputStream, filePath, 0L, fileEntity);
            log.info("\u5927\u5c4f\u5c01\u9762\u4fdd\u5b58\u81f3\uff1a{}", (Object)filePath);
            fileUrl = fileEntity.getUrl();
        }
        catch (Exception e) {
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
        return fileUrl;
    }

    private String copyCoverPicture(String oldFileName, String newFileName) {
        if (StringUtils.isBlank((CharSequence)oldFileName)) {
            return "";
        }
        String oldFile = "cover" + File.separator + oldFileName + ".png";
        String newFilePath = "cover" + File.separator + newFileName + ".png";
        return this.ossService.copy(oldFile, newFilePath);
    }

    @Override
    public String addByTemplate(DataRoomPageDTO bigScreenPageDTO) {
        if (StringUtils.isBlank((CharSequence)bigScreenPageDTO.getPageTemplateId())) {
            throw new GlobalException("\u9875\u9762\u6a21\u677f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        bigScreenPageDTO = this.getConfigByTemplate(bigScreenPageDTO);
        return this.add(bigScreenPageDTO);
    }

    @Override
    public DataRoomPageDTO getConfigByTemplate(DataRoomPageDTO bigScreenPageDTO) {
        String pageTemplateId = bigScreenPageDTO.getPageTemplateId();
        PageTemplateEntity pageTemplate = (PageTemplateEntity)((Object)this.pageTemplateService.getById((Serializable)((Object)pageTemplateId)));
        AssertUtils.isTrue((pageTemplate != null ? 1 : 0) != 0, (String)"\u9875\u9762\u6a21\u677f\u4e0d\u5b58\u5728");
        AssertUtils.isTrue((boolean)Objects.equals(pageTemplate.getType(), "bigScreen"), (String)"\u9875\u9762\u6a21\u677f\u7c7b\u578b\u4e0d\u6b63\u786e");
        DataRoomPageDTO config = (DataRoomPageDTO)pageTemplate.getConfig();
        String name = bigScreenPageDTO.getName();
        if (StringUtils.isBlank((CharSequence)name)) {
            int i = 0;
            String newName = pageTemplate.getName() + "\u526f\u672c";
            while (this.checkNameRepeat(bigScreenPageDTO.getAppCode(), newName, null, "bigScreen")) {
                newName = pageTemplate.getName() + "\u526f\u672c" + ++i;
            }
            name = newName;
        }
        config.setName(name);
        config.setCode(bigScreenPageDTO.getCode());
        config.setParentCode(bigScreenPageDTO.getParentCode());
        config.setId(bigScreenPageDTO.getId());
        config.setAppCode(bigScreenPageDTO.getAppCode());
        ArrayList chartList = config.getChartList();
        if (CollectionUtils.isEmpty(chartList)) {
            chartList = Lists.newArrayList();
        }
        for (Chart chart : chartList) {
            chart.setCode("");
            chart.setDataSource(new DataSetDataSource());
        }
        return config;
    }

    @Override
    public PageVO<PageEntity> getByCategory(DataRoomSearchDTO searchDTO) {
        if (StringUtils.isBlank((CharSequence)searchDTO.getType())) {
            throw new GlobalException("\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.like(StringUtils.isNotBlank((CharSequence)searchDTO.getSearchKey()), PageEntity::getName, (Object)searchDTO.getSearchKey());
        if (StringUtils.isNotBlank((CharSequence)searchDTO.getParentCode())) {
            queryWrapper.eq(PageEntity::getParentCode, (Object)searchDTO.getParentCode());
        }
        queryWrapper.eq(PageEntity::getType, (Object)searchDTO.getType());
        queryWrapper.select((Object[])new SFunction[]{PageEntity::getCode});
        List idEntityList = this.list((Wrapper)queryWrapper);
        if (idEntityList == null || idEntityList.isEmpty()) {
            PageVO pageVO = new PageVO();
            pageVO.setList((List)Lists.newArrayList());
            return pageVO;
        }
        List<String> codeList = idEntityList.stream().map(PageEntity::getCode).collect(Collectors.toList());
        List<String> filterByPermission = this.permissionClient.filterByPermission(codeList);
        if (filterByPermission == null || filterByPermission.isEmpty()) {
            PageVO pageVO = new PageVO();
            pageVO.setList((List)Lists.newArrayList());
            return pageVO;
        }
        LambdaQueryWrapper reQueryWrapper = new LambdaQueryWrapper();
        if (idEntityList.size() == filterByPermission.size()) {
            reQueryWrapper = queryWrapper;
        } else {
            reQueryWrapper.in(PageEntity::getCode, filterByPermission);
        }
        reQueryWrapper.select((Object[])new SFunction[]{SuperEntity::getId, PageEntity::getAppCode, PageEntity::getCode, PageEntity::getName, PageEntity::getParentCode, PageEntity::getOrderNum, PageEntity::getCoverPicture, SuperEntity::getUpdateDate});
        reQueryWrapper.orderByAsc(PageEntity::getOrderNum);
        reQueryWrapper.orderByDesc(SuperEntity::getCreateDate);
        PageVO page = this.page(searchDTO, reQueryWrapper);
        List list = page.getList();
        if (list == null || list.isEmpty()) {
            return page;
        }
        String urlPrefix = this.bigScreenConfig.getFile().getUrlPrefix();
        if (!urlPrefix.endsWith("/")) {
            urlPrefix = urlPrefix + "/";
        }
        for (PageEntity pageEntity : list) {
            String coverPicture = pageEntity.getCoverPicture();
            if (StringUtils.isBlank((CharSequence)coverPicture)) continue;
            if (coverPicture.startsWith("/")) {
                coverPicture = coverPicture.substring(1);
            }
            pageEntity.setCoverPicture(urlPrefix + PathUtils.normalizePath(coverPicture));
        }
        return page;
    }

    @Override
    public void update(DataRoomPageDTO bigScreenPageDTO) {
        AssertUtils.isTrue((boolean)StringUtils.isNotBlank((CharSequence)bigScreenPageDTO.getCode()), (String)"\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isTrue((boolean)StringUtils.isNotBlank((CharSequence)bigScreenPageDTO.getName()), (String)"\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        List<Chart> chartList = bigScreenPageDTO.getChartList();
        if (CollectionUtils.isNotEmpty(chartList)) {
            for (Chart chart : chartList) {
                if (StringUtils.isNotBlank((CharSequence)chart.getCode())) continue;
                chart.setCode(CodeGenerateUtils.generate(chart.getType() == null ? "chart" : chart.getType()));
            }
        }
        if (StringUtils.isNotBlank((CharSequence)bigScreenPageDTO.getCoverPicture())) {
            String coverPicture = this.saveCoverPicture(bigScreenPageDTO.getCoverPicture(), bigScreenPageDTO.getCode());
            bigScreenPageDTO.setCoverPicture(coverPicture);
        }
        PageEntity bigScreenEntity = (PageEntity)BeanConvertUtils.convert((Object)bigScreenPageDTO, PageEntity.class);
        bigScreenEntity.setConfig(bigScreenPageDTO);
        AssertUtils.isTrue((!this.checkNameRepeat(bigScreenEntity) ? 1 : 0) != 0, (String)"\u540d\u79f0\u91cd\u590d");
        AssertUtils.isTrue((!this.checkCodeRepeat(bigScreenEntity) ? 1 : 0) != 0, (String)"\u7f16\u7801\u91cd\u590d");
        this.updateById(bigScreenEntity);
        PAGE_ENTITY_CACHE.invalidate((Object)bigScreenEntity.getCode());
    }

    @Override
    public String copy(PageEntity screenEntity) {
        DataRoomPageDTO config = (DataRoomPageDTO)screenEntity.getConfig();
        screenEntity.setId(null);
        String oldCode = screenEntity.getCode();
        screenEntity.setCode(CodeGenerateUtils.generate(screenEntity.getType()));
        int i = 1;
        String oldName = screenEntity.getName();
        if (oldName.contains(COPY_SUFFIX) && StringUtils.isBlank((CharSequence)(oldName = oldName.substring(0, oldName.indexOf(COPY_SUFFIX))))) {
            oldName = "\u5927\u5c4f";
        }
        screenEntity.setName(oldName + COPY_SUFFIX);
        while (this.checkNameRepeat(screenEntity)) {
            screenEntity.setName(oldName + COPY_SUFFIX + i);
            ++i;
        }
        config.setName(screenEntity.getName());
        config.setCode(screenEntity.getCode());
        List<Chart> chartList = config.getChartList();
        HashMap chartCodeMap = Maps.newHashMap();
        for (Chart chart : chartList) {
            String oldChartCode = chart.getCode();
            chart.setCode(CodeGenerateUtils.generate(chart.getType() == null ? "chart" : chart.getType()));
            chartCodeMap.put(oldChartCode, chart.getCode());
        }
        for (Chart chart : chartList) {
            List<Linkage.Component> components;
            Linkage linkage = chart.getLinkage();
            if (linkage == null || (components = linkage.getComponents()) == null || components.isEmpty()) continue;
            for (Linkage.Component component : components) {
                String componentKey = component.getComponentKey();
                if (StringUtils.isBlank((CharSequence)componentKey)) continue;
                String newCode = (String)chartCodeMap.get(componentKey);
                component.setComponentKey(newCode);
            }
        }
        String copyUrl = this.copyCoverPicture(oldCode, screenEntity.getCode());
        if (StringUtils.isBlank((CharSequence)copyUrl)) {
            screenEntity.setCoverPicture(null);
        } else {
            screenEntity.setCoverPicture(copyUrl);
        }
        this.save(screenEntity);
        this.dataRoomExtendClient.afterAdd(screenEntity.getCode());
        return screenEntity.getCode();
    }

    @Override
    public void deleteByCode(String code) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(PageEntity::getCode, (Object)code);
        this.remove((Wrapper)queryWrapper);
        PAGE_ENTITY_CACHE.invalidate((Object)code);
        this.dataRoomExtendClient.deleteByCode(code);
        this.dataRoomExtendClient.afterDelete(code);
    }
}

