/*
 * Decompiled with CFR 0.152.
 */
package com.gccloud.dataroom.core.module.file.vo;

import com.gccloud.dataroom.core.module.file.entity.DataRoomFileEntity;
import java.io.Serializable;
import java.text.DecimalFormat;

public class DataRoomFileVO
extends DataRoomFileEntity
implements Serializable {
    private String space;

    public String getSpace() {
        long size = this.getSize();
        if (size <= 0L) {
            return "0";
        }
        String[] units = new String[]{"B", "KB", "MB", "GB", "TB"};
        int digitGroups = (int)(Math.log10(size) / Math.log10(1000.0));
        return new DecimalFormat("#,##0.##").format((double)size / Math.pow(1000.0, digitGroups)) + " " + units[digitGroups];
    }

    public void setSpace(String space) {
        this.space = space;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DataRoomFileVO)) {
            return false;
        }
        DataRoomFileVO other = (DataRoomFileVO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$space = this.getSpace();
        String other$space = other.getSpace();
        return !(this$space == null ? other$space != null : !this$space.equals(other$space));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof DataRoomFileVO;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $space = this.getSpace();
        result = result * 59 + ($space == null ? 43 : $space.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "DataRoomFileVO(space=" + this.getSpace() + ")";
    }
}

