/*
 * Decompiled with CFR 0.152.
 */
package com.gccloud.dataroom.core.module.file.service.impl;

import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.gccloud.common.exception.GlobalException;
import com.gccloud.dataroom.core.config.DataRoomConfig;
import com.gccloud.dataroom.core.config.bean.FileConfig;
import com.gccloud.dataroom.core.module.file.entity.DataRoomFileEntity;
import com.gccloud.dataroom.core.module.file.service.IDataRoomFileService;
import com.gccloud.dataroom.core.module.file.service.IDataRoomOssService;
import com.gccloud.dataroom.core.utils.FtpClientUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
@ConditionalOnProperty(prefix="gc.starter.file", name={"type"}, havingValue="ftp")
public class DataRoomFtpFileServiceImpl
implements IDataRoomOssService {
    private static final Logger log = LoggerFactory.getLogger(DataRoomFtpFileServiceImpl.class);
    @Resource
    private FtpClientUtil ftpUtil;
    @Resource
    private DataRoomConfig bigScreenConfig;
    @Resource
    private IDataRoomFileService sysFileService;

    @Override
    public DataRoomFileEntity upload(MultipartFile file, DataRoomFileEntity fileEntity, HttpServletResponse response, HttpServletRequest request) {
        InputStream inputStream;
        String originalFilename = file.getOriginalFilename();
        String extension = FilenameUtils.getExtension((String)originalFilename);
        FileConfig fileConfig = this.bigScreenConfig.getFile();
        if (!fileConfig.getAllowedFileExtensionName().contains("*") && !fileConfig.getAllowedFileExtensionName().contains(extension)) {
            log.error("\u4e0d\u652f\u6301 {} \u6587\u4ef6\u7c7b\u578b", (Object)extension);
            throw new GlobalException("\u4e0d\u652f\u6301\u7684\u6587\u4ef6\u7c7b\u578b");
        }
        String id = IdWorker.getIdStr();
        String newFileName = id + "." + extension;
        long size = file.getSize();
        try {
            inputStream = file.getInputStream();
        }
        catch (IOException e) {
            log.error("\u4e0a\u4f20\u6587\u4ef6\u5230FTP\u670d\u52a1\u5931\u8d25\uff1a\u83b7\u53d6\u6587\u4ef6\u6d41\u5931\u8d25");
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
            throw new GlobalException("\u83b7\u53d6\u6587\u4ef6\u6d41\u5931\u8d25");
        }
        return this.upload(inputStream, newFileName, size, fileEntity);
    }

    @Override
    public DataRoomFileEntity upload(InputStream inputStream, String fileName, long size, DataRoomFileEntity fileEntity) {
        String extension = FilenameUtils.getExtension((String)fileName);
        String basePath = this.bigScreenConfig.getFile().getBasePath();
        boolean upload = this.ftpUtil.upload(basePath, fileName, inputStream);
        if (!upload) {
            log.error("\u4e0a\u4f20\u6587\u4ef6\u5230ftp\u5931\u8d25");
            throw new GlobalException("\u4e0a\u4f20\u6587\u4ef6\u5230ftp\u5931\u8d25");
        }
        fileEntity.setOriginalName(fileName);
        fileEntity.setNewName(fileName);
        fileEntity.setPath(basePath);
        fileEntity.setSize(size);
        fileEntity.setExtension(extension);
        fileEntity.setUrl("/" + fileName);
        return fileEntity;
    }

    @Override
    public void download(String fileId, HttpServletResponse response, HttpServletRequest request) {
        ServletOutputStream outputStream;
        DataRoomFileEntity fileEntity = (DataRoomFileEntity)this.sysFileService.getById((Serializable)((Object)fileId));
        if (fileEntity == null) {
            response.setStatus(HttpStatus.NOT_FOUND.value());
            log.error("\u4e0b\u8f7d\u7684\u6587\u4ef6\u4e0d\u5b58\u5728");
            return;
        }
        response.setContentType("application/x-msdownload");
        response.setContentType("multipart/form-data");
        response.setHeader("Access-Control-Expose-Headers", "filename");
        try {
            response.setHeader("filename", URLEncoder.encode(fileEntity.getOriginalName(), "UTF-8"));
            response.setHeader("Content-Disposition", "attachment;fileName=" + URLEncoder.encode(fileEntity.getOriginalName(), "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
        try {
            outputStream = response.getOutputStream();
        }
        catch (IOException e) {
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
            response.setStatus(HttpStatus.INTERNAL_SERVER_ERROR.value());
            return;
        }
        boolean download = this.ftpUtil.download(fileEntity.getPath(), fileEntity.getNewName(), (OutputStream)outputStream);
        if (!download) {
            log.error("\u4e0b\u8f7d\u6587\u4ef6\u5931\u8d25");
            response.setStatus(HttpStatus.INTERNAL_SERVER_ERROR.value());
        }
        try {
            outputStream.close();
        }
        catch (IOException e) {
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
        this.sysFileService.updateDownloadCount(1, fileId);
    }

    @Override
    public void delete(String fileId) {
        DataRoomFileEntity fileEntity = (DataRoomFileEntity)this.sysFileService.getById((Serializable)((Object)fileId));
        if (fileEntity == null) {
            log.error("\u5220\u9664\u7684\u6587\u4ef6\u4e0d\u5b58\u5728");
            return;
        }
        this.sysFileService.removeById((Serializable)((Object)fileId));
        this.ftpUtil.delete(fileEntity.getPath(), fileEntity.getNewName());
    }

    @Override
    public String copy(String sourcePath, String targetPath) {
        String basePath = this.bigScreenConfig.getFile().getBasePath() + File.separator;
        boolean copySuccess = this.ftpUtil.copy(basePath + sourcePath, basePath + targetPath);
        if (!copySuccess) {
            return "";
        }
        return targetPath;
    }
}

