/*
 * Decompiled with CFR 0.152.
 */
package com.gccloud.dataroom.core.module.file.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.gccloud.common.entity.SuperEntity;
import com.gccloud.common.exception.GlobalException;
import com.gccloud.common.utils.QueryWrapperUtils;
import com.gccloud.common.vo.PageVO;
import com.gccloud.dataroom.core.module.file.dao.DataRoomFileDao;
import com.gccloud.dataroom.core.module.file.dto.FileSearchDTO;
import com.gccloud.dataroom.core.module.file.entity.DataRoomFileEntity;
import com.gccloud.dataroom.core.module.file.service.IDataRoomFileService;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Service;

@Service
@ConditionalOnProperty(prefix="gc.starter.dataroom.component", name={"IDataRoomFileService"}, havingValue="DataRoomFileServiceImpl", matchIfMissing=true)
public class DataRoomFileServiceImpl
extends ServiceImpl<DataRoomFileDao, DataRoomFileEntity>
implements IDataRoomFileService {
    private static final Logger log = LoggerFactory.getLogger(DataRoomFileServiceImpl.class);

    @Override
    public PageVO<DataRoomFileEntity> getPage(FileSearchDTO searchDTO) {
        LambdaQueryWrapper queryWrapper = QueryWrapperUtils.wrapperLike((LambdaQueryWrapper)new LambdaQueryWrapper(), (String)searchDTO.getSearchKey(), (SFunction[])new SFunction[]{DataRoomFileEntity::getOriginalName});
        queryWrapper.eq(StringUtils.isNotBlank((CharSequence)searchDTO.getModule()), DataRoomFileEntity::getModule, (Object)searchDTO.getModule());
        queryWrapper.eq(StringUtils.isNotBlank((CharSequence)searchDTO.getExtension()), DataRoomFileEntity::getExtension, (Object)searchDTO.getExtension());
        if (searchDTO.getExtensionList() != null && searchDTO.getExtensionList().size() > 0) {
            queryWrapper.in(DataRoomFileEntity::getExtension, searchDTO.getExtensionList());
        }
        queryWrapper.orderByDesc(SuperEntity::getCreateDate);
        return this.page(searchDTO, queryWrapper);
    }

    @Override
    public void updateDownloadCount(Integer addCount, String fileId) {
        if (addCount <= 0) {
            throw new GlobalException("\u4e0b\u8f7d\u6b21\u6570\u4e0d\u5141\u8bb8\u4e3a\u8d1f\u6570\u62160");
        }
        ((DataRoomFileDao)this.baseMapper).updateDownloadCount(addCount, fileId);
    }

    @Override
    public List<String> getAllExtension() {
        return ((DataRoomFileDao)this.baseMapper).getAllExtension();
    }
}

