/*
 * Decompiled with CFR 0.152.
 */
package com.gccloud.dataroom.core.module.chart.service;

import com.gccloud.common.utils.JSON;
import com.gccloud.dataroom.core.module.chart.vo.ChartDataVO;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.stereotype.Service;

@Service(value="dataRoomChartMockDataService")
public class ChartMockData {
    private static final Logger log = LoggerFactory.getLogger(ChartMockData.class);

    public static ChartDataVO getMockData(String type) {
        String fileName = "chart/mock/" + type + ".json";
        if ("screenScrollBoard".equals(type)) {
            fileName = "chart/mock/tables.json";
        }
        if ("screenScrollRanking".equals(type)) {
            fileName = "chart/mock/ranking.json";
        }
        String json = "";
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
        try {
            int n;
            Resource[] resources = resolver.getResources(fileName);
            Resource resource = resources[0];
            if (!resource.exists()) {
                return new ChartDataVO();
            }
            InputStream stream = resource.getInputStream();
            StringBuilder buffer = new StringBuilder();
            byte[] bytes = new byte[1024];
            while ((n = stream.read(bytes)) != -1) {
                buffer.append(new String(bytes, 0, n));
            }
            json = buffer.toString();
        }
        catch (IOException e) {
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
            return new ChartDataVO();
        }
        ChartDataVO chartDataDTO = (ChartDataVO)JSON.parseObject((String)json, ChartDataVO.class);
        return chartDataDTO;
    }
}

