/*
 * Decompiled with CFR 0.152.
 */
package com.gccloud.dataroom.core.module.chart.controller;

import com.gccloud.common.utils.AssertUtils;
import com.gccloud.common.vo.R;
import com.gccloud.dataroom.core.module.basic.dto.BasePageDTO;
import com.gccloud.dataroom.core.module.basic.entity.PageEntity;
import com.gccloud.dataroom.core.module.chart.bean.Chart;
import com.gccloud.dataroom.core.module.chart.components.ChartTabChart;
import com.gccloud.dataroom.core.module.chart.components.ScreenFlyMapChart;
import com.gccloud.dataroom.core.module.chart.dto.ChartDataSearchDTO;
import com.gccloud.dataroom.core.module.chart.service.BaseChartDataService;
import com.gccloud.dataroom.core.module.chart.service.ChartMockData;
import com.gccloud.dataroom.core.module.chart.vo.ChartDataVO;
import com.gccloud.dataroom.core.module.manage.dto.DataRoomPageDTO;
import com.gccloud.dataroom.core.module.manage.service.IDataRoomPageService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController(value="dataRoomChartController")
@RequestMapping(value={"/bigScreen/chart/data"})
@Api(tags={"\u56fe\u8868\u7ec4\u4ef6\u6570\u636e\u83b7\u53d6"})
public class ChartDataController {
    private static final Logger log = LoggerFactory.getLogger(ChartDataController.class);
    @Resource
    private IDataRoomPageService pageService;
    @Resource
    private BaseChartDataService baseChartDataService;

    @PostMapping(value={"/list"})
    @ApiOperation(value="\u56fe\u8868\u6570\u636e", position=10, notes="\u83b7\u53d6\u6307\u5b9a\u56fe\u8868\u7684\u6570\u636e(\u901a\u8fc7\u552f\u4e00\u7f16\u7801)", produces="application/json")
    public R<ChartDataVO> basicTableList(@RequestBody ChartDataSearchDTO chartDataSearchDTO) {
        PageEntity pageEntity = this.pageService.getByCode(chartDataSearchDTO.getPageCode());
        AssertUtils.isTrue((pageEntity != null ? 1 : 0) != 0, (String)"\u9875\u9762\u4e0d\u5b58\u5728");
        BasePageDTO config = pageEntity.getConfig();
        List<Chart> chartList = null;
        if (config.getClass().equals(DataRoomPageDTO.class)) {
            chartList = ((DataRoomPageDTO)config).getChartList();
        }
        if (chartList == null) {
            ChartDataVO mockData = ChartMockData.getMockData(chartDataSearchDTO.getType());
            return R.success((Object)mockData);
        }
        Chart chart = this.getByCode(chartList, chartDataSearchDTO.getChartCode());
        return this.getChartData(chartDataSearchDTO, config, chart);
    }

    @PostMapping(value={"/chart"})
    @ApiOperation(value="\u56fe\u8868\u6570\u636e", position=20, notes="\u83b7\u53d6\u6307\u5b9a\u56fe\u8868\u7684\u6570\u636e(\u901a\u8fc7\u914d\u7f6e)", produces="application/json")
    public R<ChartDataVO> getChartData(@RequestBody ChartDataSearchDTO chartDataSearchDTO) {
        PageEntity pageEntity = this.pageService.getByCode(chartDataSearchDTO.getPageCode());
        AssertUtils.isTrue((pageEntity != null ? 1 : 0) != 0, (String)"\u9875\u9762\u4e0d\u5b58\u5728");
        BasePageDTO config = pageEntity.getConfig();
        Chart chart = chartDataSearchDTO.getChart();
        return this.getChartData(chartDataSearchDTO, config, chart);
    }

    @GetMapping(value={"/mock/{type}"})
    @ApiOperation(value="\u56fe\u8868\u6a21\u62df\u6570\u636e", position=30, notes="\u83b7\u53d6\u6307\u5b9a\u7c7b\u578b\u7684\u56fe\u8868\u6a21\u62df\u6570\u636e", produces="application/json")
    public R<ChartDataVO> getMockData(@PathVariable String type) {
        ChartDataVO mockData = ChartMockData.getMockData(type);
        return R.success((Object)mockData);
    }

    private R<ChartDataVO> getChartData(ChartDataSearchDTO chartDataSearchDTO, BasePageDTO config, Chart chart) {
        if (chart == null) {
            ChartDataVO mockData = ChartMockData.getMockData(chartDataSearchDTO.getType());
            return R.success((Object)mockData);
        }
        try {
            ChartDataVO chartDataVO = this.baseChartDataService.dataQuery(chart, chartDataSearchDTO);
            if (chartDataVO == null) {
                String type = chartDataSearchDTO.getType();
                if (chart instanceof ScreenFlyMapChart) {
                    ScreenFlyMapChart screenFlyMapChart = (ScreenFlyMapChart)chart;
                    ScreenFlyMapChart.Customize customize = screenFlyMapChart.getCustomize();
                    switch (customize.getLevel()) {
                        case "0": {
                            type = type + "-world";
                            break;
                        }
                        case "1": {
                            type = type + "-country";
                            break;
                        }
                        case "2": {
                            type = type + "-province";
                            break;
                        }
                        default: {
                            type = type + "-" + customize.getLevel();
                        }
                    }
                }
                chartDataVO = ChartMockData.getMockData(type);
            }
            return R.success((Object)chartDataVO);
        }
        catch (Exception e) {
            log.error("\u56fe\u8868\u6570\u636e\u83b7\u53d6\u5931\u8d25", (Throwable)e);
            ChartDataVO mockData = ChartMockData.getMockData(chartDataSearchDTO.getType());
            return R.success((Object)mockData);
        }
    }

    public Chart getByCode(List<Chart> chartList, String code) {
        for (Chart chart : chartList) {
            ChartTabChart chartTabChart;
            Chart innerChart;
            if (chart.getCode().equals(code)) {
                return chart;
            }
            if (!(chart instanceof ChartTabChart) || (innerChart = (chartTabChart = (ChartTabChart)chart).getInnerChart(code)) == null) continue;
            return innerChart;
        }
        return null;
    }
}

