/*
 * Decompiled with CFR 0.152.
 */
package com.gccloud.dataroom.core.module.biz.component.controller;

import com.gccloud.common.permission.ApiPermission;
import com.gccloud.common.utils.BeanConvertUtils;
import com.gccloud.common.vo.PageVO;
import com.gccloud.common.vo.R;
import com.gccloud.dataroom.core.module.biz.component.dto.BizComponentDTO;
import com.gccloud.dataroom.core.module.biz.component.dto.BizComponentSearchDTO;
import com.gccloud.dataroom.core.module.biz.component.entity.BizComponentEntity;
import com.gccloud.dataroom.core.module.biz.component.service.IBizComponentService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiSort;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController(value="dataRoomBizComponentController")
@RequestMapping(value={"/bigScreen/bizComponent"})
@Api(tags={"\u4e1a\u52a1\u7ec4\u4ef6"})
@ApiSort(value=110)
public class BizComponentController {
    private static final Logger log = LoggerFactory.getLogger(BizComponentController.class);
    @Resource
    private IBizComponentService bizComponentService;

    @ApiPermission(permissions={"component:view"})
    @GetMapping(value={"/page"})
    @ApiOperation(value="\u5206\u9875", position=10, notes="\u5206\u9875\u67e5\u8be2\u4e1a\u52a1\u7ec4\u4ef6", produces="application/json")
    @ApiImplicitParams(value={@ApiImplicitParam(name="current", value="\u9875\u7801", paramType="query", required=true, dataType="int"), @ApiImplicitParam(name="size", value="\u6bcf\u9875\u6761\u6570", paramType="query", required=true, dataType="int"), @ApiImplicitParam(name="name", value="\u540d\u79f0\u6a21\u7cca\u67e5\u8be2", paramType="query", dataType="string")})
    public R<PageVO<BizComponentEntity>> getPage(@ApiParam(name="\u67e5\u8be2", value="\u4f20\u5165\u67e5\u8be2\u7684\u4e1a\u52a1\u6761\u4ef6", required=true) BizComponentSearchDTO searchDTO) {
        PageVO<BizComponentEntity> page = this.bizComponentService.getPage(searchDTO);
        return R.success(page);
    }

    @ApiPermission(permissions={"component:add"})
    @PostMapping(value={"/add"})
    @ApiOperation(value="\u65b0\u589e", notes="\u65b0\u589e", produces="application/json")
    public R<String> add(@ApiParam(name="\u65b0\u589e", value="\u4f20\u5165\u65b0\u589e\u7684\u4e1a\u52a1\u6761\u4ef6", required=true) @RequestBody BizComponentDTO dto) {
        BizComponentEntity entity = (BizComponentEntity)BeanConvertUtils.convert((Object)dto, BizComponentEntity.class);
        String code = this.bizComponentService.add(entity);
        return R.success((Object)code);
    }

    @ApiPermission(permissions={"component:update"})
    @PostMapping(value={"/update"})
    @ApiOperation(value="\u4fee\u6539", notes="\u4fee\u6539", produces="application/json")
    public R<Void> update(@ApiParam(name="\u4fee\u6539", value="\u4f20\u5165\u4fee\u6539\u7684\u4e1a\u52a1\u6761\u4ef6", required=true) @RequestBody BizComponentDTO dto) {
        BizComponentEntity entity = (BizComponentEntity)BeanConvertUtils.convert((Object)dto, BizComponentEntity.class);
        this.bizComponentService.update(entity);
        return R.success();
    }

    @ApiPermission(permissions={"component:add"})
    @PostMapping(value={"/copy/{code}"})
    @ApiOperation(value="\u590d\u5236", notes="\u590d\u5236", produces="application/json")
    public R<String> copy(@PathVariable String code) {
        String newCode = this.bizComponentService.copy(code);
        return R.success((Object)newCode);
    }

    @ApiPermission(permissions={"component:delete"})
    @PostMapping(value={"/delete/{id}"})
    @ApiOperation(value="\u5220\u9664", notes="\u5220\u9664", produces="application/json")
    public R<Void> delete(@ApiParam(name="\u5220\u9664", value="\u4f20\u5165\u5220\u9664\u7684\u4e1a\u52a1\u6761\u4ef6", required=true) @PathVariable String id) {
        this.bizComponentService.delete(id);
        return R.success();
    }

    @ApiPermission(permissions={"component:view"})
    @GetMapping(value={"/info/{code}"})
    @ApiOperation(value="\u6839\u636e\u7f16\u7801\u83b7\u53d6\u7ec4\u4ef6", notes="\u6839\u636e\u7f16\u7801\u83b7\u53d6\u7ec4\u4ef6", produces="application/json")
    public R<BizComponentEntity> getInfoByCode(@ApiParam(name="\u6839\u636e\u7f16\u7801\u83b7\u53d6\u7ec4\u4ef6", value="\u4f20\u5165\u6839\u636e\u7f16\u7801\u83b7\u53d6\u7ec4\u4ef6\u7684\u4e1a\u52a1\u6761\u4ef6", required=true) @PathVariable String code) {
        BizComponentEntity entity = this.bizComponentService.getInfoByCode(code);
        return R.success((Object)entity);
    }

    @ApiPermission(permissions={"component:view"})
    @PostMapping(value={"/name/repeat"})
    @ApiOperation(value="\u540d\u79f0\u67e5\u91cd", notes="\u540d\u79f0\u67e5\u91cd", produces="application/json")
    public R<Boolean> nameRepeat(@RequestBody BizComponentDTO dto) {
        return R.success((Object)this.bizComponentService.checkName(dto.getId(), dto.getName()));
    }
}

