/*
 * Decompiled with CFR 0.152.
 */
package com.gccloud.dashboard.core.module.template.controller;

import com.gccloud.common.controller.SuperController;
import com.gccloud.common.utils.BeanConvertUtils;
import com.gccloud.common.validator.ValidatorUtils;
import com.gccloud.common.validator.group.Insert;
import com.gccloud.common.validator.group.Update;
import com.gccloud.common.vo.PageVO;
import com.gccloud.common.vo.R;
import com.gccloud.dashboard.core.config.DashboardConfig;
import com.gccloud.dashboard.core.module.template.dto.PageTemplateDTO;
import com.gccloud.dashboard.core.module.template.dto.PageTemplateSearchDTO;
import com.gccloud.dashboard.core.module.template.entity.PageTemplateEntity;
import com.gccloud.dashboard.core.module.template.service.IPageTemplateService;
import com.gccloud.dashboard.core.module.template.vo.PageTemplateVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiSort;
import java.io.Serializable;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController(value="dashboardPageTemplateController")
@RequestMapping(value={"/dashboard/template"})
@Api(tags={"\u9875\u9762\u6a21\u677f"})
@ApiSort(value=10)
public class PageTemplateController
extends SuperController {
    private static final Logger log = LoggerFactory.getLogger(PageTemplateController.class);
    @Resource
    private IPageTemplateService pageTemplateService;
    @Resource
    private DashboardConfig dashboardConfig;

    @GetMapping(value={"/page"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2", position=10, notes="\u5206\u9875\u67e5\u8be2\u5217\u8868", produces="application/json")
    @ApiImplicitParams(value={@ApiImplicitParam(name="current", value="\u9875\u7801", paramType="query", required=true, dataType="int"), @ApiImplicitParam(name="size", value="\u6bcf\u9875\u6761\u6570", paramType="query", required=true, dataType="int"), @ApiImplicitParam(name="searchKey", value="\u67e5\u8be2\u6761\u4ef6", paramType="query", dataType="string")})
    public R<PageVO<PageTemplateVO>> getPage(@ApiParam(name="\u67e5\u8be2", value="\u4f20\u5165\u67e5\u8be2\u7684\u4e1a\u52a1\u6761\u4ef6", required=true) PageTemplateSearchDTO searchDTO) {
        PageVO<PageTemplateEntity> page = this.pageTemplateService.getPage(searchDTO);
        PageVO pageVO = BeanConvertUtils.convertPage(page, PageTemplateVO.class, (source, target) -> {
            if (target.getThumbnail() != null && !target.getThumbnail().startsWith("http")) {
                target.setThumbnail(this.dashboardConfig.getFile().getUrlPrefix() + target.getThumbnail());
            }
        });
        return this.success(pageVO);
    }

    @GetMapping(value={"/list"})
    @ApiOperation(value="\u5217\u8868\u67e5\u8be2", position=10, notes="\u67e5\u8be2\u5217\u8868", produces="application/json")
    public R<List<PageTemplateVO>> getList(@ApiParam(name="\u67e5\u8be2", value="\u4f20\u5165\u67e5\u8be2\u7684\u4e1a\u52a1\u6761\u4ef6", required=true) PageTemplateSearchDTO searchDTO) {
        List<PageTemplateEntity> list = this.pageTemplateService.getList(searchDTO);
        List voList = BeanConvertUtils.convert(list, PageTemplateVO.class, (source, target) -> {
            if (target.getThumbnail() != null && !target.getThumbnail().startsWith("http")) {
                target.setThumbnail(this.dashboardConfig.getFile().getUrlPrefix() + target.getThumbnail());
            }
        });
        return this.success(voList);
    }

    @GetMapping(value={"/info/{id}"})
    @ApiOperation(value="\u8be6\u60c5", position=20, notes="\u83b7\u53d6\u8be6\u60c5", produces="application/json")
    public R<PageTemplateVO> getById(@ApiParam(name="id", value="\u4f20\u5165String\u683c\u5f0f", required=true) @PathVariable(value="id") String id) {
        PageTemplateEntity pageTemplateEntity = (PageTemplateEntity)((Object)this.pageTemplateService.getById((Serializable)((Object)id)));
        PageTemplateVO vo = (PageTemplateVO)BeanConvertUtils.convert((Object)((Object)pageTemplateEntity), PageTemplateVO.class);
        return this.success(vo);
    }

    @PostMapping(value={"/add"})
    @ApiOperation(value="\u65b0\u589e", position=30, notes="\u65b0\u589e\u6570\u636e", produces="application/json")
    public R<String> add(@ApiParam(name="\u65b0\u589e\u5bf9\u8c61", value="\u4f20\u5165json\u683c\u5f0f", required=true) @RequestBody PageTemplateDTO pageTemplateDTO) {
        ValidatorUtils.validateEntity((Object)pageTemplateDTO, (Class[])new Class[]{Insert.class});
        PageTemplateEntity pageTemplateEntity = (PageTemplateEntity)((Object)BeanConvertUtils.convert((Object)pageTemplateDTO, PageTemplateEntity.class));
        String id = this.pageTemplateService.add(pageTemplateEntity);
        return this.success(id);
    }

    @PostMapping(value={"/update"})
    @ApiOperation(value="\u66f4\u65b0", position=40, notes="\u66f4\u65b0\u6570\u636e", consumes="application/json", produces="application/json")
    public R<Void> update(@ApiParam(name="\u66f4\u65b0\u5bf9\u8c61", value="\u4f20\u5165json\u683c\u5f0f", required=true) @RequestBody PageTemplateDTO pageTemplateDTO) {
        ValidatorUtils.validateEntity((Object)pageTemplateDTO, (Class[])new Class[]{Update.class});
        PageTemplateEntity pageTemplateEntity = (PageTemplateEntity)((Object)BeanConvertUtils.convert((Object)pageTemplateDTO, PageTemplateEntity.class));
        this.pageTemplateService.update(pageTemplateEntity);
        return this.success();
    }

    @PostMapping(value={"/delete"})
    @ApiOperation(value="\u5220\u9664", position=50, notes="\u5220\u9664", produces="application/json")
    public R<Void> deleteById(@ApiParam(name="id\u5217\u8868", value="\u4f20\u5165id\u5217\u8868", required=true) @RequestBody List<String> idList) {
        this.pageTemplateService.deleteByIds(idList);
        return this.success();
    }
}

