/*
 * Decompiled with CFR 0.152.
 */
package com.gccloud.dashboard.core.module.manage.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.gccloud.common.entity.SuperEntity;
import com.gccloud.common.exception.GlobalException;
import com.gccloud.common.utils.AssertUtils;
import com.gccloud.common.utils.BeanConvertUtils;
import com.gccloud.common.utils.QueryWrapperUtils;
import com.gccloud.common.vo.PageVO;
import com.gccloud.dashboard.core.config.DashboardConfig;
import com.gccloud.dashboard.core.module.basic.dao.DashboardPageDao;
import com.gccloud.dashboard.core.module.basic.entity.PageEntity;
import com.gccloud.dashboard.core.module.chart.bean.Chart;
import com.gccloud.dashboard.core.module.chart.components.datasource.DataSetDataSource;
import com.gccloud.dashboard.core.module.manage.dto.DashboardPageDTO;
import com.gccloud.dashboard.core.module.manage.dto.DashboardSearchDTO;
import com.gccloud.dashboard.core.module.manage.extend.DashboardExtendClient;
import com.gccloud.dashboard.core.module.manage.service.IDashboardPageService;
import com.gccloud.dashboard.core.module.template.entity.PageTemplateEntity;
import com.gccloud.dashboard.core.module.template.service.IPageTemplateService;
import com.gccloud.dashboard.core.utils.CodeGenerateUtils;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DashboardPageServiceImpl
extends ServiceImpl<DashboardPageDao, PageEntity>
implements IDashboardPageService {
    private static final Logger log = LoggerFactory.getLogger(DashboardPageServiceImpl.class);
    @Resource
    private IPageTemplateService pageTemplateService;
    @Resource
    private DashboardConfig dashboardConfig;
    @Resource
    private DashboardExtendClient dashboardExtendClient;

    @Override
    public String add(DashboardPageDTO dashboardPageDTO) {
        ArrayList chartList;
        if (StringUtils.isBlank((CharSequence)dashboardPageDTO.getCode())) {
            String code = CodeGenerateUtils.generate(dashboardPageDTO.getType());
            dashboardPageDTO.setCode(code);
        }
        if (CollectionUtils.isEmpty(chartList = dashboardPageDTO.getChartList())) {
            chartList = Lists.newArrayList();
        }
        for (Chart chart : chartList) {
            if (StringUtils.isNotBlank((CharSequence)chart.getCode())) continue;
            chart.setCode(CodeGenerateUtils.generate(chart.getType() == null ? "chart" : chart.getType()));
        }
        if (StringUtils.isNotBlank((CharSequence)dashboardPageDTO.getCoverPicture())) {
            String base64Str = dashboardPageDTO.getCoverPicture();
            String fileUrl = this.saveCoverPicture(base64Str, dashboardPageDTO.getCode());
            dashboardPageDTO.setCoverPicture(fileUrl);
        }
        PageEntity dashboard = (PageEntity)BeanConvertUtils.convert((Object)dashboardPageDTO, PageEntity.class);
        dashboard.setConfig(dashboardPageDTO);
        AssertUtils.isTrue((!this.checkNameRepeat(dashboard) ? 1 : 0) != 0, (String)"\u540d\u79f0\u91cd\u590d");
        AssertUtils.isTrue((!this.checkCodeRepeat(dashboard) ? 1 : 0) != 0, (String)"\u7f16\u7801\u91cd\u590d");
        this.save(dashboard);
        return dashboard.getCode();
    }

    private String saveCoverPicture(String base64String, String fileName) {
        String fileUrl = "";
        if (StringUtils.isBlank((CharSequence)base64String)) {
            return fileUrl;
        }
        try {
            File file;
            base64String = base64String.substring(base64String.indexOf(",") + 1);
            byte[] imageBytes = Base64.getDecoder().decode(base64String);
            String basePath = this.dashboardConfig.getFile().getBasePath();
            if (!basePath.endsWith("/") || !basePath.endsWith("\\")) {
                basePath = basePath + File.separator;
            }
            if (!(file = new File(basePath + "cover")).exists()) {
                file.mkdirs();
            }
            String filePath = basePath + "cover" + File.separator + fileName + ".png";
            fileUrl = "cover" + File.separator + fileName + ".png";
            FileOutputStream outputStream = new FileOutputStream(filePath);
            outputStream.write(imageBytes);
            outputStream.close();
            log.info("\u4eea\u8868\u76d8\u5c01\u9762\u4fdd\u5b58\u81f3\uff1a{}", (Object)filePath);
        }
        catch (IOException e) {
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
        return fileUrl;
    }

    @Override
    public String addByTemplate(DashboardPageDTO dashboardPageDTO) {
        if (StringUtils.isBlank((CharSequence)dashboardPageDTO.getPageTemplateId())) {
            throw new GlobalException("\u9875\u9762\u6a21\u677f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        dashboardPageDTO = this.getConfigByTemplate(dashboardPageDTO);
        return this.add(dashboardPageDTO);
    }

    @Override
    public DashboardPageDTO getConfigByTemplate(DashboardPageDTO dashboardPageDTO) {
        String pageTemplateId = dashboardPageDTO.getPageTemplateId();
        PageTemplateEntity pageTemplate = (PageTemplateEntity)((Object)this.pageTemplateService.getById((Serializable)((Object)pageTemplateId)));
        AssertUtils.isTrue((pageTemplate != null ? 1 : 0) != 0, (String)"\u9875\u9762\u6a21\u677f\u4e0d\u5b58\u5728");
        AssertUtils.isTrue((boolean)Objects.equals(pageTemplate.getType(), "dashboard"), (String)"\u9875\u9762\u6a21\u677f\u7c7b\u578b\u4e0d\u6b63\u786e");
        DashboardPageDTO config = (DashboardPageDTO)pageTemplate.getConfig();
        String name = dashboardPageDTO.getName();
        if (StringUtils.isBlank((CharSequence)name)) {
            int i = 0;
            String newName = pageTemplate.getName() + "\u526f\u672c";
            while (this.checkNameRepeat(dashboardPageDTO.getAppCode(), newName, null, "dashboard")) {
                newName = pageTemplate.getName() + "\u526f\u672c" + ++i;
            }
            name = newName;
        }
        config.setName(name);
        config.setCode(dashboardPageDTO.getCode());
        config.setParentCode(dashboardPageDTO.getParentCode());
        config.setId(dashboardPageDTO.getId());
        config.setAppCode(dashboardPageDTO.getAppCode());
        ArrayList chartList = config.getChartList();
        if (CollectionUtils.isEmpty(chartList)) {
            chartList = Lists.newArrayList();
        }
        for (Chart chart : chartList) {
            chart.setCode("");
            chart.setDataSource(new DataSetDataSource());
        }
        return config;
    }

    @Override
    public PageVO<PageEntity> getByCategory(DashboardSearchDTO searchDTO) {
        if (StringUtils.isBlank((CharSequence)searchDTO.getType())) {
            throw new GlobalException("\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        LambdaQueryWrapper queryWrapper = QueryWrapperUtils.wrapperLike((LambdaQueryWrapper)new LambdaQueryWrapper(), (String)searchDTO.getSearchKey(), (SFunction[])new SFunction[]{PageEntity::getName});
        if (StringUtils.isNotBlank((CharSequence)searchDTO.getParentCode())) {
            queryWrapper.eq(PageEntity::getParentCode, (Object)searchDTO.getParentCode());
        }
        queryWrapper.eq(PageEntity::getType, (Object)searchDTO.getType());
        queryWrapper.select((Object[])new SFunction[]{SuperEntity::getId, PageEntity::getAppCode, PageEntity::getCode, PageEntity::getName, PageEntity::getOrderNum, PageEntity::getParentCode, PageEntity::getCoverPicture, SuperEntity::getUpdateDate});
        queryWrapper.orderByAsc(PageEntity::getOrderNum);
        queryWrapper.orderByDesc(SuperEntity::getCreateDate);
        PageVO page = this.page(searchDTO, queryWrapper);
        List list = page.getList();
        if (list == null || list.isEmpty()) {
            return page;
        }
        String urlPrefix = this.dashboardConfig.getFile().getUrlPrefix();
        if (!urlPrefix.endsWith("/")) {
            urlPrefix = urlPrefix + "/";
        }
        for (PageEntity pageEntity : list) {
            if (StringUtils.isBlank((CharSequence)pageEntity.getCoverPicture())) continue;
            pageEntity.setCoverPicture(urlPrefix + pageEntity.getCoverPicture().replace("\\", "/"));
        }
        return page;
    }

    @Override
    public void update(DashboardPageDTO dashboardPageDTO) {
        AssertUtils.isTrue((boolean)StringUtils.isNotBlank((CharSequence)dashboardPageDTO.getCode()), (String)"\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isTrue((boolean)StringUtils.isNotBlank((CharSequence)dashboardPageDTO.getName()), (String)"\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        List<Chart> chartList = dashboardPageDTO.getChartList();
        if (CollectionUtils.isNotEmpty(chartList)) {
            for (Chart chart : chartList) {
                if (StringUtils.isNotBlank((CharSequence)chart.getCode())) continue;
                chart.setCode(CodeGenerateUtils.generate(chart.getType() == null ? "chart" : chart.getType()));
            }
        }
        if (StringUtils.isNotBlank((CharSequence)dashboardPageDTO.getCoverPicture())) {
            String coverPicture = this.saveCoverPicture(dashboardPageDTO.getCoverPicture(), dashboardPageDTO.getCode());
            dashboardPageDTO.setCoverPicture(coverPicture);
        }
        PageEntity dashboardEntity = (PageEntity)BeanConvertUtils.convert((Object)dashboardPageDTO, PageEntity.class);
        dashboardEntity.setConfig(dashboardPageDTO);
        AssertUtils.isTrue((!this.checkNameRepeat(dashboardEntity) ? 1 : 0) != 0, (String)"\u540d\u79f0\u91cd\u590d");
        AssertUtils.isTrue((!this.checkCodeRepeat(dashboardEntity) ? 1 : 0) != 0, (String)"\u7f16\u7801\u91cd\u590d");
        this.updateById(dashboardEntity);
        PAGE_ENTITY_CACHE.invalidate((Object)dashboardPageDTO.getCode());
    }

    @Override
    public String copy(PageEntity dashboardEntity) {
        DashboardPageDTO config = (DashboardPageDTO)dashboardEntity.getConfig();
        dashboardEntity.setId(null);
        dashboardEntity.setCode(CodeGenerateUtils.generate(dashboardEntity.getType()));
        dashboardEntity.setName(dashboardEntity.getName() + "_\u590d\u5236");
        config.setName(dashboardEntity.getName());
        config.setCode(dashboardEntity.getCode());
        List<Chart> chartList = config.getChartList();
        for (Chart chart : chartList) {
            chart.setCode(CodeGenerateUtils.generate(chart.getType() == null ? "chart" : chart.getType()));
        }
        this.save(dashboardEntity);
        return dashboardEntity.getCode();
    }

    @Override
    public void deleteByCode(String code) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(PageEntity::getCode, (Object)code);
        this.remove((Wrapper)queryWrapper);
        PAGE_ENTITY_CACHE.invalidate((Object)code);
        this.dashboardExtendClient.deleteByCode(code);
    }
}

