/*
 * Decompiled with CFR 0.152.
 */
package com.gccloud.dashboard.core.module.manage.controller;

import com.gccloud.common.exception.GlobalException;
import com.gccloud.common.permission.ApiPermission;
import com.gccloud.common.utils.BeanConvertUtils;
import com.gccloud.common.validator.ValidatorUtils;
import com.gccloud.common.validator.group.Insert;
import com.gccloud.common.validator.group.Update;
import com.gccloud.common.vo.MixinsResp;
import com.gccloud.common.vo.PageVO;
import com.gccloud.common.vo.R;
import com.gccloud.dashboard.core.config.DashboardConfig;
import com.gccloud.dashboard.core.module.basic.entity.PageEntity;
import com.gccloud.dashboard.core.module.manage.dto.DashboardPageDTO;
import com.gccloud.dashboard.core.module.manage.dto.DashboardSearchDTO;
import com.gccloud.dashboard.core.module.manage.service.IDashboardPageService;
import com.gccloud.dashboard.core.module.manage.vo.StaticFileVO;
import com.gccloud.dashboard.core.utils.Webjars;
import com.google.common.collect.Lists;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/dashboard/design"})
@Api(tags={"\u4eea\u8868\u76d8\u9875\u4ee5\u53ca\u4eea\u8868\u76d8\u7ec4\u4ef6\u8bbe\u8ba1"})
public class DashboardPageController {
    private static final Logger log = LoggerFactory.getLogger(DashboardPageController.class);
    @Resource
    private IDashboardPageService dashboardPageService;
    @Resource
    private DashboardConfig dashboardConfig;

    @ApiPermission(permissions={"dashboard:view"})
    @GetMapping(value={"/info/code/{code}"})
    @ApiOperation(value="\u4eea\u8868\u76d8\u9875/\u7ec4\u4ef6\u8be6\u60c5", position=10, produces="application/json")
    public MixinsResp<DashboardPageDTO> info(@PathVariable(value="code") String code) {
        PageEntity dashboard = this.dashboardPageService.getByCode(code);
        DashboardPageDTO dashboardConfig = (DashboardPageDTO)dashboard.getConfig();
        BeanConvertUtils.convert((Object)dashboard, (Object)dashboardConfig);
        MixinsResp resp = new MixinsResp().setData((Object)dashboardConfig);
        resp.setCode(Integer.valueOf(200));
        return resp;
    }

    @ApiPermission(permissions={"dashboard:view"})
    @GetMapping(value={"/page"})
    @ApiOperation(value="\u4eea\u8868\u76d8/\u7ec4\u4ef6\u5206\u9875\u5217\u8868", position=10, produces="application/json")
    public MixinsResp<PageVO<PageEntity>> page(DashboardSearchDTO searchDTO) {
        PageVO<PageEntity> page = this.dashboardPageService.getByCategory(searchDTO);
        MixinsResp resp = new MixinsResp().setData(page);
        resp.setCode(Integer.valueOf(200));
        return resp;
    }

    @ApiPermission(permissions={"dashboard:add"})
    @PostMapping(value={"/add"})
    @ApiOperation(value="\u4ece\u7a7a\u767d\u65b0\u589e\u4eea\u8868\u76d8/\u7ec4\u4ef6", position=20, produces="application/json")
    public R<String> add(@RequestBody DashboardPageDTO dashboardPageDTO) {
        ValidatorUtils.validateEntity((Object)dashboardPageDTO, (Class[])new Class[]{Insert.class});
        this.dashboardPageService.add(dashboardPageDTO);
        if (StringUtils.isBlank((CharSequence)dashboardPageDTO.getParentCode())) {
            dashboardPageDTO.setParentCode("0");
        }
        return R.success((Object)dashboardPageDTO.getCode());
    }

    @ApiPermission(permissions={"dashboard:update"})
    @PostMapping(value={"/update"})
    @ApiOperation(value="\u4fee\u6539\u4eea\u8868\u76d8/\u7ec4\u4ef6", position=30, produces="application/json")
    public R<String> update(@RequestBody DashboardPageDTO dashboardPageDTO) {
        ValidatorUtils.validateEntity((Object)dashboardPageDTO, (Class[])new Class[]{Update.class});
        if (StringUtils.isBlank((CharSequence)dashboardPageDTO.getParentCode())) {
            dashboardPageDTO.setParentCode("0");
        }
        this.dashboardPageService.update(dashboardPageDTO);
        return R.success((Object)dashboardPageDTO.getCode());
    }

    @ApiPermission(permissions={"dashboard:delete"})
    @PostMapping(value={"/delete/{code}"})
    @ApiOperation(value="\u5220\u9664\u4eea\u8868\u76d8/\u7ec4\u4ef6", position=40, produces="application/json")
    public R<Void> delete(@PathVariable String code) {
        PageEntity dashboardEntity = this.dashboardPageService.getByCode(code);
        if (dashboardEntity == null) {
            return R.success();
        }
        this.dashboardPageService.deleteByCode(code);
        return R.success();
    }

    @ApiPermission(permissions={"dashboard:add"})
    @PostMapping(value={"/copy/{code}"})
    @ApiOperation(value="\u590d\u5236\u4eea\u8868\u76d8/\u7ec4\u4ef6", position=50, produces="application/json")
    public R<String> copy(@PathVariable String code) {
        PageEntity dashboardPage = this.dashboardPageService.getByCode(code);
        if (dashboardPage == null) {
            throw new GlobalException("\u4eea\u8868\u76d8\u9875\u4e0d\u5b58\u5728");
        }
        String newCode = this.dashboardPageService.copy(dashboardPage);
        return R.success((Object)newCode);
    }

    @ApiPermission(permissions={"dashboard:add"})
    @PostMapping(value={"/add/template"})
    @ApiOperation(value="\u4ece\u6a21\u677f\u65b0\u589e\u4eea\u8868\u76d8\u9875", position=20, produces="application/json")
    public R<String> addByTemplate(@RequestBody DashboardPageDTO dashboardPageDTO) {
        String code = this.dashboardPageService.addByTemplate(dashboardPageDTO);
        if (StringUtils.isBlank((CharSequence)dashboardPageDTO.getParentCode())) {
            dashboardPageDTO.setParentCode("0");
        }
        return R.success((Object)code);
    }

    @PostMapping(value={"/get/template"})
    @ApiOperation(value="\u6839\u636e\u6a21\u677f\u83b7\u53d6\u914d\u7f6e", position=20, produces="application/json")
    public MixinsResp<DashboardPageDTO> getByTemplate(@RequestBody DashboardPageDTO dashboardPageDTO) {
        DashboardPageDTO config = this.dashboardPageService.getConfigByTemplate(dashboardPageDTO);
        MixinsResp resp = new MixinsResp().setData((Object)config);
        resp.setCode(Integer.valueOf(200));
        return resp;
    }

    @ApiPermission
    @GetMapping(value={"/bg/list"})
    @ApiOperation(value="\u80cc\u666f\u56fe\u7247\u5217\u8868", position=60, produces="application/json")
    public R<List<StaticFileVO>> getBgList() {
        List<String> staticFileList = Webjars.DASHBOARD_BG;
        ArrayList bgList = Lists.newArrayList();
        String urlPrefix = this.dashboardConfig.getFile().getUrlPrefix() + "dashboardBg/";
        for (String fileName : staticFileList) {
            StaticFileVO fileVO = new StaticFileVO();
            fileVO.setUrl(urlPrefix + fileName);
            fileVO.setName(fileName);
            bgList.add(fileVO);
        }
        return R.success((Object)bgList);
    }

    @ApiPermission
    @GetMapping(value={"/map/list/{level}"})
    @ApiOperation(value="\u5730\u56fe\u6570\u636e\u5217\u8868", position=60, produces="application/json")
    public R<List<StaticFileVO>> getMapJsonList(@PathVariable(value="level") String level) {
        List<Object> staticFileList = Lists.newArrayList();
        if ("country".equals(level)) {
            staticFileList = Webjars.COUNTRY_MAP_DATA;
        }
        if ("province".equals(level)) {
            staticFileList = Webjars.PROVINCE_MAP_DATA;
        }
        ArrayList bgList = Lists.newArrayList();
        String urlPrefix = "static/chinaMap/" + level + "/";
        for (String string : staticFileList) {
            StaticFileVO fileVO = new StaticFileVO();
            fileVO.setUrl(string);
            fileVO.setName(string.replace(".json", ""));
            bgList.add(fileVO);
        }
        return R.success((Object)bgList);
    }
}

