/*
 * Decompiled with CFR 0.152.
 */
package com.gccloud.dashboard.core.module.chart.controller;

import com.gccloud.common.utils.AssertUtils;
import com.gccloud.common.vo.R;
import com.gccloud.dashboard.core.module.basic.dto.BasePageDTO;
import com.gccloud.dashboard.core.module.basic.entity.PageEntity;
import com.gccloud.dashboard.core.module.chart.bean.Chart;
import com.gccloud.dashboard.core.module.chart.dto.ChartDataSearchDTO;
import com.gccloud.dashboard.core.module.chart.service.BaseChartDataService;
import com.gccloud.dashboard.core.module.chart.service.ChartMockData;
import com.gccloud.dashboard.core.module.chart.vo.ChartDataVO;
import com.gccloud.dashboard.core.module.manage.dto.DashboardPageDTO;
import com.gccloud.dashboard.core.module.manage.service.IDashboardPageService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController(value="dashboardChartController")
@RequestMapping(value={"/dashboard/chart/data"})
@Api(tags={"\u56fe\u8868\u7ec4\u4ef6\u6570\u636e\u83b7\u53d6"})
public class ChartDataController {
    private static final Logger log = LoggerFactory.getLogger(ChartDataController.class);
    @Resource
    private IDashboardPageService pageService;
    @Resource
    private BaseChartDataService baseChartDataService;

    @PostMapping(value={"/list"})
    @ApiOperation(value="\u56fe\u8868\u6570\u636e", position=10, notes="\u83b7\u53d6\u6307\u5b9a\u56fe\u8868\u7684\u6570\u636e(\u901a\u8fc7\u552f\u4e00\u7f16\u7801)", produces="application/json")
    public R<ChartDataVO> getChartDataByCode(@RequestBody ChartDataSearchDTO chartDataSearchDTO) {
        PageEntity pageEntity = this.pageService.getByCode(chartDataSearchDTO.getPageCode());
        AssertUtils.isTrue((pageEntity != null ? 1 : 0) != 0, (String)"\u9875\u9762\u4e0d\u5b58\u5728");
        BasePageDTO config = pageEntity.getConfig();
        List<Chart> chartList = null;
        if (config.getClass().equals(DashboardPageDTO.class)) {
            chartList = ((DashboardPageDTO)config).getChartList();
        }
        if (chartList == null) {
            ChartDataVO mockData = ChartMockData.getMockData(chartDataSearchDTO.getType());
            return R.success((Object)mockData);
        }
        Chart chart = this.getByCode(chartList, chartDataSearchDTO.getChartCode());
        return this.getChartData(chartDataSearchDTO, config, chart);
    }

    @PostMapping(value={"/chart"})
    @ApiOperation(value="\u56fe\u8868\u6570\u636e", position=10, notes="\u83b7\u53d6\u6307\u5b9a\u56fe\u8868\u7684\u6570\u636e(\u901a\u8fc7\u914d\u7f6e)", produces="application/json")
    public R<ChartDataVO> getChartDataByChart(@RequestBody ChartDataSearchDTO chartDataSearchDTO) {
        PageEntity pageEntity = this.pageService.getByCode(chartDataSearchDTO.getPageCode());
        AssertUtils.isTrue((pageEntity != null ? 1 : 0) != 0, (String)"\u9875\u9762\u4e0d\u5b58\u5728");
        BasePageDTO config = pageEntity.getConfig();
        Chart chart = chartDataSearchDTO.getChart();
        return this.getChartData(chartDataSearchDTO, config, chart);
    }

    private R<ChartDataVO> getChartData(ChartDataSearchDTO chartDataSearchDTO, BasePageDTO config, Chart chart) {
        if (chart == null) {
            ChartDataVO mockData = ChartMockData.getMockData(chartDataSearchDTO.getType());
            return R.success((Object)mockData);
        }
        try {
            ChartDataVO chartDataVO = this.baseChartDataService.dataQuery(chart, chartDataSearchDTO);
            if (chartDataVO == null) {
                chartDataVO = ChartMockData.getMockData(chartDataSearchDTO.getType());
            }
            return R.success((Object)chartDataVO);
        }
        catch (Exception e) {
            log.error("\u56fe\u8868\u6570\u636e\u83b7\u53d6\u5931\u8d25", (Throwable)e);
            ChartDataVO mockData = ChartMockData.getMockData(chartDataSearchDTO.getType());
            return R.success((Object)mockData);
        }
    }

    public Chart getByCode(List<Chart> chartList, String code) {
        for (Chart chart : chartList) {
            if (!chart.getCode().equals(code)) continue;
            return chart;
        }
        return null;
    }
}

