/*
 * Decompiled with CFR 0.152.
 */
package com.envision.apim.poseidon.interceptor;

import com.envision.apim.poseidon.core.Poseidon;
import com.envision.apim.poseidon.exception.PoseidonException;
import com.envision.apim.poseidon.util.StringUtils;
import java.io.IOException;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

public abstract class BaseInterceptor
implements Interceptor {
    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        Response response = chain.proceed(request);
        if (!response.isRedirect()) {
            if (Poseidon.isStreamType(response)) {
                throw new PoseidonException("The download file must be redirected");
            }
            return response;
        }
        Request.Builder newBuilder = request.newBuilder();
        this.processBefore(request, newBuilder);
        Response processRedirect = this.processRedirect(chain, newBuilder, response, 10);
        return this.processAfter(processRedirect);
    }

    protected abstract Response processAfter(Response var1);

    protected abstract void processBefore(Request var1, Request.Builder var2);

    Response processRedirect(Interceptor.Chain chain, Request.Builder newBuilder, Response response, int count) throws IOException {
        String location = response.header("Location");
        if (StringUtils.isEmpty(location)) {
            Poseidon.debug("location is null");
            return response;
        }
        Poseidon.debug("Location: " + location);
        Poseidon.debug("RedirectsResponse: " + Poseidon.getResponseHeaders(response.headers(), null));
        newBuilder.url(location);
        for (String key : response.headers().names()) {
            String value;
            if (StringUtils.isEmpty(key) || !key.contains("Apim-") && !key.contains("apim-") || StringUtils.isEmpty(value = response.header(key))) continue;
            newBuilder.addHeader(key, value);
        }
        Response proceed = chain.proceed(newBuilder.build());
        if (proceed.isRedirect()) {
            if (count == 0) {
                throw new PoseidonException("No more than 10 redirects");
            }
            return this.processRedirect(chain, newBuilder, proceed, --count);
        }
        return proceed;
    }
}

