/*
 * Decompiled with CFR 0.152.
 */
package com.ejlchina.okhttps;

import com.ejlchina.okhttps.HttpResult;
import java.io.File;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import okhttp3.MediaType;

public class DownloadHelper {
    private Map<String, String> extMappings = new HashMap<String, String>();

    public DownloadHelper() {
        this.extMappings.put("video/mpeg4", "mp4");
        this.extMappings.put("text/plain", "txt");
        this.extMappings.put("application/x-xls", "text/xls");
        this.extMappings.put("application/vnd.android.package-archive", "apk");
        this.extMappings.put("application/msword", "doc");
    }

    public String resolveFileName(HttpResult result) {
        String contentDisposition = result.getHeader("Content-Disposition");
        if (contentDisposition == null || contentDisposition.length() < 1) {
            String urlPath = result.getTask().getUrl();
            String urlName = urlPath.substring(urlPath.lastIndexOf("/") + 1);
            return this.toFileName(urlName, result);
        }
        String filename = URLDecoder.decode(contentDisposition.substring(contentDisposition.indexOf("filename=") + 9), StandardCharsets.UTF_8);
        return filename.replaceAll("\"", "");
    }

    protected String toFileName(String name, HttpResult result) {
        int dotIndex = name.lastIndexOf(46);
        if (dotIndex > -1 && dotIndex < name.length() - 1) {
            return name;
        }
        MediaType type = result.getBody().getType();
        String ext = this.extMappings.get(type.toString());
        if (ext == null) {
            ext = type.subtype();
        }
        if (dotIndex == -1) {
            return name + "." + ext;
        }
        return name + ext;
    }

    public String resolveFilePath(String dirPath, String fileName) {
        if (dirPath.endsWith("\\") || dirPath.endsWith("/")) {
            return dirPath + fileName;
        }
        return dirPath + File.separator + fileName;
    }

    public String indexFileName(String fileName, int index) {
        int i = fileName.lastIndexOf(46);
        if (i < 0) {
            return fileName + "(" + index + ")";
        }
        String ext = fileName.substring(i);
        if (i > 0) {
            String name = fileName.substring(0, i);
            return name + "(" + index + ")" + ext;
        }
        return "(" + index + ")" + ext;
    }

    public Map<String, String> getExtMappings() {
        return this.extMappings;
    }

    public void setExtMappings(Map<String, String> extMappings) {
        this.extMappings = extMappings;
    }
}

