/*
 * Decompiled with CFR 0.152.
 */
package com.ejlchina.data;

import com.ejlchina.data.Array;
import com.ejlchina.data.Mapper;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Deserializer {
    public Object deserialize(Mapper mapper, Type type) {
        Type[] typeArgs = null;
        if (type instanceof ParameterizedType) {
            typeArgs = ((ParameterizedType)type).getActualTypeArguments();
        }
        Class<?> clazz = this.toClass(type);
        return this.toBean(clazz, typeArgs, mapper);
    }

    protected Object toBean(Class<?> clazz, Type[] typeArgs, Mapper mapper) {
        Object bean;
        if (clazz == Map.class || clazz == HashMap.class) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            for (String key : mapper.keySet()) {
                if (typeArgs.length > 1) {
                    map.put(key, this.fieldValue(mapper, key, typeArgs[1]));
                    continue;
                }
                map.put(key, this.fieldValue(mapper, key, (Type)((Object)String.class)));
            }
            return map;
        }
        try {
            bean = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalStateException("\u65e0\u6cd5\u6784\u9020 " + clazz + " \u5bf9\u8c61", e);
        }
        TypeVariable<Class<?>>[] typeParas = clazz.getTypeParameters();
        Map<String, Method> methods = this.getSetMethods(clazz);
        for (String field : methods.keySet()) {
            Type[] gTypes;
            Method method = methods.get(field);
            Type fieldType = method.getParameterTypes()[0];
            if (fieldType == Object.class && typeParas.length > 0 && (gTypes = method.getGenericParameterTypes()).length > 0) {
                Type gType = gTypes[0];
                for (int i = 0; i < typeParas.length; ++i) {
                    if (typeParas[i] != gType) continue;
                    fieldType = typeArgs[i];
                }
            }
            Object fieldValue = this.fieldValue(mapper, field, fieldType);
            try {
                method.invoke(bean, fieldValue);
            }
            catch (ReflectiveOperationException e) {
                throw new IllegalStateException("\u65e0\u6cd5\u4e3a " + clazz + " \u5bf9\u8c61\u7684 " + field + "\u5c5e\u6027\u8d4b\u503c", e);
            }
        }
        return bean;
    }

    protected Object fieldValue(Mapper mapper, String field, Type type) {
        if (type == Integer.TYPE || type == Integer.class) {
            return mapper.getInt(field);
        }
        if (type == Long.TYPE || type == Long.class) {
            return mapper.getLong(field);
        }
        if (type == Float.TYPE || type == Float.class) {
            return Float.valueOf(mapper.getFloat(field));
        }
        if (type == Double.TYPE || type == Double.class) {
            return mapper.getDouble(field);
        }
        if (type == Boolean.TYPE || type == Boolean.class) {
            return mapper.getBool(field);
        }
        if (type == String.class) {
            return mapper.getString(field);
        }
        if (type == BigDecimal.class) {
            return new BigDecimal(mapper.getString(field));
        }
        if (type == BigInteger.class) {
            return new BigInteger(mapper.getString(field));
        }
        Class<?> clazz = this.toClass(type);
        if (clazz == List.class || clazz == ArrayList.class) {
            Array array = mapper.getArray(field);
            if (array != null) {
                ArrayList<Object> list = new ArrayList<Object>();
                for (int i = 0; i < array.size(); ++i) {
                    list.add(this.deserialize(array.getMapper(i), ((ParameterizedType)type).getActualTypeArguments()[0]));
                }
                return list;
            }
        } else {
            Mapper value = mapper.getMapper(field);
            if (value != null) {
                return this.deserialize(value, type);
            }
        }
        return null;
    }

    protected Map<String, Method> getSetMethods(Class<?> clazz) {
        HashMap<String, Method> methods = new HashMap<String, Method>();
        for (Method method : clazz.getMethods()) {
            String methodName = method.getName();
            Class<?>[] paraTypes = method.getParameterTypes();
            if (paraTypes.length != 1 || methodName.length() <= 3 || !methodName.startsWith("set")) continue;
            String field = this.firstCharToLowerCase(methodName.substring(3));
            methods.put(field, method);
        }
        return methods;
    }

    protected Class<?> toClass(Type type) {
        Type rawType;
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType && (rawType = ((ParameterizedType)type).getRawType()) instanceof Class) {
            return (Class)rawType;
        }
        return null;
    }

    protected String firstCharToLowerCase(String str) {
        char firstChar = str.charAt(0);
        if (firstChar >= 'A' && firstChar <= 'Z') {
            char[] arr = str.toCharArray();
            arr[0] = (char)(arr[0] + 32);
            return new String(arr);
        }
        return str;
    }
}

