/*
 * Decompiled with CFR 0.152.
 */
package com.dyuproject.protostuff.runtime;

import com.dyuproject.protostuff.GraphInput;
import com.dyuproject.protostuff.Input;
import com.dyuproject.protostuff.Output;
import com.dyuproject.protostuff.Pipe;
import com.dyuproject.protostuff.ProtostuffException;
import com.dyuproject.protostuff.Schema;
import com.dyuproject.protostuff.runtime.IdStrategy;
import com.dyuproject.protostuff.runtime.ObjectSchema;
import com.dyuproject.protostuff.runtime.PolymorphicSchema;
import java.io.IOException;

public abstract class ClassSchema
extends PolymorphicSchema {
    static final int ID_ARRAY_DIMENSION = 2;
    static final String STR_ARRAY_DIMENSION = "b";
    protected final Pipe.Schema<Object> pipeSchema = new Pipe.Schema<Object>((Schema)this){

        protected void transfer(Pipe pipe, Input input, Output output) throws IOException {
            ClassSchema.transferObject(this, pipe, input, output, ClassSchema.this.strategy);
        }
    };

    static String name(int number) {
        switch (number) {
            case 2: {
                return STR_ARRAY_DIMENSION;
            }
            case 18: {
                return "r";
            }
            case 19: {
                return "s";
            }
            case 20: {
                return "t";
            }
            case 21: {
                return "u";
            }
        }
        return null;
    }

    static int number(String name) {
        if (name.length() != 1) {
            return 0;
        }
        switch (name.charAt(0)) {
            case 'b': {
                return 2;
            }
            case 'r': {
                return 18;
            }
            case 's': {
                return 19;
            }
            case 't': {
                return 20;
            }
            case 'u': {
                return 21;
            }
        }
        return 0;
    }

    public ClassSchema(IdStrategy strategy) {
        super(strategy);
    }

    @Override
    public Pipe.Schema<Object> getPipeSchema() {
        return this.pipeSchema;
    }

    public String getFieldName(int number) {
        return ClassSchema.name(number);
    }

    public int getFieldNumber(String name) {
        return ClassSchema.number(name);
    }

    public String messageFullName() {
        return Class.class.getName();
    }

    public String messageName() {
        return Class.class.getSimpleName();
    }

    public void mergeFrom(Input input, Object owner) throws IOException {
        this.setValue(ClassSchema.readObjectFrom(input, this, owner, this.strategy), owner);
    }

    public void writeTo(Output output, Object value) throws IOException {
        ClassSchema.writeObjectTo(output, value, this, this.strategy);
    }

    static void writeObjectTo(Output output, Object value, Schema<?> currentSchema, IdStrategy strategy) throws IOException {
        Class c = (Class)value;
        if (c.isArray()) {
            int dimensions = 1;
            Class<?> componentType = c.getComponentType();
            while (componentType.isArray()) {
                ++dimensions;
                componentType = componentType.getComponentType();
            }
            strategy.writeClassIdTo(output, componentType, true);
            output.writeUInt32(2, dimensions, false);
            return;
        }
        strategy.writeClassIdTo(output, c, false);
    }

    static Object readObjectFrom(Input input, Schema<?> schema, Object owner, IdStrategy strategy) throws IOException {
        Class<?> value;
        int number = input.readFieldNumber(schema);
        switch (number) {
            case 18: {
                value = strategy.resolveClassFrom(input, false, false);
                break;
            }
            case 19: {
                value = strategy.resolveClassFrom(input, true, false);
                break;
            }
            case 20: {
                value = ObjectSchema.getArrayClass(input, schema, strategy.resolveClassFrom(input, false, true));
                break;
            }
            case 21: {
                value = ObjectSchema.getArrayClass(input, schema, strategy.resolveClassFrom(input, true, true));
                break;
            }
            default: {
                throw new ProtostuffException("Corrupt input.");
            }
        }
        if (input instanceof GraphInput) {
            ((GraphInput)input).updateLast(value, owner);
        }
        if (input.readFieldNumber(schema) != 0) {
            throw new ProtostuffException("Corrupt input.");
        }
        return value;
    }

    static void transferObject(Pipe.Schema<Object> pipeSchema, Pipe pipe, Input input, Output output, IdStrategy strategy) throws IOException {
        int number = input.readFieldNumber(pipeSchema.wrappedSchema);
        switch (number) {
            case 18: {
                ObjectSchema.transferClass(pipe, input, output, number, pipeSchema, false, false, strategy);
                break;
            }
            case 19: {
                ObjectSchema.transferClass(pipe, input, output, number, pipeSchema, true, false, strategy);
                break;
            }
            case 20: {
                ObjectSchema.transferClass(pipe, input, output, number, pipeSchema, false, true, strategy);
                break;
            }
            case 21: {
                ObjectSchema.transferClass(pipe, input, output, number, pipeSchema, true, true, strategy);
                break;
            }
            default: {
                throw new ProtostuffException("Corrupt input.");
            }
        }
        if (input.readFieldNumber(pipeSchema.wrappedSchema) != 0) {
            throw new ProtostuffException("Corrupt input.");
        }
    }
}

