/*
 * Decompiled with CFR 0.152.
 */
package com.diboot.scheduler.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.diboot.core.config.Cons;
import com.diboot.core.entity.AbstractEntity;
import com.diboot.core.exception.BusinessException;
import com.diboot.core.service.impl.BaseServiceImpl;
import com.diboot.core.util.V;
import com.diboot.core.vo.Status;
import com.diboot.scheduler.entity.ScheduleJob;
import com.diboot.scheduler.mapper.ScheduleJobMapper;
import com.diboot.scheduler.service.QuartzSchedulerService;
import com.diboot.scheduler.service.ScheduleJobService;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ScheduleJobServiceImpl
extends BaseServiceImpl<ScheduleJobMapper, ScheduleJob>
implements ScheduleJobService {
    private static final Logger log = LoggerFactory.getLogger(ScheduleJobServiceImpl.class);
    @Autowired
    private QuartzSchedulerService quartzSchedulerService;

    public boolean createEntity(ScheduleJob entity) {
        boolean success = super.createEntity((Object)entity);
        if (!success) {
            throw new BusinessException(Status.FAIL_OPERATION, "\u521b\u5efa\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25!", new Object[0]);
        }
        if (V.equals((Object)entity.getJobStatus(), (Object)Cons.ENABLE_STATUS.A.name())) {
            this.quartzSchedulerService.addJob(entity);
        }
        return true;
    }

    public boolean updateEntity(ScheduleJob entity) {
        ScheduleJob oldJob = (ScheduleJob)((Object)this.getEntity(entity.getId()));
        boolean success = super.updateEntity((Object)entity);
        if (!success) {
            throw new BusinessException(Status.FAIL_OPERATION, "\u66f4\u65b0\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25!", new Object[0]);
        }
        if (this.quartzSchedulerService.existJob((String)((Object)entity.getId())) && (V.notEquals((Object)oldJob.getJobStatus(), (Object)entity.getJobStatus()) || V.notEquals((Object)oldJob.getJobKey(), (Object)entity.getJobKey()) || V.notEquals((Object)oldJob.getCron(), (Object)entity.getCron()) || V.notEquals((Object)oldJob.getParamJson(), (Object)entity.getParamJson()) || V.notEquals((Object)oldJob.getInitStrategy(), (Object)entity.getInitStrategy()))) {
            this.quartzSchedulerService.deleteJob((String)((Object)entity.getId()));
            if (V.equals((Object)entity.getJobStatus(), (Object)Cons.ENABLE_STATUS.A.name())) {
                this.quartzSchedulerService.addJob(entity);
            }
        }
        return true;
    }

    public boolean deleteEntity(Serializable jobId) {
        this.quartzSchedulerService.deleteJob((String)((Object)jobId));
        return super.deleteEntity(jobId);
    }

    @Override
    public boolean executeOnceJob(String jobId) {
        if (!this.quartzSchedulerService.existJob(jobId)) {
            ScheduleJob entity = (ScheduleJob)((Object)this.getEntity((Serializable)((Object)jobId)));
            if (V.isEmpty((Object)((Object)entity))) {
                throw new BusinessException(Status.FAIL_OPERATION, "\u5f53\u524d\u4efb\u52a1\u65e0\u6548\uff01", new Object[0]);
            }
            this.quartzSchedulerService.addJobExecuteOnce(entity);
        } else {
            this.quartzSchedulerService.runJob(jobId);
        }
        return true;
    }

    @Override
    public boolean changeScheduleJobStatus(String jobId, String jobStatus) {
        boolean success = this.update((Wrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate().set(ScheduleJob::getJobStatus, (Object)jobStatus)).eq(AbstractEntity::getId, (Object)jobId));
        if (!success) {
            throw new BusinessException(Status.FAIL_OPERATION, "\u66f4\u65b0\u72b6\u6001\u5931\u8d25\uff01", new Object[0]);
        }
        if (Cons.ENABLE_STATUS.A.name().equals(jobStatus)) {
            if (this.quartzSchedulerService.existJob(jobId)) {
                this.quartzSchedulerService.resumeJob(jobId);
            } else {
                ScheduleJob entity = (ScheduleJob)((Object)this.getEntity((Serializable)((Object)jobId)));
                if (V.isEmpty((Object)((Object)entity))) {
                    throw new BusinessException(Status.FAIL_OPERATION, "\u5f53\u524d\u4efb\u52a1\u65e0\u6548\uff01", new Object[0]);
                }
                this.quartzSchedulerService.addJob(entity);
            }
        } else if (Cons.ENABLE_STATUS.I.name().equals(jobStatus)) {
            this.quartzSchedulerService.pauseJob(jobId);
        } else {
            log.warn("\u65e0\u6548\u7684action\u53c2\u6570: {}", (Object)jobStatus);
        }
        return true;
    }

    @Override
    public List<Map<String, Object>> getAllJobs() throws Exception {
        return this.quartzSchedulerService.loadAllJobs();
    }
}

