/*
 * Decompiled with CFR 0.152.
 */
package com.diboot.scheduler.service.impl;

import com.diboot.core.exception.BusinessException;
import com.diboot.core.util.BeanUtils;
import com.diboot.core.util.ContextHolder;
import com.diboot.core.util.JSON;
import com.diboot.core.util.V;
import com.diboot.core.vo.Status;
import com.diboot.scheduler.annotation.CollectThisJob;
import com.diboot.scheduler.entity.ScheduleJob;
import com.diboot.scheduler.service.QuartzSchedulerService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.Job;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;
import org.quartz.impl.matchers.GroupMatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class QuartzSchedulerServiceImpl
implements QuartzSchedulerService {
    private static final Logger log = LoggerFactory.getLogger(QuartzSchedulerServiceImpl.class);
    public static final List<Map<String, Object>> CACHE_JOB = new ArrayList<Map<String, Object>>();
    @Autowired
    private Scheduler scheduler;

    @PostConstruct
    public void startScheduler() {
        try {
            this.scheduler.start();
        }
        catch (SchedulerException e) {
            log.error("\u5b9a\u65f6\u4efb\u52a1scheduler\u521d\u59cb\u5316\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\uff01", (Throwable)e);
        }
    }

    @Override
    public List<Map<String, Object>> loadAllJobs() {
        if (V.notEmpty(CACHE_JOB)) {
            return CACHE_JOB;
        }
        List annoJobList = ContextHolder.getBeansByAnnotation(CollectThisJob.class);
        if (V.notEmpty((Collection)annoJobList)) {
            List<Map<String, Object>> result = this.loadJobs(annoJobList);
            CACHE_JOB.addAll(result);
        }
        return CACHE_JOB;
    }

    private List<Map<String, Object>> loadJobs(List<Object> annoJobList) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        for (Object job : annoJobList) {
            if (!(job instanceof Job)) {
                log.warn("\u65e0\u6548\u7684job\u4efb\u52a1: {}", job.getClass());
                continue;
            }
            HashMap<String, Object> temp = new HashMap<String, Object>(8);
            Class targetClass = BeanUtils.getTargetClass((Object)job);
            CollectThisJob annotation = targetClass.getAnnotation(CollectThisJob.class);
            temp.put("jobKey", targetClass.getSimpleName());
            temp.put("jobCron", annotation.cron());
            temp.put("jobName", annotation.name());
            temp.put("jobClass", targetClass);
            Class<?> paramClass = annotation.paramClass();
            String paramJsonExample = annotation.paramJson();
            if (V.isEmpty((String)paramJsonExample) && !Object.class.getTypeName().equals(paramClass.getTypeName())) {
                try {
                    paramJsonExample = JSON.stringify(paramClass.newInstance());
                }
                catch (Exception e) {
                    log.error("job\u4efb\u52a1\uff1a{}, Scheduled#paramClass\u53c2\u6570\u4efb\u52a1\u65e0\u6548\uff0c\u5efa\u8bae\u4f7f\u7528Scheduled#paramJson\u53c2\u6570\u66ff\u6362\uff01", job.getClass());
                }
            }
            temp.put("paramJsonExample", paramJsonExample);
            result.add(temp);
        }
        return result;
    }

    @Override
    public List<Map<String, Object>> loadJobsInScheduler() {
        ArrayList jobList = null;
        try {
            Set jobKeys = this.scheduler.getJobKeys(GroupMatcher.anyJobGroup());
            jobList = new ArrayList();
            for (JobKey jobKey : jobKeys) {
                List triggers = this.scheduler.getTriggersOfJob(jobKey);
                for (Trigger trigger : triggers) {
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("jobName", jobKey.getName());
                    map.put("jobGroupName", jobKey.getGroup());
                    map.put("description", (String)trigger.getKey());
                    Trigger.TriggerState triggerState = this.scheduler.getTriggerState(trigger.getKey());
                    map.put("jobStatus", triggerState.name());
                    if (trigger instanceof CronTrigger) {
                        CronTrigger cronTrigger = (CronTrigger)trigger;
                        String cronExpression = cronTrigger.getCronExpression();
                        map.put("jobTime", cronExpression);
                    }
                    jobList.add(map);
                }
            }
        }
        catch (SchedulerException e) {
            log.error("\u52a0\u8f7d\u5168\u90e8Job\u5f02\u5e38", (Throwable)e);
        }
        return jobList;
    }

    @Override
    public void addJob(ScheduleJob job) {
        TriggerKey triggerKey = TriggerKey.triggerKey((String)((String)((Object)job.getId())).toString());
        JobDetail jobDetail = JobBuilder.newJob(this.getJobClass(job.getJobKey())).withIdentity(((String)((Object)job.getId())).toString()).build();
        if (V.notEmpty((String)job.getParamJson())) {
            Map jsonData = JSON.toMap((String)job.getParamJson());
            jobDetail.getJobDataMap().putAll(jsonData);
        }
        try {
            CronScheduleBuilder cronScheduleBuilder = CronScheduleBuilder.cronSchedule((String)job.getCron());
            if (INIT_STRATEGY.FIRE_AND_PROCEED.name().equals(job.getInitStrategy())) {
                cronScheduleBuilder.withMisfireHandlingInstructionFireAndProceed();
            } else if (INIT_STRATEGY.IGNORE_MISFIRES.name().equals(job.getInitStrategy())) {
                cronScheduleBuilder.withMisfireHandlingInstructionIgnoreMisfires();
            }
            Trigger trigger = TriggerBuilder.newTrigger().withIdentity(triggerKey).withSchedule((ScheduleBuilder)cronScheduleBuilder).build();
            this.scheduler.scheduleJob(jobDetail, trigger);
        }
        catch (Exception e) {
            log.error("\u6dfb\u52a0\u5b9a\u65f6\u4efb\u52a1\u5f02\u5e38", (Throwable)e);
            throw new BusinessException(Status.FAIL_OPERATION, (Throwable)e, "\u6dfb\u52a0\u5b9a\u65f6\u4efb\u52a1\u5f02\u5e38", new Object[0]);
        }
    }

    @Override
    public void addJobExecuteOnce(ScheduleJob job) {
        TriggerKey triggerKey = TriggerKey.triggerKey((String)((String)((Object)job.getId())).toString());
        JobDetail jobDetail = JobBuilder.newJob(this.getJobClass(job.getJobKey())).withIdentity(((String)((Object)job.getId())).toString()).build();
        if (V.notEmpty((String)job.getParamJson())) {
            Map jsonData = JSON.toMap((String)job.getParamJson());
            jobDetail.getJobDataMap().putAll(jsonData);
        }
        try {
            Trigger trigger = TriggerBuilder.newTrigger().withIdentity(triggerKey).withSchedule((ScheduleBuilder)SimpleScheduleBuilder.simpleSchedule().withRepeatCount(0)).build();
            this.scheduler.scheduleJob(jobDetail, trigger);
        }
        catch (Exception e) {
            log.error("\u6dfb\u52a0\u5b9a\u65f6\u4efb\u52a1\u5f02\u5e38", (Throwable)e);
            throw new BusinessException(Status.FAIL_OPERATION, (Throwable)e, "\u6dfb\u52a0\u5b9a\u65f6\u4efb\u52a1\u5f02\u5e38", new Object[0]);
        }
    }

    @Override
    public void runJob(String jobId) {
        try {
            this.scheduler.triggerJob(JobKey.jobKey((String)jobId.toString()));
        }
        catch (SchedulerException e) {
            log.error("\u8fd0\u884cjob\u5f02\u5e38", (Throwable)e);
        }
    }

    @Override
    public void pauseJob(String jobId) {
        try {
            this.scheduler.pauseJob(JobKey.jobKey((String)jobId.toString()));
        }
        catch (Exception e) {
            log.error("\u6682\u505cjob\u5f02\u5e38", (Throwable)e);
        }
    }

    @Override
    public void resumeJob(String jobId) {
        try {
            this.scheduler.resumeJob(JobKey.jobKey((String)jobId.toString()));
        }
        catch (SchedulerException e) {
            log.error("\u6062\u590djob\u5f02\u5e38", (Throwable)e);
        }
    }

    @Override
    public void deleteJob(String jobId) {
        TriggerKey triggerKey = TriggerKey.triggerKey((String)jobId.toString());
        try {
            this.scheduler.pauseTrigger(triggerKey);
            this.scheduler.unscheduleJob(triggerKey);
            this.scheduler.deleteJob(JobKey.jobKey((String)jobId.toString()));
        }
        catch (Exception e) {
            log.error("\u5220\u9664job\u5f02\u5e38", (Throwable)e);
        }
    }

    @Override
    public void updateJobCron(String jobId, String cron) {
        TriggerKey triggerKey = TriggerKey.triggerKey((String)jobId.toString());
        try {
            Trigger trigger = this.scheduler.getTrigger(triggerKey);
            CronTrigger cronTrigger = (CronTrigger)trigger;
            if (!cronTrigger.getCronExpression().equals(cron)) {
                cronTrigger = (CronTrigger)TriggerBuilder.newTrigger().withIdentity(triggerKey).withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)cron)).startNow().build();
                this.scheduler.rescheduleJob(triggerKey, (Trigger)cronTrigger);
            }
        }
        catch (Exception e) {
            log.error("\u66f4\u65b0job\u7684cron\u5b9a\u65f6\u8868\u8fbe\u5f0f\u5f02\u5e38", (Throwable)e);
        }
    }

    @Override
    public boolean existJob(String jobId) {
        TriggerKey triggerKey = TriggerKey.triggerKey((String)jobId.toString());
        try {
            Trigger trigger = this.scheduler.getTrigger(triggerKey);
            return V.notEmpty((Object)trigger);
        }
        catch (SchedulerException e) {
            e.printStackTrace();
            return false;
        }
    }

    public Class<? extends Job> getJobClass(String jobKey) {
        try {
            Class jobClass = this.loadAllJobs().stream().filter(e -> String.valueOf(e.get("jobKey")).equals(jobKey)).map(e -> (Class)e.get("jobClass")).findAny().orElse(null);
            if (jobClass == null) {
                throw new BusinessException(Status.FAIL_INVALID_PARAM, "\u975e\u6cd5\u7684\u5b9a\u65f6\u4efb\u52a1!" + jobKey, new Object[0]);
            }
            return jobClass;
        }
        catch (Exception e2) {
            throw new BusinessException(Status.FAIL_OPERATION, "\u5b9a\u65f6\u4efb\u52a1\u52a0\u8f7d\u5931\u8d25\uff01", new Object[]{e2});
        }
    }

    static enum INIT_STRATEGY {
        DO_NOTHING,
        FIRE_AND_PROCEED,
        IGNORE_MISFIRES;

    }
}

