/*
 * Decompiled with CFR 0.152.
 */
package com.diboot.scheduler.job;

import com.diboot.core.util.SqlExecutor;
import com.diboot.scheduler.annotation.CollectThisJob;
import java.time.LocalDateTime;
import java.util.ArrayList;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.quartz.QuartzJobBean;

@DisallowConcurrentExecution
@CollectThisJob(name="\u6e05\u9664\u8fc7\u671f\u64cd\u4f5c\u65e5\u5fd7", paramJson="{\"daysBefore\":30}", cron="0 0 1 * * ?")
public class ClearOperationLogJob
extends QuartzJobBean {
    private static final Logger log = LoggerFactory.getLogger(ClearOperationLogJob.class);
    private static final String SQL = "DELETE FROM dbt_iam_operation_log WHERE create_time <= ?";
    private static final String PARAM_KEY_DAYS_BEFORE = "daysBefore";

    protected void executeInternal(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        JobDataMap jobDataMap = jobExecutionContext.getJobDetail().getJobDataMap();
        int days = 30;
        if (jobDataMap.containsKey((Object)PARAM_KEY_DAYS_BEFORE)) {
            days = jobDataMap.getInt(PARAM_KEY_DAYS_BEFORE);
        }
        ArrayList<LocalDateTime> params = new ArrayList<LocalDateTime>(1);
        params.add(LocalDateTime.now().minusDays(days));
        try {
            SqlExecutor.executeUpdate((String)SQL, params);
        }
        catch (Exception e) {
            log.error("ClearOperationLogJob\u6267\u884c\u5f02\u5e38", (Throwable)e);
            throw new JobExecutionException((Throwable)e);
        }
        log.info("ClearOperationLogJob\u6210\u529f\u6e05\u7406{}\u5929\u4e4b\u524d\u7684\u64cd\u4f5c\u65e5\u5fd7", (Object)days);
    }
}

