/*
 * Decompiled with CFR 0.152.
 */
package com.diboot.scheduler.init;

import com.diboot.core.entity.Dictionary;
import com.diboot.core.service.DictionaryService;
import com.diboot.core.util.ContextHolder;
import com.diboot.core.util.JSON;
import com.diboot.core.util.SqlFileInitializer;
import com.diboot.core.vo.DictionaryVO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Order(value=951)
@Component
@ConditionalOnProperty(prefix="diboot", name={"init-sql"}, havingValue="true")
public class SchedulerPluginInitializer
implements ApplicationRunner {
    private static final Logger log = LoggerFactory.getLogger(SchedulerPluginInitializer.class);

    public void run(ApplicationArguments args) throws Exception {
        String initDetectSql = "SELECT id FROM dbt_schedule_job WHERE id='0'";
        if (!SqlFileInitializer.checkSqlExecutable((String)initDetectSql)) {
            log.info("diboot-scheduler \u521d\u59cb\u5316SQL ...");
            SqlFileInitializer.initBootstrapSql(this.getClass(), (String)"scheduler");
            this.insertInitData();
            log.info("diboot-scheduler \u521d\u59cb\u5316SQL\u5b8c\u6210.");
        }
    }

    private void insertInitData() {
        DictionaryService dictionaryService = (DictionaryService)ContextHolder.getBean(DictionaryService.class);
        if (dictionaryService != null && !dictionaryService.exists(Dictionary::getType, (Object)"MESSAGE_CHANNEL")) {
            String[] DICT_INIT_DATA;
            for (String dictJson : DICT_INIT_DATA = new String[]{"{\"type\":\"INIT_STRATEGY\",\"itemName\":\"\u5b9a\u65f6\u4efb\u52a1\u521d\u59cb\u5316\u7b56\u7565\",\"description\":\"\u5b9a\u65f6\u4efb\u52a1\u521d\u59cb\u5316\u7b56\u7565\u5b9a\u4e49\",\"isEditable\":true,\"children\":[{\"itemName\":\"\u5468\u671f\u6267\u884c\",\"itemValue\":\"DO_NOTHING\",\"sortId\":1},{\"itemName\":\"\u7acb\u5373\u6267\u884c\u4e00\u6b21\uff0c\u5e76\u5468\u671f\u6267\u884c\",\"itemValue\":\"EFIRE_AND_PROCEED2\",\"sortId\":2},{\"itemName\":\"\u8d85\u671f\u7acb\u5373\u6267\u884c\uff0c\u5e76\u5468\u671f\u6267\u884c\",\"itemValue\":\"IGNORE_MISFIRES\",\"sortId\":3}]}"}) {
                DictionaryVO dictVo = (DictionaryVO)JSON.toJavaObject((String)dictJson, DictionaryVO.class);
                dictionaryService.createDictAndChildren(dictVo);
            }
        }
    }
}

