/*
 * Decompiled with CFR 0.152.
 */
package com.diboot.scheduler.init;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.diboot.core.config.Cons;
import com.diboot.core.util.V;
import com.diboot.scheduler.entity.ScheduleJob;
import com.diboot.scheduler.service.QuartzSchedulerService;
import com.diboot.scheduler.service.ScheduleJobService;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Order(value=952)
@Component
@ConditionalOnProperty(prefix="spring.quartz", name={"job-store-type"}, havingValue="MEMORY", matchIfMissing=true)
public class SchedulerJobInitializer
implements ApplicationRunner {
    private static final Logger log = LoggerFactory.getLogger(SchedulerJobInitializer.class);
    @Autowired
    private ScheduleJobService scheduleJobService;
    @Autowired
    private QuartzSchedulerService quartzSchedulerService;

    public void run(ApplicationArguments args) {
        List jobList = this.scheduleJobService.getEntityList((Wrapper)Wrappers.lambdaQuery().eq(ScheduleJob::getJobStatus, (Object)Cons.ENABLE_STATUS.A.name()));
        if (V.isEmpty((Collection)jobList)) {
            return;
        }
        jobList.forEach(scheduleJob -> {
            try {
                this.quartzSchedulerService.addJob((ScheduleJob)((Object)scheduleJob));
            }
            catch (Exception e) {
                log.error("\u5b9a\u65f6\u4efb\u52a1\uff1ajobKey={}\uff0c\u521d\u59cb\u5316\u52a0\u8f7d\u5931\u8d25\uff01", (Object)scheduleJob.getJobKey(), (Object)e);
            }
        });
    }
}

