/*
 * Decompiled with CFR 0.152.
 */
package com.diboot.scheduler.handler;

import com.diboot.core.config.Cons;
import com.diboot.core.util.S;
import com.diboot.core.util.V;
import com.diboot.core.vo.Status;
import com.diboot.scheduler.entity.ScheduleJobLog;
import com.diboot.scheduler.handler.SchedulerAsyncWorker;
import java.time.Duration;
import java.time.LocalDateTime;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.quartz.JobExecutionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class JobAspect {
    private static final Logger log = LoggerFactory.getLogger(JobAspect.class);
    @Autowired
    private SchedulerAsyncWorker schedulerAsyncWorker;
    private static final int MAX_LENGTH = 500;

    @Pointcut(value="execution(void *.execute*(org.quartz.JobExecutionContext))")
    public void pointCut() {
    }

    @Around(value="pointCut()")
    public void afterHandler(ProceedingJoinPoint joinPoint) {
        ScheduleJobLog jobLog = new ScheduleJobLog();
        jobLog.setJobId(Long.valueOf(((JobExecutionContext)joinPoint.getArgs()[0]).getJobDetail().getKey().getName()));
        try {
            jobLog.setStartTime(LocalDateTime.now());
            joinPoint.proceed(joinPoint.getArgs());
            jobLog.setEndTime(LocalDateTime.now());
            Duration duration = Duration.between(jobLog.getStartTime(), jobLog.getEndTime());
            jobLog.setElapsedSeconds(duration.getSeconds()).setRunStatus(Cons.RESULT_STATUS.S.name()).setExecuteMsg("\u6267\u884c\u6210\u529f");
        }
        catch (Throwable throwable) {
            log.error("\u5b9a\u65f6\u4efb\u52a1\u6267\u884c\u5f02\u5e38", throwable);
            String errorMsg = throwable.toString();
            Object[] stackTraceElements = throwable.getStackTrace();
            if (V.notEmpty((Object[])stackTraceElements)) {
                errorMsg = errorMsg + " : " + ((StackTraceElement)stackTraceElements[0]).toString();
            }
            errorMsg = S.cut((String)(Status.FAIL_EXCEPTION.code() + ":" + errorMsg), (int)500);
            jobLog.setRunStatus(Cons.RESULT_STATUS.F.name()).setExecuteMsg(errorMsg);
        }
        this.schedulerAsyncWorker.saveScheduleJobLog(jobLog);
    }
}

