/*
 * Decompiled with CFR 0.152.
 */
package com.diboot.core.vo;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.diboot.core.util.S;
import com.diboot.core.util.V;
import com.diboot.core.vo.JsonResult;
import com.diboot.core.vo.Pagination;
import java.util.ArrayList;
import java.util.List;

public class PagingJsonResult<T>
extends JsonResult<T> {
    private static final long serialVersionUID = 1002L;
    private Pagination page;

    public PagingJsonResult() {
    }

    public PagingJsonResult(T data) {
        this.data(data);
    }

    public PagingJsonResult(JsonResult<T> jsonResult, Pagination pagination) {
        super(jsonResult.getCode(), jsonResult.getMsg(), jsonResult.getData());
        this.page = pagination;
    }

    public PagingJsonResult(IPage<?> iPage) {
        Pagination pagination = new Pagination();
        pagination.setPageIndex((int)iPage.getCurrent());
        pagination.setPageSize((int)iPage.getSize());
        pagination.setTotalCount(iPage.getTotal());
        if (V.notEmpty(iPage.orders())) {
            ArrayList orderByList = new ArrayList();
            iPage.orders().stream().forEach(o -> {
                if (o.isAsc()) {
                    orderByList.add(o.getColumn());
                } else {
                    orderByList.add(o.getColumn() + ":" + "DESC");
                }
            });
            pagination.setOrderBy(S.join(orderByList));
        }
        this.page = pagination;
        List data = iPage.getRecords();
        this.data(data);
    }

    public PagingJsonResult setPage(Pagination pagination) {
        this.page = pagination;
        return this;
    }

    public Pagination getPage() {
        return this.page;
    }
}

