/*
 * Decompiled with CFR 0.152.
 */
package com.diboot.core.util.sql;

import com.diboot.core.util.S;
import com.diboot.core.util.sql.BaseTranslator;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OracleTranslator
extends BaseTranslator {
    private static final Logger log = LoggerFactory.getLogger(OracleTranslator.class);

    public OracleTranslator() {
    }

    public OracleTranslator(List<String> keywords) {
        this.ESCAPE_KEYWORDS.addAll(keywords);
    }

    @Override
    protected List<String> formatStatements(List<String> otherStatements) {
        return otherStatements.stream().map(s -> S.substringBefore((String)s, (String)";")).collect(Collectors.toList());
    }

    @Override
    protected String translateColDefineSql(String colDefineSql) {
        colDefineSql = S.replaceEach((String)colDefineSql, (String[])new String[]{" tinyint(1)", " tinyint", "varchar(", " datetime ", " bigint ", " json ", " JSON ", " text"}, (String[])new String[]{" NUMBER(1)", " NUMBER(1)", "VARCHAR2(", " TIMESTAMP ", " NUMBER(20) ", " VARCHAR2(1000) ", " VARCHAR2(1000) ", " CLOB"});
        colDefineSql = S.replaceEach((String)colDefineSql, (String[])new String[]{"datetime"}, (String[])new String[]{"timestamp"});
        if (S.contains((CharSequence)(colDefineSql = S.replace((String)colDefineSql, (String)" default ", (String)" DEFAULT ")), (CharSequence)" DEFAULT ")) {
            String prefix = S.substringBefore((String)colDefineSql, (String)" DEFAULT ") + " ";
            String suffix = S.substringAfter((String)colDefineSql, (String)" DEFAULT ");
            String defValue = S.substringBefore((String)suffix.trim(), (String)" ");
            suffix = S.substringAfter((String)suffix.trim(), (String)" ");
            if (S.contains((CharSequence)(prefix = S.replaceEach((String)prefix, (String[])new String[]{" not null ", " null "}, (String[])new String[]{" NOT NULL ", " NULL "})), (CharSequence)" NOT NULL ")) {
                colDefineSql = S.substringBefore((String)prefix, (String)" NOT NULL ") + " DEFAULT " + defValue + " NOT NULL " + S.substringAfter((String)prefix, (String)" NOT NULL ") + suffix;
            } else if (S.contains((CharSequence)prefix, (CharSequence)" NULL ")) {
                colDefineSql = S.substringBefore((String)prefix, (String)" NULL ") + " DEFAULT " + defValue + " NULL " + S.substringAfter((String)prefix, (String)" NULL ") + suffix;
            }
        }
        return this.escapeKeyword(colDefineSql);
    }

    @Override
    protected List<String> translateInsertValues(String insertSql) {
        ArrayList<String> batchInsertSqls = new ArrayList<String>();
        String insertIntoPrefix = S.substringBefore((String)(insertSql = S.removeDuplicateBlank(insertSql).trim()), (String)"VALUES") + "VALUES";
        if (insertIntoPrefix.contains("`")) {
            for (String key : this.ESCAPE_KEYWORDS) {
                if (!insertIntoPrefix.contains("`" + key + "`")) continue;
                insertIntoPrefix = S.replace((String)insertIntoPrefix, (String)("`" + key + "`"), (String)("\"" + key.toUpperCase() + "\""));
            }
        }
        insertIntoPrefix = this.escapeKeyword(insertIntoPrefix);
        String cols = S.substringBetween((String)insertIntoPrefix, (String)"(", (String)")").replace("`", "");
        String[] columns = S.split((String)cols, (String)",");
        String table = S.substringBetween((String)insertIntoPrefix, (String)" INTO ", (String)"(").trim().replace("`", "");
        Map col2TypeMap = (Map)table2ColumnTypeMap.get(table);
        String suffix = S.substringAfter((String)insertSql, (String)"VALUES");
        while (S.contains((CharSequence)suffix, (CharSequence)"(")) {
            suffix = S.substringAfter((String)suffix, (String)"(");
            StringBuilder rowSqlSb = new StringBuilder(insertIntoPrefix).append("(");
            ArrayList<Object> newValues = new ArrayList<Object>(columns.length);
            ArrayList<String> colValues = new ArrayList<String>(columns.length);
            String record = S.substringBefore((String)suffix, (String)")");
            while (S.contains((CharSequence)record, (CharSequence)",")) {
                String value;
                if ((record = record.trim()).startsWith("'")) {
                    value = S.substringBetween((String)record, (String)"'", (String)"'");
                    value = "'" + value + "'";
                    record = S.substringAfter((String)record, (String)"'");
                    record = S.substringAfter((String)record, (String)"'");
                } else {
                    value = S.substringBefore((String)record, (String)",").trim();
                }
                record = S.substringAfter((String)record, (String)",").trim();
                colValues.add(value);
                if (S.contains((CharSequence)record, (CharSequence)",")) continue;
                if (record.startsWith("'")) {
                    value = S.substringBetween((String)record, (String)"'", (String)"'");
                    value = "'" + value + "'";
                } else {
                    value = record.trim();
                }
                colValues.add(value);
            }
            for (int i = 0; i < columns.length; ++i) {
                String colType = (String)col2TypeMap.get(columns[i].trim());
                newValues.add(this.translateValue(colType, (String)colValues.get(i)));
            }
            rowSqlSb.append(S.join(newValues)).append(")");
            batchInsertSqls.add(rowSqlSb.toString());
        }
        return batchInsertSqls;
    }

    @Override
    protected Object translateValue(String colType, String value) {
        if (S.containsIgnoreCase((CharSequence)colType, (CharSequence)" BLOB")) {
            return "rawtohex(" + value + ")";
        }
        if (S.containsIgnoreCase((CharSequence)colType, (CharSequence)" TIMESTAMP")) {
            return "CURRENT_TIMESTAMP";
        }
        return value;
    }

    @Override
    protected String escapeKeyword(String input) {
        if (input.contains("`")) {
            String key = S.substringBetween((String)input, (String)"`", (String)"`");
            if (this.ESCAPE_KEYWORDS.contains(key)) {
                return S.replace((String)input, (String)("`" + key + "`"), (String)("\"" + key.toUpperCase() + "\""));
            }
            return S.replace((String)input, (String)"`", (String)"");
        }
        return input;
    }
}

