/*
 * Decompiled with CFR 0.152.
 */
package com.diboot.core.util.sql;

import com.diboot.core.exception.BusinessException;
import com.diboot.core.exception.InvalidUsageException;
import com.diboot.core.util.S;
import com.diboot.core.util.V;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseTranslator {
    private static final Logger log = LoggerFactory.getLogger(BaseTranslator.class);
    protected List<String> ESCAPE_KEYWORDS = Arrays.asList("key", "level");
    protected static Map<String, Map<String, String>> table2ColumnTypeMap = new HashMap<String, Map<String, String>>();

    public List<String> translate(List<String> mysqlStatements) {
        if (V.isEmpty(mysqlStatements)) {
            return Collections.emptyList();
        }
        ArrayList<String> otherStatements = new ArrayList<String>();
        mysqlStatements.forEach(stmt -> {
            if (S.containsIgnoreCase((CharSequence)stmt, (CharSequence)"CREATE TABLE ")) {
                List<String> createTableStatements = this.translateCreateTableDDL((String)stmt);
                otherStatements.addAll(createTableStatements);
            } else if (S.containsIgnoreCase((CharSequence)stmt, (CharSequence)"CREATE INDEX ")) {
                otherStatements.add(this.translateCreateIndexDDL((String)stmt));
            } else if (S.containsIgnoreCase((CharSequence)stmt, (CharSequence)"INSERT INTO ")) {
                otherStatements.addAll(this.translateInsertValues((String)stmt));
            } else if (V.notEmpty(stmt)) {
                throw new InvalidUsageException("\u6682\u4e0d\u652f\u6301\u8be5SQL\u7ffb\u8bd1\uff1a{}", stmt);
            }
        });
        log.debug("\u8f6c\u6362\u521d\u59cb\u5316SQL\uff1a{}", otherStatements);
        return this.formatStatements(otherStatements);
    }

    protected List<String> formatStatements(List<String> otherStatements) {
        return otherStatements;
    }

    private List<String> translateCreateTableDDL(String mysqlDDL) {
        String tableCommentSql;
        ArrayList<String> newSqls = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        String newSql = S.removeDuplicateBlank(mysqlDDL).replaceAll(" comment ", " COMMENT ");
        String begin = S.substringBefore((String)newSql, (String)"(").trim();
        String table = S.substringAfterLast((String)begin, (String)" ");
        String cleanTableName = table.replace("`", "");
        sb.append(this.escapeKeyword(begin)).append("(");
        String body = S.substringAfter((String)newSql, (String)"(");
        body = S.substringBeforeLast((String)body, (String)")");
        ArrayList newColDefines = new ArrayList();
        ArrayList newColComments = new ArrayList();
        List<String> columns = S.splitToList(body);
        HashMap column2TypeMap = new HashMap();
        columns.forEach(col -> {
            if (S.containsIgnoreCase((CharSequence)(col = S.replace((String)col, (String)"\n", (String)"").trim()), (CharSequence)"unsigned")) {
                col = S.replaceIgnoreCase((String)col, (String)" unsigned ", (String)" ");
            }
            if (S.containsIgnoreCase((CharSequence)col, (CharSequence)"AUTO_INCREMENT")) {
                col = S.replaceIgnoreCase((String)col, (String)" AUTO_INCREMENT ", (String)" ");
            }
            col = S.replaceIgnoreCase((String)col, (String)" ON UPDATE CURRENT_TIMESTAMP", (String)"");
            String colName = S.substringBefore((String)col, (String)" ");
            String comment = this.extractCommentLabel((String)col);
            String cleanCol = S.removeDuplicateBlank(S.removeDuplicateBlank(col = S.substringBefore((String)col, (String)"COMMENT").trim())).replace("`", "");
            if (!S.containsIgnoreCase((CharSequence)cleanCol, (CharSequence)"PRIMARY KEY (id)")) {
                String columnCommentSql;
                String cleanColName = colName.replace("`", "");
                if (cleanColName.equals("id") && !S.containsIgnoreCase((CharSequence)cleanCol, (CharSequence)"PRIMARY KEY")) {
                    col = col + " PRIMARY KEY";
                }
                String colDefineStmt = this.translateColDefineSql((String)col);
                newColDefines.add(colDefineStmt);
                if (V.notEmpty(comment) && (columnCommentSql = this.buildColumnCommentSql(cleanTableName, colName, comment)) != null) {
                    newColComments.add(columnCommentSql);
                }
                column2TypeMap.put(cleanColName, colDefineStmt);
            }
        });
        String comment = S.substringAfterLast((String)newSql, (String)")");
        comment = this.extractCommentLabel(comment);
        sb.append(S.join(newColDefines, (String)", ")).append(");");
        newSqls.add(sb.toString());
        newSqls.addAll(newColComments);
        if (V.notEmpty(comment) && (tableCommentSql = this.buildTableCommentSql(table, comment)) != null) {
            newSqls.add(tableCommentSql);
        }
        table2ColumnTypeMap.put(cleanTableName, column2TypeMap);
        return newSqls;
    }

    protected abstract String translateColDefineSql(String var1);

    protected String translateCreateIndexDDL(String mysqlDDL) {
        String createIndex = S.removeDuplicateBlank(mysqlDDL).trim();
        if (!createIndex.endsWith(";")) {
            createIndex = createIndex + ";";
        }
        return this.escapeKeyword(createIndex);
    }

    protected String escapeKeyword(String input) {
        return input.replace("`", "");
    }

    protected List<String> translateInsertValues(String insertSql) {
        insertSql = S.removeDuplicateBlank(insertSql).trim();
        String prefix = S.substringBefore((String)insertSql, (String)"VALUES");
        StringBuilder sb = new StringBuilder(this.escapeKeyword(prefix)).append("VALUES");
        String cols = S.substringBetween((String)prefix, (String)"(", (String)")").replace("`", "");
        String[] columns = S.split((String)cols, (String)",");
        String table = S.substringBetween((String)prefix, (String)" INTO ", (String)"(").trim().replace("`", "");
        Map<String, String> col2TypeMap = table2ColumnTypeMap.get(table);
        if (col2TypeMap == null) {
            throw new BusinessException(table + " \u65e0\u7f13\u5b58\u4fe1\u606f\uff01", new Object[0]);
        }
        String suffix = S.substringAfter((String)insertSql, (String)"VALUES");
        while (S.contains((CharSequence)suffix, (CharSequence)"(")) {
            suffix = S.substringAfter((String)suffix, (String)"(");
            sb.append("(");
            ArrayList<Object> newValues = new ArrayList<Object>(columns.length);
            ArrayList<String> colValues = new ArrayList<String>(columns.length);
            String record = S.substringBefore((String)suffix, (String)")");
            while (S.contains((CharSequence)record, (CharSequence)",")) {
                String value;
                if ((record = record.trim()).startsWith("'")) {
                    value = S.substringBetween((String)record, (String)"'", (String)"'");
                    value = "'" + value + "'";
                    record = S.substringAfter((String)record, (String)"'");
                    record = S.substringAfter((String)record, (String)"'");
                } else {
                    value = S.substringBefore((String)record, (String)",").trim();
                }
                record = S.substringAfter((String)record, (String)",").trim();
                colValues.add(value);
                if (S.contains((CharSequence)record, (CharSequence)",")) continue;
                if (record.startsWith("'")) {
                    value = S.substringBetween((String)record, (String)"'", (String)"'");
                    value = "'" + value + "'";
                } else {
                    value = record.trim();
                }
                colValues.add(value);
            }
            for (int i = 0; i < columns.length; ++i) {
                String colType = col2TypeMap.get(columns[i].trim());
                newValues.add(this.translateValue(colType, (String)colValues.get(i)));
            }
            sb.append(S.join(newValues));
            sb.append(")");
            if (S.contains((CharSequence)suffix, (CharSequence)"(")) {
                sb.append(",");
                continue;
            }
            sb.append(";");
        }
        return Collections.singletonList(sb.toString());
    }

    protected Object translateValue(String colDefine, String value) {
        return value;
    }

    protected String buildColumnCommentSql(String table, String colName, String comment) {
        return "comment on column " + table + "." + this.escapeKeyword(colName) + " is '" + comment + "';";
    }

    protected String buildTableCommentSql(String table, String comment) {
        return "comment on table " + this.escapeKeyword(table) + " is '" + comment + "';";
    }

    private String extractCommentLabel(String comment) {
        if (!S.containsIgnoreCase((CharSequence)comment, (CharSequence)"COMMENT")) {
            return null;
        }
        comment = S.substringAfter((String)comment, (String)"COMMENT").trim();
        return S.substringBetween((String)comment, (String)"'", (String)"'").trim();
    }
}

